/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.spatial;

import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.MultiValuedFilter;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.filter.spatial.AbstractPreparedGeometryFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public class IntersectsImpl
extends AbstractPreparedGeometryFilter
implements Intersects {
    public IntersectsImpl(Expression e1, Expression e2) {
        super(e1, e2);
    }

    public IntersectsImpl(Expression e1, Expression e2, MultiValuedFilter.MatchAction matchAction) {
        super(e1, e2, matchAction);
    }

    @Override
    public boolean evaluateInternal(Geometry left, Geometry right) {
        switch (this.literals) {
            case BOTH: {
                return this.cacheValue;
            }
            case RIGHT: {
                return this.rightPreppedGeom.intersects(left);
            }
            case LEFT: {
                return this.leftPreppedGeom.intersects(right);
            }
        }
        return this.basicEvaluate(left, right);
    }

    public Object accept(FilterVisitor visitor, Object extraData) {
        return visitor.visit((Intersects)this, extraData);
    }

    @Override
    protected final boolean basicEvaluate(Geometry left, Geometry right) {
        Envelope envLeft = left.getEnvelopeInternal();
        Envelope envRight = right.getEnvelopeInternal();
        return envRight.intersects(envLeft) && left.intersects(right);
    }
}

