/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.licenselib;

import de.wideportal.maprender.licenselib.LicenseContainer;
import de.wideportal.maprender.licenselib.xml.LicenseConfigurationRoot;
import java.io.File;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseSaver {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public void saveLicense(String licenseFileString, LicenseContainer license) throws Exception {
        this.log.info("saveLicense: start saving license: " + licenseFileString);
        File licenseFile = new File(licenseFileString);
        File parentFolder = licenseFile.getParentFile();
        File signedLicenseFile = new File(parentFolder.getAbsolutePath() + "/license-signed.xml");
        this.marshallLicenseToFile(signedLicenseFile, license);
        this.log.info("loadLicense: finished saving license");
    }

    private void marshallLicenseToFile(File licenseFile, LicenseContainer license) throws Exception {
        this.log.info("marshallLicense: " + license);
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{LicenseConfigurationRoot.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.marshal((Object)license.getLicense(), licenseFile);
            this.log.info("marshallLicense: successfully mashalled license to file: " + licenseFile.getAbsolutePath());
        }
        catch (Exception e) {
            this.log.error("marshallLicense: could not marshal license", (Throwable)e);
            throw new Exception("Could not write the content of the license file: " + e.getMessage());
        }
    }
}

