/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.licenselib;

import de.wideportal.maprender.licenselib.xml.LicenseConfigurationEntry;
import de.wideportal.maprender.licenselib.xml.LicenseConfigurationOptional;
import de.wideportal.maprender.licenselib.xml.LicenseConfigurationRoot;
import java.awt.Point;
import java.util.Optional;

public class LicenseContainer {
    public static final String LICENSE_CONSTRICTION_TILES_MAX = "tiles-max";
    public static final String LICENSE_CONSTRICTION_FEATURE_HEIGHT = "feature-height";
    public static final String LICENSE_CONSTRICTION_FEATURE_KML = "feature-kml";
    public static final String LICENSE_CONSTRICTION_FEATURE_TILELOAD = "feature-tileload";
    private LicenseConfigurationRoot license;

    public LicenseContainer(LicenseConfigurationRoot license) {
        this.license = license;
    }

    public LicenseConfigurationRoot getLicense() {
        return this.license;
    }

    public Optional<LicenseConfigurationOptional> getOptionalLicenseEntries() {
        return Optional.ofNullable(this.license.getSource().getOptional());
    }

    public Optional<String> getOptionalLicenseEntry(String name) {
        LicenseConfigurationOptional optional = this.license.getSource().getOptional();
        if (optional != null) {
            for (LicenseConfigurationEntry entry : optional.getEntries()) {
                if (!entry.getName().equalsIgnoreCase(name)) continue;
                return Optional.of(entry.getValue());
            }
        }
        return Optional.empty();
    }

    public String getLicenseInformationAsString() {
        StringBuffer buffy = new StringBuffer();
        buffy.append("LicenseContainer[mandatory[customerId=");
        buffy.append(this.license.getSource().getMandatory().getCustomerId());
        buffy.append(",customer=");
        buffy.append(this.license.getSource().getMandatory().getCustomer());
        buffy.append(",email=");
        buffy.append(this.license.getSource().getMandatory().getEmail());
        buffy.append(",startDate=");
        buffy.append(this.license.getSource().getMandatory().getStartDate());
        buffy.append(",endDate=");
        buffy.append(this.license.getSource().getMandatory().getEndDate());
        buffy.append("],optional[");
        for (LicenseConfigurationEntry optionalEntry : this.license.getSource().getOptional().getEntries()) {
            buffy.append(optionalEntry.getName());
            buffy.append("=");
            buffy.append(optionalEntry.getValue());
            buffy.append(",");
        }
        buffy.append("]]");
        return buffy.toString();
    }

    public String toString() {
        return "LicenseContainer[license=" + this.license + "]";
    }

    protected boolean isStringNotNullNotEmpty(String test) {
        return test != null && !test.isBlank();
    }

    public String getFromOptionalOrElse(Optional<String> input, String otherwise) {
        if (input.isPresent()) {
            return input.get();
        }
        return otherwise;
    }

    public Boolean getFromOptionalOrElse(Optional<Boolean> input, boolean otherwise) {
        if (input.isPresent()) {
            return input.get();
        }
        return otherwise;
    }

    public Double getFromOptionalOrElse(Optional<Double> input, double otherwise) {
        if (input.isPresent()) {
            return input.get();
        }
        return otherwise;
    }

    public Float getFromOptionalOrElse(Optional<Float> input, float otherwise) {
        if (input.isPresent()) {
            return input.get();
        }
        return Float.valueOf(otherwise);
    }

    public Integer getFromOptionalOrElse(Optional<Integer> input, int otherwise) {
        if (input.isPresent()) {
            return input.get();
        }
        return otherwise;
    }

    public Point getFromOptionalOrElse(Optional<Point> input, Point otherwise) {
        if (input.isPresent()) {
            return input.get();
        }
        return otherwise;
    }

    public Optional<String> safeGetNonEmptyString(String value) {
        if (this.isStringNotNullNotEmpty(value)) {
            return Optional.ofNullable(value);
        }
        return Optional.empty();
    }

    public Optional<Double> safeParseDouble(String value) {
        if (this.isStringNotNullNotEmpty(value)) {
            return Optional.ofNullable(this.parseDouble(value));
        }
        return Optional.empty();
    }

    public Optional<Float> safeParseFloat(String value) {
        if (this.isStringNotNullNotEmpty(value)) {
            return Optional.ofNullable(this.parseFloat(value));
        }
        return Optional.empty();
    }

    public Optional<Integer> safeParseInteger(String value) {
        if (this.isStringNotNullNotEmpty(value)) {
            return Optional.ofNullable(this.parseInteger(value));
        }
        return Optional.empty();
    }

    public Optional<Boolean> safeParseBoolean(String value) {
        if (this.isStringNotNullNotEmpty(value)) {
            return Optional.ofNullable(this.parseBoolean(value));
        }
        return Optional.empty();
    }

    public Optional<Double> safeParseDouble(Optional<String> value) {
        if (!value.isPresent()) {
            return Optional.empty();
        }
        if (this.isStringNotNullNotEmpty(value.get())) {
            return Optional.ofNullable(this.parseDouble(value.get()));
        }
        return Optional.empty();
    }

    public Optional<Float> safeParseFloat(Optional<String> value) {
        if (!value.isPresent()) {
            return Optional.empty();
        }
        if (this.isStringNotNullNotEmpty(value.get())) {
            return Optional.ofNullable(this.parseFloat(value.get()));
        }
        return Optional.empty();
    }

    public Optional<Integer> safeParseInteger(Optional<String> value) {
        if (!value.isPresent()) {
            return Optional.empty();
        }
        if (this.isStringNotNullNotEmpty(value.get())) {
            return Optional.ofNullable(this.parseInteger(value.get()));
        }
        return Optional.empty();
    }

    public Optional<Boolean> safeParseBoolean(Optional<String> value) {
        if (!value.isPresent()) {
            return Optional.empty();
        }
        if (this.isStringNotNullNotEmpty(value.get())) {
            return Optional.ofNullable(this.parseBoolean(value.get()));
        }
        return Optional.empty();
    }

    public Double parseDouble(String value) {
        Double result = null;
        try {
            result = Double.parseDouble(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    public Float parseFloat(String value) {
        Float result = null;
        try {
            result = Float.valueOf(Float.parseFloat(value));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    public Integer parseInteger(String value) {
        Integer result = null;
        try {
            result = Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    public Boolean parseBoolean(String value) {
        Boolean result = null;
        try {
            result = Boolean.parseBoolean(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }
}

