/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.awt.geom.Path2D;
import org.openstreetmap.josm.actions.DownloadAlongAction;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.IGpxTrack;
import org.openstreetmap.josm.data.gpx.IGpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.gpx.DownloadAlongPanel;
import org.openstreetmap.josm.tools.I18n;

public class DownloadAlongTrackAction
extends DownloadAlongAction {
    private static final int NEAR_TRACK = 0;
    private static final int NEAR_WAYPOINTS = 1;
    private static final int NEAR_BOTH = 2;
    private static final String PREF_DOWNLOAD_ALONG_TRACK_OSM = "downloadAlongTrack.download.osm";
    private static final String PREF_DOWNLOAD_ALONG_TRACK_GPS = "downloadAlongTrack.download.gps";
    private static final String PREF_DOWNLOAD_ALONG_TRACK_DISTANCE = "downloadAlongTrack.distance";
    private static final String PREF_DOWNLOAD_ALONG_TRACK_AREA = "downloadAlongTrack.area";
    private static final String PREF_DOWNLOAD_ALONG_TRACK_NEAR = "downloadAlongTrack.near";
    private final transient GpxData data;

    public DownloadAlongTrackAction(GpxData data) {
        super(I18n.tr("Download from OSM along this track", new Object[0]), "downloadalongtrack", null, null, false);
        this.data = data;
    }

    @Override
    protected PleaseWaitRunnable createTask() {
        DownloadAlongPanel panel = new DownloadAlongPanel(PREF_DOWNLOAD_ALONG_TRACK_OSM, PREF_DOWNLOAD_ALONG_TRACK_GPS, PREF_DOWNLOAD_ALONG_TRACK_DISTANCE, PREF_DOWNLOAD_ALONG_TRACK_AREA, PREF_DOWNLOAD_ALONG_TRACK_NEAR);
        int ret = panel.showInDownloadDialog(I18n.tr("Download from OSM along this track", new Object[0]), HelpUtil.ht("/Action/DownloadAlongTrack"));
        if (0 != ret && 1 != ret) {
            return null;
        }
        int near = panel.getNear();
        Path2D.Double gpxPath = new Path2D.Double();
        if (near == 0 || near == 2) {
            for (IGpxTrack trk : this.data.tracks) {
                for (IGpxTrackSegment segment : trk.getSegments()) {
                    boolean first = true;
                    for (WayPoint p : segment.getWayPoints()) {
                        if (first) {
                            ((Path2D)gpxPath).moveTo(p.lon(), p.lat());
                            first = false;
                            continue;
                        }
                        ((Path2D)gpxPath).lineTo(p.lon(), p.lat());
                    }
                }
            }
        }
        if (near == 1 || near == 2) {
            for (WayPoint p : this.data.waypoints) {
                ((Path2D)gpxPath).moveTo(p.lon(), p.lat());
                gpxPath.closePath();
            }
        }
        return this.createCalcTask(gpxPath, panel, I18n.tr("Download from OSM along this track", new Object[0]), 1 == ret);
    }
}

