/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.util.color;

import de.wideportal.maprender.config.xml.osm.imagefilter.HslColor;
import java.awt.Color;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColorUtil {
    static Logger log = LoggerFactory.getLogger(ColorUtil.class);
    public static final Color COLOR_TRANSPARENT = new Color(1, 1, 1, 0);

    public static Color getColorFromString(String colorString) {
        if (colorString == null) {
            return null;
        }
        if (colorString.startsWith("#")) {
            Color staticColor = ColorUtil.getColorFromStatic(colorString);
            if (staticColor != null) {
                return staticColor;
            }
            return ColorUtil.getColorFromCss(colorString, 1.0f);
        }
        if (colorString.startsWith("rgba(")) {
            return ColorUtil.getColorFromRgba(colorString);
        }
        if (colorString.startsWith("rgb(")) {
            return ColorUtil.getColorFromRgb(colorString);
        }
        if (colorString.startsWith("hsla(")) {
            return ColorUtil.getColorFromHsla(colorString);
        }
        return null;
    }

    public static Color getColorFromHsla(String hslaColor) {
        if (hslaColor != null && !hslaColor.trim().isEmpty() && hslaColor.startsWith("hsla(")) {
            String colorPartString = hslaColor.substring(5, hslaColor.length() - 1);
            String[] colorParts = colorPartString.split(",");
            float hue = Float.parseFloat(colorParts[0]);
            float sat = Float.parseFloat(colorParts[1]);
            float lum = Float.parseFloat(colorParts[2]);
            float alpha = 255.0f;
            if (colorParts.length > 3) {
                alpha = ColorUtil.getColor01FromColor256(Float.parseFloat(colorParts[3]));
            }
            float[] hsla = new float[]{hue, sat, lum, alpha};
            float[] rgba = HslColor.toRGBA01(hsla);
            return new Color(rgba[0], rgba[1], rgba[2], rgba[3]);
        }
        return null;
    }

    public static Color getColorFromRgba(String rgbaColor) {
        if (rgbaColor != null && !rgbaColor.trim().isEmpty() && rgbaColor.startsWith("rgba(")) {
            String colorPartString = rgbaColor.substring(5, rgbaColor.length() - 1);
            String[] colorParts = colorPartString.split(",");
            float red = ColorUtil.getColor01FromColor256(Float.parseFloat(colorParts[0]));
            float green = ColorUtil.getColor01FromColor256(Float.parseFloat(colorParts[1]));
            float blue = ColorUtil.getColor01FromColor256(Float.parseFloat(colorParts[2]));
            float alpha = 1.0f;
            if (colorParts.length > 3) {
                alpha = Float.parseFloat(colorParts[3]);
            }
            return new Color(red, green, blue, alpha);
        }
        return null;
    }

    public static Color getColorFromRgb(String rgbColor) {
        if (rgbColor != null && !rgbColor.trim().isEmpty() && rgbColor.startsWith("rgb(")) {
            String colorPartString = rgbColor.substring(4, rgbColor.length() - 1);
            String[] colorParts = colorPartString.split(",");
            float red = ColorUtil.getColor01FromColor256(Float.parseFloat(colorParts[0]));
            float green = ColorUtil.getColor01FromColor256(Float.parseFloat(colorParts[1]));
            float blue = ColorUtil.getColor01FromColor256(Float.parseFloat(colorParts[2]));
            return new Color(red, green, blue);
        }
        return null;
    }

    public static Color getColor(Color baseColor, float zeroToOneOpacity) {
        if (zeroToOneOpacity < 1.0f) {
            return new Color(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), (int)(zeroToOneOpacity * 255.0f));
        }
        return baseColor;
    }

    public static Color getColorFromStatic(String cssColor) {
        if (cssColor.toLowerCase().equals("#red")) {
            return Color.RED;
        }
        if (cssColor.toLowerCase().equals("#green")) {
            return Color.GREEN;
        }
        if (cssColor.toLowerCase().equals("#blue")) {
            return Color.BLUE;
        }
        if (cssColor.toLowerCase().equals("#orange")) {
            return Color.ORANGE;
        }
        if (cssColor.toLowerCase().equals("#yellow")) {
            return Color.YELLOW;
        }
        if (cssColor.toLowerCase().equals("#black")) {
            return Color.BLACK;
        }
        if (cssColor.toLowerCase().equals("#white")) {
            return Color.WHITE;
        }
        if (cssColor.toLowerCase().equals("#cyan")) {
            return Color.CYAN;
        }
        if (cssColor.toLowerCase().equals("#gray")) {
            return Color.GRAY;
        }
        if (cssColor.toLowerCase().equals("#magenta")) {
            return Color.MAGENTA;
        }
        if (cssColor.toLowerCase().equals("#pink")) {
            return Color.PINK;
        }
        return null;
    }

    public static Color getColorFromCss(String cssColor, float zeroToOneOpacity) {
        if (cssColor != null && !((String)cssColor).trim().isEmpty() && ((String)cssColor).startsWith("#")) {
            if (((String)(cssColor = ((String)cssColor).substring(1))).length() != 3 && ((String)cssColor).length() != 6 && ((String)cssColor).length() != 8) {
                log.warn("getColorFromCss: cssColor String has unusual length: " + (String)cssColor);
            }
            if (((String)cssColor).length() == 3) {
                cssColor = "" + ((String)cssColor).charAt(0) + ((String)cssColor).charAt(0) + ((String)cssColor).charAt(1) + ((String)cssColor).charAt(1) + ((String)cssColor).charAt(2) + ((String)cssColor).charAt(2);
            }
            ArrayList<String> cssColorParts = new ArrayList<String>();
            for (int i = 0; i < ((String)cssColor).length(); i += 2) {
                cssColorParts.add(((String)cssColor).substring(i, i + 2));
            }
            if (cssColorParts.size() == 3) {
                try {
                    red = ColorUtil.getColor10FromColor16((String)cssColorParts.get(0));
                    int green = ColorUtil.getColor10FromColor16((String)cssColorParts.get(1));
                    int blue = ColorUtil.getColor10FromColor16((String)cssColorParts.get(2));
                    int alpha = (int)(zeroToOneOpacity * 255.0f);
                    return new Color(red, green, blue, alpha);
                }
                catch (NumberFormatException e) {
                    log.error("getColorFromCss: could not parse the css string: #" + (String)cssColor, (Throwable)e);
                }
            } else if (cssColorParts.size() == 4) {
                try {
                    red = ColorUtil.getColor10FromColor16((String)cssColorParts.get(0));
                    int green = ColorUtil.getColor10FromColor16((String)cssColorParts.get(1));
                    int blue = ColorUtil.getColor10FromColor16((String)cssColorParts.get(2));
                    int alpha = ColorUtil.getColor10FromColor16((String)cssColorParts.get(3));
                    if (zeroToOneOpacity != 1.0f) {
                        alpha = (int)(zeroToOneOpacity * 255.0f);
                    }
                    return new Color(red, green, blue, alpha);
                }
                catch (NumberFormatException e) {
                    log.error("getColorFromCss: could not parse the css string: #" + (String)cssColor, (Throwable)e);
                }
            }
        }
        return null;
    }

    private static int getOpacityFromString(String opacityStringZeroToOne) {
        if (opacityStringZeroToOne != null && !opacityStringZeroToOne.trim().isEmpty()) {
            float opacity = Float.parseFloat(opacityStringZeroToOne);
            return (int)(255.0f * opacity);
        }
        return -1;
    }

    public static float getOpacityFromStringAsFloat(String opacityStringZeroToOne) {
        if (opacityStringZeroToOne != null && !opacityStringZeroToOne.trim().isEmpty()) {
            float opacity = Float.parseFloat(opacityStringZeroToOne);
            return opacity;
        }
        return 1.0f;
    }

    private static int getColor10FromColor16(String color16) {
        return Integer.valueOf(color16, 16);
    }

    private static int invertTransparency(int transparency) {
        return 255 - transparency;
    }

    private static float getColor01FromColor256(double color256) {
        return (float)(color256 / 255.0);
    }

    public static Color getAverageColor(Color colorMin, Color colorMax) {
        float newRed = (float)(colorMin.getRed() + colorMax.getRed()) / 2.0f / 255.0f;
        float newGreen = (float)(colorMin.getGreen() + colorMax.getGreen()) / 2.0f / 255.0f;
        float newBlue = (float)(colorMin.getBlue() + colorMax.getBlue()) / 2.0f / 255.0f;
        float newAlpha = (float)(colorMin.getAlpha() + colorMax.getAlpha()) / 2.0f / 255.0f;
        return new Color(newRed, newGreen, newBlue, newAlpha);
    }
}

