/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.util;

import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.resources.output.format.SlippyMapTiles;
import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteFilesOutsideBBox {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public static void main(String[] args) {
        DeleteFilesOutsideBBox instance = new DeleteFilesOutsideBBox();
        instance.run(args);
    }

    public void run(String[] args) {
        File folder;
        Optional<BoundingBox> optionalBBox;
        this.log.warn("run: starting deletion");
        if (args.length < 6) {
            this.log.error("run: expected parameters -bbox, -zoom and -folder");
            System.exit(1);
        }
        if (!(optionalBBox = this.getBBox(args)).isPresent()) {
            this.log.error("run: no bounding box given");
            System.exit(1);
        }
        BoundingBox bbox = optionalBBox.get();
        Optional<Integer> optionalZoom = this.getZoom(args);
        if (!optionalZoom.isPresent()) {
            this.log.error("run: no zoom given");
            System.exit(1);
        }
        int zoom = optionalZoom.get();
        Optional<File> optionalFolder = this.getFolder(args);
        if (!optionalFolder.isPresent()) {
            this.log.error("run: no folder given");
            System.exit(1);
        }
        if (!(folder = optionalFolder.get()).exists()) {
            this.log.error("run: given folder does not exist");
            System.exit(1);
        }
        this.log.info("run: using bbox=" + bbox);
        this.log.info("run: using zoom=" + zoom);
        this.log.info("run: using folder=" + folder);
        SlippyMapTiles slippyMapTiles = new SlippyMapTiles();
        Point minTileIndex = slippyMapTiles.getMinTileIndex(bbox.getLeft(), bbox.getTop(), zoom);
        Point maxTileIndex = slippyMapTiles.getMaxTileIndex(bbox.getRight(), bbox.getBottom(), zoom);
        int tileIndexLeft = (int)minTileIndex.getX();
        int tileIndexRight = (int)maxTileIndex.getX();
        int tileIndexTop = (int)minTileIndex.getY();
        int tileIndexBottom = (int)maxTileIndex.getY();
        this.log.info("run: index left=" + tileIndexLeft);
        this.log.info("run: index right=" + tileIndexRight);
        this.log.info("run: index top=" + tileIndexTop);
        this.log.info("run: index bottom=" + tileIndexBottom);
        File zoomFolder = new File(folder.getAbsolutePath() + File.separator + zoom);
        this.log.info("run: searching files in zoomFolder: " + zoomFolder);
        List<String> files = new ArrayList<String>();
        try (Stream<Path> stream = Files.walk(Paths.get(zoomFolder.toURI()), new FileVisitOption[0]);){
            files = stream.filter(file -> !Files.isDirectory(file, new LinkOption[0])).map(Path::toAbsolutePath).map(Path::toString).sorted().collect(Collectors.toList());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.log.info("run: found #" + files.size() + " files");
        this.deleteFiles(zoomFolder, files, tileIndexLeft, tileIndexRight, tileIndexTop, tileIndexBottom);
        this.log.info("run: exit");
    }

    private void deleteFiles(File zoomFolder, List<String> files, int tileIndexLeft, int tileIndexRight, int tileIndexTop, int tileIndexBottom) {
        long deleteCounter = 0L;
        for (String fileString : files) {
            File file = new File(fileString);
            String fileXYStructure = fileString.substring(zoomFolder.getAbsolutePath().length() + 1);
            int indexSeparator = fileXYStructure.indexOf("/");
            if (indexSeparator == -1) {
                indexSeparator = fileXYStructure.indexOf("\\");
            }
            int x = Integer.parseInt(fileXYStructure.substring(0, indexSeparator));
            int y = Integer.parseInt(fileXYStructure.substring(indexSeparator + 1, fileXYStructure.indexOf(".")));
            if (x >= tileIndexLeft && x <= tileIndexRight && y >= tileIndexTop && y <= tileIndexBottom) continue;
            this.log.info("deleteFiles: deleting file: " + file.getAbsolutePath());
            file.delete();
            ++deleteCounter;
        }
        this.log.info("deleteFiles: deleted #" + deleteCounter + " files");
    }

    private int findIndexOfParameter(String parameter, String[] args) {
        if (parameter == null || parameter.isBlank()) {
            return -1;
        }
        for (int i = 0; i < args.length; ++i) {
            if (!parameter.equals(args[i])) continue;
            if (i + 1 >= args.length) {
                return -1;
            }
            return i + 1;
        }
        return -1;
    }

    private Optional<BoundingBox> getBBox(String[] args) {
        String bboxString;
        int indexBBox = this.findIndexOfParameter("-bbox", args);
        if (indexBBox == -1) {
            this.log.error("getBBox: expected parameters -bbox");
            System.exit(1);
        }
        if ((bboxString = args[indexBBox]) == null || bboxString.isBlank()) {
            return Optional.empty();
        }
        BoundingBox bbox = new BoundingBox(bboxString);
        return Optional.of(bbox);
    }

    private Optional<Integer> getZoom(String[] args) {
        String zoomString;
        int indexZoom = this.findIndexOfParameter("-zoom", args);
        if (indexZoom == -1) {
            this.log.error("getZoom: expected parameters -zoom");
            System.exit(1);
        }
        if ((zoomString = args[indexZoom]) == null || zoomString.isBlank()) {
            return Optional.empty();
        }
        Integer zoom = Integer.parseInt(zoomString);
        return Optional.of(zoom);
    }

    private Optional<File> getFolder(String[] args) {
        String folderString;
        int indexFolder = this.findIndexOfParameter("-folder", args);
        if (indexFolder == -1) {
            this.log.error("getFolder: expected parameters -folder");
            System.exit(1);
        }
        if ((folderString = args[indexFolder]) == null || folderString.isBlank()) {
            return Optional.empty();
        }
        File file = new File(folderString);
        return Optional.of(file);
    }
}

