/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.symbols;

import de.wideportal.maprender.config.xml.RenderConfiguration;
import de.wideportal.maprender.config.xml.RenderConfigurationDatasources;
import de.wideportal.maprender.geom.Point;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.batik.util.XMLResourceDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class SymbolsCache {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private RenderConfiguration configuration;
    private LinkedHashMap<String, BufferedImage> symbols = new LinkedHashMap();

    public SymbolsCache(RenderConfiguration configuration) {
        this.configuration = configuration;
    }

    public BufferedImage getSymbol(String symbolFile) {
        BufferedImage symbol = this.symbols.get(symbolFile);
        if (symbol == null) {
            symbol = this.loadSymbol(symbolFile);
            this.symbols.put(symbolFile, symbol);
        }
        return symbol;
    }

    /*
     * WARNING - void declaration
     */
    private BufferedImage loadSymbol(String symbolFileName) {
        this.log.debug("loadSymbol: loading symbol file: " + symbolFileName);
        RenderConfigurationDatasources datasources = this.configuration.getMaprenderConfiguration().getDatasources();
        List<String> folders = datasources.getSymbols().getFolders();
        for (String string : folders) {
            void var5_5;
            String symbolFullPath;
            File symbolFile;
            if (!string.endsWith("\\") && !string.endsWith("/")) {
                String string2 = string + "/";
            }
            if (!(symbolFile = new File(symbolFullPath = (String)var5_5 + symbolFileName)).exists()) {
                this.log.warn("loadSymbol: could not find symbol file in path: " + symbolFullPath);
                continue;
            }
            try {
                BufferedImage image = null;
                if (symbolFileName.toLowerCase().endsWith("svg")) {
                    FileInputStream inputStream = new FileInputStream(symbolFile);
                    Document svgDocument = this.getDocument(inputStream);
                    Point widthHeightInfo = this.getWidthHeightInformation(svgDocument);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    TranscoderInput input = new TranscoderInput(svgDocument);
                    TranscoderOutput output = new TranscoderOutput((OutputStream)baos);
                    try {
                        PNGTranscoder transcoder = new PNGTranscoder();
                        if (widthHeightInfo != null) {
                            transcoder.addTranscodingHint(PNGTranscoder.KEY_WIDTH, (Object)Float.valueOf((float)widthHeightInfo.getX()));
                            transcoder.addTranscodingHint(PNGTranscoder.KEY_HEIGHT, (Object)Float.valueOf((float)widthHeightInfo.getY()));
                        }
                        transcoder.transcode(input, output);
                    }
                    catch (TranscoderException e) {
                        this.log.error("Could not read SVG image " + symbolFullPath, (Throwable)e);
                    }
                    ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                    image = ImageIO.read(bais);
                } else {
                    image = ImageIO.read(symbolFile);
                }
                this.log.debug("loadSymbol: loaded symbol file: " + symbolFile.getAbsolutePath() + " -> " + image);
                return image;
            }
            catch (Exception e) {
                this.log.error("loadSymbol: could not read symbol file: " + symbolFile.getAbsolutePath(), (Throwable)e);
            }
        }
        return null;
    }

    private Point getWidthHeightInformation(Document svgDocument) {
        String[] viewBoxValues;
        String viewBox = svgDocument.getDocumentElement().getAttribute("viewBox");
        String svgWidth = svgDocument.getDocumentElement().getAttribute("width");
        String svgHeight = svgDocument.getDocumentElement().getAttribute("height");
        double widthHint = 10.0;
        double heightHint = 10.0;
        if (viewBox != null && (viewBoxValues = viewBox.split(" ")).length == 4) {
            widthHint = Float.parseFloat(viewBoxValues[2]);
            heightHint = Float.parseFloat(viewBoxValues[3]);
        }
        if (svgWidth != null && !svgWidth.trim().isEmpty() && svgHeight != null && !svgHeight.trim().isEmpty()) {
            if (!svgWidth.contains("%") && !svgHeight.contains("%")) {
                svgWidth = svgWidth.replace("px", "");
                svgHeight = svgHeight.replace("px", "");
                widthHint = Float.parseFloat(svgWidth);
                heightHint = Float.parseFloat(svgHeight);
            } else if (svgWidth.contains("%") && svgHeight.contains("%")) {
                svgWidth = svgWidth.replace("%", "");
                svgHeight = svgHeight.replace("%", "");
                double widthScaler = Float.parseFloat(svgWidth);
                double heightScaler = Float.parseFloat(svgHeight);
                widthHint = widthHint / 100.0 * widthScaler;
                heightHint = heightHint / 100.0 * heightScaler;
            }
        }
        return new Point(widthHint, heightHint);
    }

    private Document getDocument(InputStream inputStream) throws IOException {
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory saxSVGFactory = new SAXSVGDocumentFactory(parser);
        Document document = saxSVGFactory.createDocument("http://www.w3.org/2000/svg", inputStream);
        return document;
    }
}

