/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.srtm.algos;

import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.resources.srtm.SrtmLinePointsContainer;
import de.wideportal.maprender.resources.srtm.algos.PointGroupAlgo;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointGroupFinderAlgo
extends PointGroupAlgo {
    protected static Logger log = LoggerFactory.getLogger(PointGroupFinderAlgo.class);

    private PointGroupFinderAlgo() {
    }

    public static void groupTouchingPoints(SrtmLinePointsContainer linePointsContainer) {
        ArrayList<Point> pointsToGroup = new ArrayList<Point>(linePointsContainer.getPoints());
        int foundGroupCounter = 0;
        while (pointsToGroup.size() > 0) {
            Point currentPoint = pointsToGroup.get(0);
            ArrayList<Point> uncheckedSurroundingPoints = PointGroupFinderAlgo.getSurroundingPoints(linePointsContainer.getPointMap(), currentPoint);
            ArrayList<Point> checkedSurroundingPoints = new ArrayList<Point>();
            checkedSurroundingPoints.add(currentPoint);
            while (uncheckedSurroundingPoints.size() > 0) {
                for (int k = uncheckedSurroundingPoints.size() - 1; k >= 0; --k) {
                    Point pointToCheck = uncheckedSurroundingPoints.get(k);
                    ArrayList<Point> surroundingPoints = PointGroupFinderAlgo.getSurroundingPoints(linePointsContainer.getPointMap(), pointToCheck);
                    for (Point surroundingPoint : surroundingPoints) {
                        if (uncheckedSurroundingPoints.contains(surroundingPoint) || checkedSurroundingPoints.contains(surroundingPoint)) continue;
                        uncheckedSurroundingPoints.add(surroundingPoint);
                    }
                    checkedSurroundingPoints.add(pointToCheck);
                    uncheckedSurroundingPoints.remove(k);
                }
            }
            for (Point checkedPoint : checkedSurroundingPoints) {
                pointsToGroup.remove(checkedPoint);
                linePointsContainer.getGroupedPoints().put(checkedPoint, checkedSurroundingPoints);
            }
            linePointsContainer.getGroups().add(checkedSurroundingPoints);
            ++foundGroupCounter;
        }
        log.debug("groupTouchingPoints(): found #" + foundGroupCounter + " groups");
    }
}

