/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.srtm;

import de.wideportal.maprender.geom.LineSequence;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.renderer.buffer.BooleanArrayBuffer;
import de.wideportal.maprender.resources.srtm.SrtmLineHeightContainer;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrtmLinePointsContainer {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    public static final int NW = 0;
    public static final int N = 1;
    public static final int NE = 2;
    public static final int E = 3;
    public static final int SE = 4;
    public static final int S = 5;
    public static final int SW = 6;
    public static final int W = 7;
    public static final int C = 8;
    private int height = 0;
    private int size = 0;
    private ArrayList<Point> points = new ArrayList();
    private Point[][][] pointMap = new Point[0][0][0];
    private HashMap<Point, ArrayList<Point>> groupedPoints = new HashMap();
    private ArrayList<ArrayList<Point>> groups = new ArrayList();

    public SrtmLinePointsContainer(int height, long size) {
        this.height = height;
        this.size = (int)size;
        this.pointMap = new Point[this.size][this.size][9];
    }

    public int getHeight() {
        return this.height;
    }

    public ArrayList<Point> getPoints() {
        return this.points;
    }

    public void addPoint(Point point) {
        this.points.add(point);
        this.pointMap[(int)point.getX()][(int)point.getY()][8] = point;
        if (point.getX() > 0.0 && point.getY() > 0.0) {
            this.pointMap[(int)point.getX() - 1][(int)point.getY() - 1][4] = point;
        }
        if (point.getY() > 0.0) {
            this.pointMap[(int)point.getX()][(int)point.getY() - 1][5] = point;
        }
        if (point.getX() < (double)(this.size - 1) && point.getY() > 0.0) {
            this.pointMap[(int)point.getX() + 1][(int)point.getY() - 1][6] = point;
        }
        if (point.getX() > 0.0) {
            this.pointMap[(int)point.getX() - 1][(int)point.getY()][3] = point;
        }
        if (point.getX() < (double)(this.size - 1)) {
            this.pointMap[(int)point.getX() + 1][(int)point.getY()][7] = point;
        }
        if (point.getX() > 0.0 && point.getY() < (double)(this.size - 1)) {
            this.pointMap[(int)point.getX() - 1][(int)point.getY() + 1][2] = point;
        }
        if (point.getY() < (double)(this.size - 1)) {
            this.pointMap[(int)point.getX()][(int)point.getY() + 1][1] = point;
        }
        if (point.getX() < (double)(this.size - 1) && point.getY() < (double)(this.size - 1)) {
            this.pointMap[(int)point.getX() + 1][(int)point.getY() + 1][0] = point;
        }
    }

    public void removePoint(Point point) {
        this.points.remove(point);
        this.pointMap[(int)point.getX()][(int)point.getY()][8] = null;
        if (point.getX() > 0.0 && point.getY() > 0.0) {
            this.pointMap[(int)point.getX() - 1][(int)point.getY() - 1][4] = null;
        }
        if (point.getY() > 0.0) {
            this.pointMap[(int)point.getX()][(int)point.getY() - 1][5] = null;
        }
        if (point.getX() < (double)(this.size - 1) && point.getY() > 0.0) {
            this.pointMap[(int)point.getX() + 1][(int)point.getY() - 1][6] = null;
        }
        if (point.getX() > 0.0) {
            this.pointMap[(int)point.getX() - 1][(int)point.getY()][3] = null;
        }
        if (point.getX() < (double)(this.size - 1)) {
            this.pointMap[(int)point.getX() + 1][(int)point.getY()][7] = null;
        }
        if (point.getX() > 0.0 && point.getY() < (double)(this.size - 1)) {
            this.pointMap[(int)point.getX() - 1][(int)point.getY() + 1][2] = null;
        }
        if (point.getY() < (double)(this.size - 1)) {
            this.pointMap[(int)point.getX()][(int)point.getY() + 1][1] = null;
        }
        if (point.getX() < (double)(this.size - 1) && point.getY() < (double)(this.size - 1)) {
            this.pointMap[(int)point.getX() + 1][(int)point.getY() + 1][0] = null;
        }
        if (this.groupedPoints.get(point) != null) {
            this.groupedPoints.get(point).remove(point);
        }
        this.groupedPoints.remove(point);
    }

    public void addPoints(BooleanArrayBuffer cellOnLineBuffer, int z) {
        for (int y = 0; y < cellOnLineBuffer.getYSize(); ++y) {
            for (int x = 0; x < cellOnLineBuffer.getXSize(); ++x) {
                if (!cellOnLineBuffer.getValue(x, y, z)) continue;
                this.addPoint(new Point(x, y));
            }
        }
    }

    public boolean isStubble(Point point) {
        int x = (int)point.getX();
        int y = (int)point.getY();
        int longestSpace = 0;
        int spaceCount = 0;
        int pointCount = 0;
        for (int i = 0; i < 17; ++i) {
            if (i < 8 && this.pointMap[x][y][i] != null) {
                ++pointCount;
            }
            if (i == 8) continue;
            int z = i % 9;
            if (this.pointMap[x][y][z] == null) {
                longestSpace = Math.max(longestSpace, ++spaceCount);
                continue;
            }
            spaceCount = 0;
        }
        return longestSpace == 5 && pointCount == 3 || longestSpace > 5;
    }

    public ArrayList<Point> getTouchingGroup(Point referencePoint) {
        return this.getTouchingGroup((int)referencePoint.getX(), (int)referencePoint.getY());
    }

    public ArrayList<Point> getTouchingGroup(int x, int y) {
        for (Point key : this.groupedPoints.keySet()) {
            if (key.getX() != (double)x || key.getY() != (double)y) continue;
            return this.groupedPoints.get(key);
        }
        return null;
    }

    public Point findPoint(int x, int y) {
        for (Point point : this.points) {
            if (point.getX() != (double)x || point.getY() != (double)y) continue;
            return point;
        }
        return null;
    }

    public SrtmLineHeightContainer buildLineSequenceFromPoints(int height, int z) {
        SrtmLineHeightContainer heightLineContainer = new SrtmLineHeightContainer(height, z);
        double diagDist = Math.sqrt(2.0);
        for (ArrayList<Point> groupPoints : this.groups) {
            ArrayList<Point> group = new ArrayList<Point>(groupPoints);
            if (group.size() <= 0) continue;
            while (group.size() > 0) {
                Point lastPoint;
                Point startPoint = group.get(group.size() - 1);
                group.remove(group.size() - 1);
                ArrayList<Point> line = new ArrayList<Point>();
                line.add(startPoint);
                for (int i = group.size() - 1; i >= 0; --i) {
                    Point lineStart = (Point)line.get(0);
                    Point lineStop = (Point)line.get(line.size() - 1);
                    Point currentPoint = group.get(i);
                    if (line.size() == 1) {
                        if (!(lineStart.getDistance(currentPoint) <= diagDist)) continue;
                        line.add(currentPoint);
                        group.remove(i);
                        i = group.size();
                        continue;
                    }
                    if (lineStart.getDistance(currentPoint) <= diagDist) {
                        line.add(0, currentPoint);
                        group.remove(i);
                        i = group.size();
                        continue;
                    }
                    if (!(lineStop.getDistance(currentPoint) <= diagDist)) continue;
                    line.add(currentPoint);
                    group.remove(i);
                    i = group.size();
                }
                Point firstPoint = (Point)line.get(0);
                double distanceStartEnd = firstPoint.getDistance(lastPoint = (Point)line.get(line.size() - 1));
                if (distanceStartEnd < 2.0) {
                    line.add(firstPoint);
                } else if (line.size() > 2) {
                    Point checkPoint;
                    int i;
                    Point secondPoint = (Point)line.get(1);
                    Point secondLastPoint = line.get(line.size() - 2);
                    for (i = 0; i < groupPoints.size(); ++i) {
                        checkPoint = groupPoints.get(i);
                        if (checkPoint == secondLastPoint || checkPoint == lastPoint || !(checkPoint.getDistance(lastPoint) < 2.0)) continue;
                        line.add(checkPoint);
                        break;
                    }
                    for (i = 0; i < groupPoints.size(); ++i) {
                        checkPoint = groupPoints.get(i);
                        if (checkPoint == secondPoint || checkPoint == firstPoint || !(checkPoint.getDistance(firstPoint) < 2.0)) continue;
                        line.add(0, checkPoint);
                        break;
                    }
                }
                LineSequence lineSequence = new LineSequence(line);
                heightLineContainer.addLineSequence(lineSequence);
            }
        }
        return heightLineContainer;
    }

    public ArrayList<ArrayList<Point>> getGroups() {
        return this.groups;
    }

    public Point[][][] getPointMap() {
        return this.pointMap;
    }

    public HashMap<Point, ArrayList<Point>> getGroupedPoints() {
        return this.groupedPoints;
    }

    public void logBuffer(int xMin, int xMax, int yMin, int yMax) {
        System.out.println("################################################# logBuffer ");
        for (int y = yMin; y < yMax; ++y) {
            StringBuffer rowBuffy = new StringBuffer();
            for (int x = xMin; x < xMax; ++x) {
                String lengthFilledValue = " ";
                for (Point point : this.points) {
                    if (point.getX() != (double)x || point.getY() != (double)y) continue;
                    lengthFilledValue = "x";
                    break;
                }
                rowBuffy.append(lengthFilledValue);
            }
            System.out.println("######################### " + rowBuffy.toString());
        }
    }

    public void logCellMap(Point point) {
        int x = (int)point.getX();
        int y = (int)point.getY();
        Point[] cell = this.pointMap[x][y];
        System.out.println("################################################# logCellMap ");
        Object cellNW = "[   ,   ]";
        if (cell[0] != null) {
            cellNW = "[" + String.format("%3s", "" + (int)cell[0].getX()) + "," + String.format("%3s", "" + (int)cell[0].getY()) + "]";
        }
        Object cellN = "[   ,   ]";
        if (cell[1] != null) {
            cellN = "[" + String.format("%3s", "" + (int)cell[1].getX()) + "," + String.format("%3s", "" + (int)cell[1].getY()) + "]";
        }
        Object cellNE = "[   ,   ]";
        if (cell[2] != null) {
            cellNE = "[" + String.format("%3s", "" + (int)cell[2].getX()) + "," + String.format("%3s", "" + (int)cell[2].getY()) + "]";
        }
        System.out.println("######################### " + (String)cellNW + (String)cellN + (String)cellNE);
        Object cellW = "[   ,   ]";
        if (cell[7] != null) {
            cellW = "[" + String.format("%3s", "" + (int)cell[7].getX()) + "," + String.format("%3s", "" + (int)cell[7].getY()) + "]";
        }
        Object cellC = "[   ,   ]";
        if (cell[8] != null) {
            cellC = "[" + String.format("%3s", "" + (int)cell[8].getX()) + "," + String.format("%3s", "" + (int)cell[8].getY()) + "]";
        }
        Object cellE = "[   ,   ]";
        if (cell[3] != null) {
            cellE = "[" + String.format("%3s", "" + (int)cell[3].getX()) + "," + String.format("%3s", "" + (int)cell[3].getY()) + "]";
        }
        System.out.println("######################### " + (String)cellW + (String)cellC + (String)cellE);
        Object cellSW = "[   ,   ]";
        if (cell[6] != null) {
            cellSW = "[" + String.format("%3s", "" + (int)cell[6].getX()) + "," + String.format("%3s", "" + (int)cell[6].getY()) + "]";
        }
        Object cellS = "[   ,   ]";
        if (cell[5] != null) {
            cellS = "[" + String.format("%3s", "" + (int)cell[5].getX()) + "," + String.format("%3s", "" + (int)cell[5].getY()) + "]";
        }
        Object cellSE = "[   ,   ]";
        if (cell[4] != null) {
            cellSE = "[" + String.format("%3s", "" + (int)cell[4].getX()) + "," + String.format("%3s", "" + (int)cell[4].getY()) + "]";
        }
        System.out.println("######################### " + (String)cellSW + (String)cellS + (String)cellSE);
    }
}

