/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.output;

import de.wideportal.maprender.config.xml.RenderConfigurationOutput;
import de.wideportal.maprender.request.RenderRequest;
import de.wideportal.maprender.resources.file.FilePersister;
import de.wideportal.maprender.resources.file.TilesAsImagePersister;
import de.wideportal.maprender.resources.ftp.FtpPersister;
import de.wideportal.maprender.resources.output.IRenderOutputPersister;
import de.wideportal.maprender.resources.sqlitedb.SqLiteDbPersister;
import java.util.ArrayList;

public class RenderOutputQueue {
    private ArrayList<IRenderOutputPersister> persisters = new ArrayList();

    public void addPersister(IRenderOutputPersister persister) {
        this.persisters.add(persister);
    }

    public void persistAllTiles(RenderRequest renderRequestToSave) {
        for (IRenderOutputPersister persister : this.persisters) {
            persister.persistTile(renderRequestToSave);
        }
    }

    public void init(RenderConfigurationOutput outputConfig) {
        if (outputConfig != null) {
            if (outputConfig.getFile() != null) {
                this.persisters.add(new FilePersister());
            }
            if (outputConfig.getFtp() != null) {
                this.persisters.add(new FtpPersister());
            }
            if (outputConfig.getSqLiteDb() != null) {
                this.persisters.add(new SqLiteDbPersister());
            }
            if (outputConfig.getImage() != null) {
                this.persisters.add(new TilesAsImagePersister());
            }
        }
    }
}

