/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.lglbw;

import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.request.RenderRequest;
import de.wideportal.maprender.resources.height.HeightCollectorTile;
import de.wideportal.maprender.resources.height.HeightCollectorTileCachePersister;
import de.wideportal.maprender.resources.height.ITile;
import de.wideportal.maprender.resources.height.ITileAccessor;
import de.wideportal.maprender.resources.lglbw.LglBwHelper;
import de.wideportal.maprender.resources.lglbw.LglBwTileCache;
import de.wideportal.maprender.resources.output.format.AbstractMapTileOutput;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LglBwTileAccessor
implements ITileAccessor {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private LglBwTileCache tileCache;
    private LglBwHelper lglBwHelper = new LglBwHelper();

    public LglBwTileAccessor(LglBwTileCache tileCache) {
        this.tileCache = tileCache;
    }

    @Override
    public List<ITile> getCachedTiles() {
        return this.tileCache.getTiles();
    }

    @Override
    public LglBwTileCache getTileCache() {
        return this.tileCache;
    }

    @Override
    public boolean isAvailable() {
        return this.tileCache != null;
    }

    @Override
    public List<ITile> getUnloadedTiles(BoundingBox latLonBBox, int heightDiffThreshold, int heightPointDiffThreshold) {
        return this.tileCache.getUnloadedTiles(latLonBBox, heightDiffThreshold, heightPointDiffThreshold);
    }

    @Override
    public ITile loadTile(ITile unloadedTile, int heightDiffThreshold) {
        return this.tileCache.loadTile(unloadedTile, heightDiffThreshold);
    }

    public boolean isTileFileExisting(ITile unloadedTile) {
        return this.tileCache.isTileFileExisting(unloadedTile);
    }

    @Override
    public void saveCollectedValuesToCache(int zoom, int xTileIndex, int yTileIndex, HeightCollectorTile heightCollectTile, int heightDiffThreshold, int heightPointDiffThreshold) {
        Optional<HeightCollectorTileCachePersister> optionalCollectTileCachePersister = this.tileCache.getHeightCollectorTileCachePersister();
        if (optionalCollectTileCachePersister.isPresent()) {
            optionalCollectTileCachePersister.get().persist(zoom, xTileIndex, yTileIndex, heightCollectTile, heightDiffThreshold, heightPointDiffThreshold);
            this.log.debug("saveCollectedValuesToCache(): LglBw tile was saved to cache");
        } else {
            this.log.debug("saveCollectedValuesToCache(): no LglBw tile cache configured");
        }
    }

    @Override
    public HeightCollectorTile[] collectSurroundingValues(int zoom, int xTileIndex, int yTileIndex, BoundingBox latLonBoundingBox, RenderRequest renderRequest, long tileSize, boolean renderMockTiles, int heightDiffThreshold, int heightPointDiffThreshold, AbstractMapTileOutput tileOutputter) {
        HeightCollectorTile[] tiles = new HeightCollectorTile[9];
        int counter = 0;
        for (int yShift = -1; yShift <= 1; ++yShift) {
            for (int xShift = -1; xShift <= 1; ++xShift) {
                HeightCollectorTile currentTile;
                double pixelsPerTile = tileOutputter.getPixelsPerTile(zoom);
                int indexTileY = yTileIndex + yShift;
                double indexPixelYTop = (double)indexTileY * pixelsPerTile;
                double indexPixelYBottom = (double)(indexTileY + 1) * pixelsPerTile;
                int indexTileX = xTileIndex + xShift;
                double indexPixelXLeft = (double)indexTileX * pixelsPerTile;
                double indexPixelXRight = (double)(indexTileX + 1) * pixelsPerTile;
                Point lonLatLeftTop = tileOutputter.getPixelToLonLat(indexPixelXLeft, indexPixelYTop, zoom);
                Point lonLatrightBottom = tileOutputter.getPixelToLonLat(indexPixelXRight, indexPixelYBottom, zoom);
                double latTop = lonLatLeftTop.getY();
                double latBottom = lonLatrightBottom.getY();
                double lonLeft = lonLatLeftTop.getX();
                double lonRight = lonLatrightBottom.getX();
                BoundingBox subTileBBox = new BoundingBox(lonLeft, latBottom, lonRight, latTop);
                tiles[counter] = currentTile = this.collectValues(zoom, xTileIndex + xShift, yTileIndex + yShift, subTileBBox, renderRequest, tileSize, renderMockTiles, heightDiffThreshold, heightPointDiffThreshold, tileOutputter);
                ++counter;
            }
        }
        return tiles;
    }

    @Override
    public HeightCollectorTile collectValues(int zoom, int xTileIndex, int yTileIndex, BoundingBox latLonBBox, RenderRequest renderRequest, long tileSize, boolean renderMockTiles, int heightDiffThreshold, int heightPointDiffThreshold, AbstractMapTileOutput tileOutputter) {
        ITile neededTile;
        double northing;
        double easting;
        Optional<HeightCollectorTileCachePersister> optionalCollectTileCachePersister = this.tileCache.getHeightCollectorTileCachePersister();
        if (optionalCollectTileCachePersister.isPresent()) {
            Optional<HeightCollectorTile> optionalResult = optionalCollectTileCachePersister.get().load(zoom, xTileIndex, yTileIndex, heightDiffThreshold, heightPointDiffThreshold);
            if (optionalResult.isPresent()) {
                this.log.debug("collectValues(): LglBw tile was found in cache");
                return optionalResult.get();
            }
        } else {
            this.log.debug("collectValues(): no LglBw tile cache configured");
        }
        double collectorTileWidthLon = latLonBBox.getWidth();
        double collectorTileHeightLat = latLonBBox.getHeight();
        double requiredBorderBufferPixel = 50.0;
        double increaseCollectorBoundsForCloseupZoomlevels = 1.0 / collectorTileWidthLon / 100.0;
        if (increaseCollectorBoundsForCloseupZoomlevels < 1.0) {
            increaseCollectorBoundsForCloseupZoomlevels = 1.0;
        }
        double increaseLon = requiredBorderBufferPixel * collectorTileWidthLon / (double)tileSize * increaseCollectorBoundsForCloseupZoomlevels;
        double increaseLat = requiredBorderBufferPixel * collectorTileHeightLat / (double)tileSize * increaseCollectorBoundsForCloseupZoomlevels;
        BoundingBox increasedLatLonBBox = new BoundingBox(latLonBBox.getLeft() - increaseLon, latLonBBox.getBottom() - increaseLat, latLonBBox.getRight() + increaseLon, latLonBBox.getTop() + increaseLat);
        HeightCollectorTile heightCollectorTile = new HeightCollectorTile(latLonBBox, increasedLatLonBBox, (int)tileSize);
        double margin = 0.0;
        double leftLon = increasedLatLonBBox.getLeft() - margin;
        double topLat = increasedLatLonBBox.getTop() + margin;
        double rightLon = increasedLatLonBBox.getRight() + margin;
        double bottomLat = increasedLatLonBBox.getBottom() - margin;
        Point leftBottom = this.lglBwHelper.getEastingNorthingFromLatLon(leftLon, bottomLat, 1000.0);
        Point rightTop = this.lglBwHelper.getEastingNorthingFromLatLon(rightLon, topLat, 1000.0);
        int lglbwTilesToLoadCount = 0;
        for (double easting2 = leftBottom.getX(); easting2 <= rightTop.getX(); easting2 += 1.0) {
            for (double northing2 = leftBottom.getY(); northing2 <= rightTop.getY(); northing2 += 1.0) {
                ++lglbwTilesToLoadCount;
            }
        }
        if (lglbwTilesToLoadCount > 10) {
            this.log.info("collectValues(): Approximately " + lglbwTilesToLoadCount + "+ LglBw tiles will be required");
        }
        boolean isAtLeastOneTileNotMocked = false;
        for (easting = leftBottom.getX(); easting <= rightTop.getX() && !isAtLeastOneTileNotMocked; easting += 1.0) {
            for (northing = leftBottom.getY(); northing <= rightTop.getY() && !isAtLeastOneTileNotMocked; northing += 1.0) {
                neededTile = this.tileCache.getCachedTile((int)easting, (int)northing, heightDiffThreshold, heightPointDiffThreshold);
                boolean isTileFileExisting = this.tileCache.isTileFileExisting(neededTile);
                if (isTileFileExisting) {
                    isAtLeastOneTileNotMocked = true;
                }
                if (!neededTile.isLoaded() && (neededTile = this.loadTile(neededTile, heightDiffThreshold)) == null) {
                    return null;
                }
                if (neededTile.isMocked()) continue;
                isAtLeastOneTileNotMocked = true;
            }
        }
        if (lglbwTilesToLoadCount > 30) {
            if (isAtLeastOneTileNotMocked) {
                this.log.info("collectValues(): There are unmocked tiles, therefor continuing with normal collection of tiles");
            } else {
                this.log.info("collectValues(): All tiles would be mocked, therefor setting all tile values to 0");
            }
        }
        if (!isAtLeastOneTileNotMocked) {
            if (heightCollectorTile != null) {
                this.saveCollectedValuesToCache(zoom, xTileIndex, yTileIndex, heightCollectorTile, heightDiffThreshold, heightPointDiffThreshold);
            }
            return heightCollectorTile;
        }
        for (easting = leftBottom.getX(); easting <= rightTop.getX(); easting += 1.0) {
            for (northing = leftBottom.getY(); northing <= rightTop.getY(); northing += 1.0) {
                neededTile = this.tileCache.getCachedTile((int)easting, (int)northing, heightDiffThreshold, heightPointDiffThreshold);
                if (!neededTile.isLoaded() && (neededTile = this.tileCache.loadTile(neededTile, heightDiffThreshold)) == null) {
                    return null;
                }
                if (neededTile.isMocked() && !renderMockTiles) continue;
                heightCollectorTile = neededTile.renderIntoCollector(zoom, xTileIndex, yTileIndex, renderRequest, heightCollectorTile, tileOutputter, this.tileCache);
            }
        }
        if (heightCollectorTile.needsCentralCellValuesPostProcessing()) {
            heightCollectorTile.postProcessCentralCellValues();
        }
        if (heightCollectorTile != null) {
            this.saveCollectedValuesToCache(zoom, xTileIndex, yTileIndex, heightCollectorTile, heightDiffThreshold, heightPointDiffThreshold);
        }
        return heightCollectorTile;
    }
}

