/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.height;

import de.wideportal.maprender.resources.file.FileAccessor;
import de.wideportal.maprender.resources.height.HeightCollectorTile;
import de.wideportal.maprender.resources.height.HeightCollectorTileData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeightCollectorTileCachePersister
extends FileAccessor {
    protected static Logger log = LoggerFactory.getLogger(HeightCollectorTileCachePersister.class);
    private static final String FILETYPE = "heightcache";
    private static final Integer DEFAULT_MAX_ZOOM = 10;
    private String baseFolder;
    private Integer fileCacheMaxZoom;

    public HeightCollectorTileCachePersister(String baseFolder, Integer fileCacheMaxZoom) {
        this.baseFolder = baseFolder;
        this.fileCacheMaxZoom = fileCacheMaxZoom;
        if (this.fileCacheMaxZoom == null) {
            this.fileCacheMaxZoom = DEFAULT_MAX_ZOOM;
        }
    }

    public synchronized Optional<HeightCollectorTile> load(int zoom, int xTileIndex, int yTileIndex, int heightDiffThreshold, int heightPointDiffThreshold) {
        log.debug("load: zoom=" + zoom + " / xTileIndex=" + xTileIndex + " / yTileIndex=" + yTileIndex);
        this.baseFolder = this.baseFolder.replaceAll("\\\\", "/");
        if (!this.baseFolder.endsWith("/")) {
            this.baseFolder = this.baseFolder + "/";
        }
        Object baseFolderWithThresholds = this.baseFolder;
        baseFolderWithThresholds = (String)baseFolderWithThresholds + heightDiffThreshold + "_" + heightPointDiffThreshold + "/";
        Optional<File> optionalYFile = this.getFile((String)baseFolderWithThresholds, zoom, xTileIndex, yTileIndex, FILETYPE, false);
        HeightCollectorTileData data = null;
        File yFile = null;
        if (optionalYFile.isPresent()) {
            yFile = optionalYFile.get();
            if (yFile.exists()) {
                try (FileInputStream fis = new FileInputStream(yFile);
                     ZipInputStream zis = new ZipInputStream(fis);){
                    ZipEntry innerFile = zis.getNextEntry();
                    if (innerFile != null) {
                        FSTObjectInput ois = new FSTObjectInput((InputStream)zis);
                        data = (HeightCollectorTileData)ois.readObject(new Class[]{HeightCollectorTileData.class});
                        ois.close();
                    }
                }
                catch (Exception e) {
                    log.error("load: could not load from file: " + yFile.getAbsolutePath(), (Throwable)e);
                    throw new RuntimeException("load: could not load from file: " + yFile.getAbsolutePath());
                }
            }
        } else {
            log.debug("load: file is not accessible. Cannot load height cache. Base folder is: " + this.baseFolder);
        }
        HeightCollectorTile result = null;
        if (data != null) {
            result = new HeightCollectorTile(data);
        }
        return Optional.ofNullable(result);
    }

    public void persist(int zoom, int xTileIndex, int yTileIndex, HeightCollectorTile heightCollectorTile, int heightDiffThreshold, int heightPointDiffThreshold) {
        log.debug("persist: zoom=" + zoom + " / xTileIndex=" + xTileIndex + " / yTileIndex=" + yTileIndex + " / heightDiffThreshold=" + heightDiffThreshold + " / heightPointDiffThreshold=" + heightPointDiffThreshold);
        this.baseFolder = this.baseFolder.replaceAll("\\\\", "/");
        if (!this.baseFolder.endsWith("/")) {
            this.baseFolder = this.baseFolder + "/";
        }
        Object baseFolderWithThresholds = this.baseFolder;
        baseFolderWithThresholds = (String)baseFolderWithThresholds + heightDiffThreshold + "_" + heightPointDiffThreshold + "/";
        if (zoom > this.fileCacheMaxZoom) {
            log.debug("persist: zoom level was higher than the configured max zoom level, so we are not saving to cache");
            return;
        }
        Optional<File> optionalYFile = this.getFile((String)baseFolderWithThresholds, zoom, xTileIndex, yTileIndex, FILETYPE, true);
        File yFile = null;
        if (optionalYFile.isPresent()) {
            yFile = optionalYFile.get();
        } else {
            log.error("persist: file is not accessible. Cannot save tile. Base folder is: " + this.baseFolder);
        }
        if (yFile.exists()) {
            log.debug("persist: cache was already created");
            return;
        }
        try {
            log.debug("persist: saved height cache file: " + yFile.getAbsolutePath());
        }
        catch (Exception e) {
            log.error("persist: could not write height cache file: " + yFile.getAbsolutePath(), (Throwable)e);
        }
        try (FileOutputStream fout = new FileOutputStream(yFile);
             ZipOutputStream zos = new ZipOutputStream(fout);
             FSTObjectOutput oos = new FSTObjectOutput((OutputStream)zos);){
            ZipEntry innerFile = new ZipEntry("cache");
            zos.putNextEntry(innerFile);
            oos.writeObject((Object)heightCollectorTile.getData(), new Class[]{HeightCollectorTileData.class});
        }
        catch (IOException e) {
            log.error("persist: could not write to file: " + yFile.getAbsolutePath(), (Throwable)e);
        }
    }
}

