/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.height;

import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.geom.Line;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.resources.height.HeightCollectorTileData;
import de.wideportal.maprender.resources.height.buffer.MultiValueCollectorBuffer;
import de.wideportal.maprender.resources.output.format.AbstractMapTileOutput;
import java.io.Serializable;

public class HeightCollectorTile
implements Serializable {
    private static final long serialVersionUID = -5217612422043428618L;
    public static final int NW = 0;
    public static final int N = 1;
    public static final int NE = 2;
    public static final int W = 3;
    public static final int C = 4;
    public static final int E = 5;
    public static final int SW = 6;
    public static final int S = 7;
    public static final int SE = 8;
    public static final int TILE_BORDER_BUFFER_PIXELS_BASE = 50;
    public static final int CELL_VALUE_IS_CENTER = 2;
    public static final int CELL_VALUE_IS_FILLER = 1;
    public static final int CELL_VALUE_NOT_SET = 0;
    private HeightCollectorTileData data = new HeightCollectorTileData();
    private int[][] centralCellValues = new int[0][0];
    private boolean needsCentralCellValuesPostProcessing = false;
    private int maxCentralCellSize = 0;

    public HeightCollectorTile(HeightCollectorTileData data) {
        this.data = data;
        this.centralCellValues = new int[data.getBufferedTileSize()][data.getBufferedTileSize()];
    }

    public HeightCollectorTile(BoundingBox latLonBBox, BoundingBox latLonCollectFromBox, int pixelTileSize) {
        this.data.setLatLonBBox(latLonBBox);
        this.data.setLatLonCollectFromBox(latLonCollectFromBox);
        this.data.setPixelTileSize(pixelTileSize);
        int bufferedTileSize = pixelTileSize + 100;
        this.data.setBufferedTileSize(bufferedTileSize);
        this.data.setMultipleValueBuffer(new MultiValueCollectorBuffer(bufferedTileSize, bufferedTileSize));
        this.centralCellValues = new int[bufferedTileSize][bufferedTileSize];
    }

    public HeightCollectorTile(BoundingBox latLonBBox, BoundingBox latLonCollectFromBox, int pixelTileSize, int bufferedTileSize, MultiValueCollectorBuffer multipleValueBuffer, boolean needsExpensiveSmoothing, float minValue, float maxValue) {
        this.data.setLatLonBBox(latLonBBox);
        this.data.setLatLonCollectFromBox(latLonCollectFromBox);
        this.data.setPixelTileSize(pixelTileSize);
        this.data.setBufferedTileSize(bufferedTileSize);
        this.data.setMultipleValueBuffer(new MultiValueCollectorBuffer(bufferedTileSize, bufferedTileSize));
        this.data.setNeedsExpensiveSmoothing(needsExpensiveSmoothing);
        this.data.setMinValue(minValue);
        this.data.setMaxValue(maxValue);
        this.centralCellValues = new int[bufferedTileSize][bufferedTileSize];
    }

    public HeightCollectorTileData getData() {
        return this.data;
    }

    public void setData(HeightCollectorTileData data) {
        this.data = data;
    }

    public BoundingBox getLatLonBBox() {
        return this.data.getLatLonBBox();
    }

    public int getPixelTileSize() {
        return this.data.getPixelTileSize();
    }

    public int getBufferedTileSize() {
        return this.data.getBufferedTileSize();
    }

    public BoundingBox getLatLonCollectFromBox() {
        return this.data.getLatLonCollectFromBox();
    }

    public int getSubTileSizeX() {
        return this.data.getSubTileSizeX();
    }

    public int getSubTileSizeY() {
        return this.data.getSubTileSizeY();
    }

    public float getMinValue() {
        return this.data.getMinValue();
    }

    public float getMaxValue() {
        return this.data.getMaxValue();
    }

    public boolean needsExpensiveSmoothing() {
        return this.data.isNeedsExpensiveSmoothing();
    }

    public MultiValueCollectorBuffer getMultipleValueBuffer() {
        return this.data.getMultipleValueBuffer();
    }

    public boolean performNeedsExpensiveSmoothingCheck(double inputCellWidth, double inputCellHeight, long tileSize) {
        double collectorTileLonLeft = this.getLatLonBBox().getLeft();
        double collectorTileLonRight = this.getLatLonBBox().getRight();
        double collectorTileLatBottom = this.getLatLonBBox().getBottom();
        double collectorTileLatTop = this.getLatLonBBox().getTop();
        double collectorCellWidth = Math.abs(collectorTileLonRight - collectorTileLonLeft) / (double)tileSize;
        double collectorCellHeight = Math.abs(collectorTileLatTop - collectorTileLatBottom) / (double)tileSize;
        if (collectorCellWidth >= inputCellWidth / 3.0 || collectorCellHeight >= inputCellHeight / 3.0) {
            this.data.setNeedsExpensiveSmoothing(true);
        }
        return this.needsExpensiveSmoothing();
    }

    public void addValueSimple(double leftLon, double topLat, double rightLon, double bottomLat, double zoom, float value, AbstractMapTileOutput tileOutputter) {
        int bottomCellIndex;
        int topCellIndex;
        Point leftTopXYPixel = tileOutputter.getLonLatToPixel(leftLon, topLat, zoom);
        Point rightBottomXYPixel = tileOutputter.getLonLatToPixel(rightLon, bottomLat, zoom);
        double leftX = leftTopXYPixel.getX();
        double rightX = rightBottomXYPixel.getX();
        double topY = leftTopXYPixel.getY();
        double bottomY = rightBottomXYPixel.getY();
        Point collectorTileLeftTopXYPixel = tileOutputter.getLonLatToPixel(this.getLatLonBBox().getLeft(), this.getLatLonBBox().getTop(), zoom);
        double collectorTileXLeft = collectorTileLeftTopXYPixel.getX();
        double collectorTileYTop = collectorTileLeftTopXYPixel.getY();
        double topPixel = topY - collectorTileYTop;
        double bottomPixel = bottomY - collectorTileYTop;
        double leftPixel = leftX - collectorTileXLeft;
        double rightPixel = rightX - collectorTileXLeft;
        int leftCellIndex = (int)Math.floor(leftPixel);
        if (leftCellIndex < -50) {
            leftCellIndex = -50;
        } else if (leftCellIndex > this.getPixelTileSize() + 50) {
            leftCellIndex = this.getPixelTileSize() + 50;
        }
        int rightCellIndex = (int)Math.ceil(rightPixel);
        if (rightCellIndex <= leftCellIndex) {
            rightCellIndex = leftCellIndex + 1;
        }
        if (rightCellIndex < -50) {
            rightCellIndex = -50;
        }
        if (rightCellIndex > this.getPixelTileSize() + 50) {
            rightCellIndex = this.getPixelTileSize() + 50;
        }
        if ((topCellIndex = (int)Math.floor(topPixel)) < -50) {
            topCellIndex = -50;
        }
        if (topCellIndex >= this.getPixelTileSize() + 50) {
            topCellIndex = this.getPixelTileSize() + 50;
        }
        if ((bottomCellIndex = (int)Math.ceil(bottomPixel)) <= topCellIndex) {
            bottomCellIndex = topCellIndex + 1;
        }
        if (bottomCellIndex < -50) {
            bottomCellIndex = -50;
        }
        if (bottomCellIndex > this.getPixelTileSize() + 50) {
            bottomCellIndex = this.getPixelTileSize() + 50;
        }
        int currentCellSizeX = rightCellIndex - leftCellIndex;
        this.data.setSubTileSizeX(Math.max(this.getSubTileSizeX(), currentCellSizeX));
        this.data.setSubTileSizeX(Math.max(this.getSubTileSizeX(), 1));
        int currentCellSizeY = bottomCellIndex - topCellIndex;
        this.data.setSubTileSizeY(Math.max(this.getSubTileSizeY(), currentCellSizeY));
        this.data.setSubTileSizeY(Math.max(this.getSubTileSizeY(), 1));
        if (currentCellSizeX > 1 && currentCellSizeY > 1 && (currentCellSizeX > 2 || currentCellSizeY > 2)) {
            this.needsCentralCellValuesPostProcessing = true;
            this.maxCentralCellSize = Math.max(this.maxCentralCellSize, currentCellSizeX);
            this.maxCentralCellSize = Math.max(this.maxCentralCellSize, currentCellSizeY);
        }
        for (int yPixelCell = topCellIndex; yPixelCell < bottomCellIndex; ++yPixelCell) {
            for (int xPixelCell = leftCellIndex; xPixelCell < rightCellIndex; ++xPixelCell) {
                this.data.getMultipleValueBuffer().addValue(xPixelCell + 50, yPixelCell + 50, value);
                this.data.setMinValue(Math.min(this.getMinValue(), value));
                this.data.setMaxValue(Math.max(this.getMaxValue(), value));
                this.centralCellValues[xPixelCell + 50][yPixelCell + 50] = 1;
            }
        }
        if (currentCellSizeX > 0 && currentCellSizeY > 0) {
            int centerCellX = (rightCellIndex + leftCellIndex) / 2;
            int centerCellY = (bottomCellIndex + topCellIndex) / 2;
            this.centralCellValues[centerCellX + 50][centerCellY + 50] = 2;
        }
    }

    public void addValue(double leftLon, double topLat, double rightLon, double bottomLat, double zoom, float value, float[] surroundingCellHeights, AbstractMapTileOutput tileOutputter) {
        int bottomCellIndex;
        int topCellIndex;
        int rightCellIndex;
        int leftCellIndex;
        Point leftTopXYPixel = tileOutputter.getLonLatToPixel(leftLon, topLat, zoom);
        Point rightBottomXYPixel = tileOutputter.getLonLatToPixel(rightLon, bottomLat, zoom);
        double leftX = leftTopXYPixel.getX();
        double rightX = rightBottomXYPixel.getX();
        double topY = leftTopXYPixel.getY();
        double bottomY = rightBottomXYPixel.getY();
        Point collectorTileLeftTopXYPixel = tileOutputter.getLonLatToPixel(this.getLatLonBBox().getLeft(), this.getLatLonBBox().getTop(), zoom);
        double collectorTileXLeft = collectorTileLeftTopXYPixel.getX();
        double collectorTileYTop = collectorTileLeftTopXYPixel.getY();
        double topPixel = topY - collectorTileYTop;
        double bottomPixel = bottomY - collectorTileYTop;
        double leftPixel = leftX - collectorTileXLeft;
        double rightPixel = rightX - collectorTileXLeft;
        int oversizing = 0;
        int leftCellIndexWithoutBorders = leftCellIndex = (int)Math.floor(leftPixel) - oversizing;
        if (leftCellIndex < -50) {
            leftCellIndex = -50;
        }
        int rightCellIndexWithoutBorders = rightCellIndex = (int)Math.floor(rightPixel) + oversizing;
        if (rightCellIndex == leftCellIndex) {
            rightCellIndex = leftCellIndex + 1;
        }
        if (rightCellIndex < -50) {
            rightCellIndex = -50;
        }
        if (rightCellIndex > this.getPixelTileSize() + 50) {
            rightCellIndex = this.getPixelTileSize() + 50;
        }
        int topCellIndexWithoutBorders = topCellIndex = (int)Math.floor(topPixel) - oversizing;
        if (topCellIndex < -50) {
            topCellIndex = -50;
        }
        int bottomCellIndexWithoutBorders = bottomCellIndex = (int)Math.floor(bottomPixel) + oversizing;
        if (bottomCellIndex == topCellIndex) {
            bottomCellIndex = topCellIndex + 1;
        }
        if (bottomCellIndex < -50) {
            bottomCellIndex = -50;
        }
        if (bottomCellIndex > this.getPixelTileSize() + 50) {
            bottomCellIndex = this.getPixelTileSize() + 50;
        }
        int cellPixelsWidth = Math.abs(rightCellIndexWithoutBorders - leftCellIndexWithoutBorders);
        int cellPixelsHeight = Math.abs(topCellIndexWithoutBorders - bottomCellIndexWithoutBorders);
        int currentCellSizeX = rightCellIndex - leftCellIndex;
        this.data.setSubTileSizeX(Math.max(this.getSubTileSizeX(), currentCellSizeX));
        this.data.setSubTileSizeX(Math.max(this.getSubTileSizeX(), 1));
        int currentCellSizeY = bottomCellIndex - topCellIndex;
        this.data.setSubTileSizeY(Math.max(this.getSubTileSizeY(), currentCellSizeY));
        this.data.setSubTileSizeY(Math.max(this.getSubTileSizeY(), 1));
        for (int yPixelCell = topCellIndex; yPixelCell < bottomCellIndex; ++yPixelCell) {
            for (int xPixelCell = leftCellIndex; xPixelCell < rightCellIndex; ++xPixelCell) {
                float newValue;
                float newValue2;
                int bottomSmoothIndex;
                int topSmoothIndex;
                int rightSmoothIndex;
                float cellPositionX = xPixelCell - leftCellIndexWithoutBorders;
                float cellPositionY = yPixelCell - topCellIndexWithoutBorders;
                int xWithBorder = xPixelCell + 50;
                int yWithBorder = yPixelCell + 50;
                int leftSmoothIndex = xWithBorder - this.getSubTileSizeX() / 2 - 1;
                if (leftSmoothIndex < 0) {
                    leftSmoothIndex = 0;
                }
                if ((rightSmoothIndex = xWithBorder + this.getSubTileSizeX() / 2 + 1) == leftSmoothIndex) {
                    rightSmoothIndex = leftSmoothIndex + 1;
                }
                if (rightSmoothIndex > this.getBufferedTileSize()) {
                    rightSmoothIndex = this.getBufferedTileSize();
                }
                if ((topSmoothIndex = yWithBorder - this.getSubTileSizeY() / 2 - 1) < 0) {
                    topSmoothIndex = 0;
                }
                if ((bottomSmoothIndex = yWithBorder + this.getSubTileSizeY() / 2 + 1) == topSmoothIndex) {
                    bottomSmoothIndex = topSmoothIndex + 1;
                }
                if (bottomSmoothIndex > this.getBufferedTileSize()) {
                    bottomSmoothIndex = this.getBufferedTileSize();
                }
                float[] surroundingHeights = surroundingCellHeights;
                float halfCellWidth = (float)cellPixelsWidth / 2.0f;
                float halfCellHeight = (float)cellPixelsHeight / 2.0f;
                float ratioX = 1.0f;
                ratioX = cellPositionX < halfCellWidth ? 0.5f + 0.5f * (cellPositionX / halfCellWidth) : 0.5f + 0.5f * (((float)cellPixelsWidth - cellPositionX) / halfCellWidth);
                float ratioY = 1.0f;
                ratioY = cellPositionY < halfCellHeight ? 0.5f + 0.5f * (cellPositionY / halfCellHeight) : 0.5f + 0.5f * (((float)cellPixelsHeight - cellPositionY) / halfCellHeight);
                if (cellPositionX == halfCellWidth && cellPositionY == halfCellHeight) {
                    newValue2 = surroundingHeights[4];
                    this.getMultipleValueBuffer().addValue(xPixelCell + 50, yPixelCell + 50, newValue2);
                    this.data.setMinValue(Math.min(this.getMinValue(), newValue2));
                    this.data.setMaxValue(Math.max(this.getMaxValue(), newValue2));
                    continue;
                }
                if (cellPositionX == halfCellWidth) {
                    if (cellPositionY < halfCellHeight) {
                        newValue2 = surroundingHeights[4] * ratioY + surroundingHeights[1] * (1.0f - ratioY);
                        this.getMultipleValueBuffer().addValue(xPixelCell + 50, yPixelCell + 50, newValue2);
                        this.data.setMinValue(Math.min(this.getMinValue(), newValue2));
                        this.data.setMaxValue(Math.max(this.getMaxValue(), newValue2));
                        continue;
                    }
                    newValue2 = surroundingHeights[4] * ratioY + surroundingHeights[7] * (1.0f - ratioY);
                    this.getMultipleValueBuffer().addValue(xPixelCell + 50, yPixelCell + 50, newValue2);
                    this.data.setMinValue(Math.min(this.getMinValue(), newValue2));
                    this.data.setMaxValue(Math.max(this.getMaxValue(), newValue2));
                    continue;
                }
                if (cellPositionY == halfCellHeight) {
                    if (cellPositionX < halfCellWidth) {
                        newValue2 = surroundingHeights[4] * ratioX + surroundingHeights[3] * (1.0f - ratioX);
                        this.getMultipleValueBuffer().addValue(xPixelCell + 50, yPixelCell + 50, newValue2);
                        this.data.setMinValue(Math.min(this.getMinValue(), newValue2));
                        this.data.setMaxValue(Math.max(this.getMaxValue(), newValue2));
                        continue;
                    }
                    newValue2 = surroundingHeights[4] * ratioX + surroundingHeights[5] * (1.0f - ratioX);
                    this.getMultipleValueBuffer().addValue(xPixelCell + 50, yPixelCell + 50, newValue2);
                    this.data.setMinValue(Math.min(this.getMinValue(), newValue2));
                    this.data.setMaxValue(Math.max(this.getMaxValue(), newValue2));
                    continue;
                }
                float ratioC = ratioX * ratioY;
                float ratioN = (1.0f - ratioY) * ratioX;
                float ratioE = (1.0f - ratioX) * ratioY;
                float ratioS = (1.0f - ratioY) * ratioX;
                float ratioW = (1.0f - ratioX) * ratioY;
                float ratioNE = (1.0f - ratioX) * (1.0f - ratioY);
                float ratioSE = (1.0f - ratioX) * (1.0f - ratioY);
                float ratioSW = (1.0f - ratioX) * (1.0f - ratioY);
                float ratioNW = (1.0f - ratioX) * (1.0f - ratioY);
                float partC = surroundingHeights[4] * ratioC;
                float partN = surroundingHeights[1] * ratioN;
                float partE = surroundingHeights[5] * ratioE;
                float partS = surroundingHeights[7] * ratioS;
                float partW = surroundingHeights[3] * ratioW;
                float partNE = surroundingHeights[2] * ratioNE;
                float partSE = surroundingHeights[8] * ratioSE;
                float partSW = surroundingHeights[6] * ratioSW;
                float partNW = surroundingHeights[0] * ratioNW;
                if (cellPositionY < halfCellHeight && cellPositionX < halfCellWidth) {
                    newValue = partC + partN + partW + partNW;
                    this.getMultipleValueBuffer().addValue(xPixelCell + 50, yPixelCell + 50, newValue);
                    this.data.setMinValue(Math.min(this.getMinValue(), newValue));
                    this.data.setMaxValue(Math.max(this.getMaxValue(), newValue));
                    continue;
                }
                if (cellPositionY < halfCellHeight && cellPositionX > halfCellWidth) {
                    newValue = partC + partN + partE + partNE;
                    this.getMultipleValueBuffer().addValue(xPixelCell + 50, yPixelCell + 50, newValue);
                    this.data.setMinValue(Math.min(this.getMinValue(), newValue));
                    this.data.setMaxValue(Math.max(this.getMaxValue(), newValue));
                    continue;
                }
                if (cellPositionY > halfCellHeight && cellPositionX > halfCellWidth) {
                    newValue = partC + partS + partE + partSE;
                    this.getMultipleValueBuffer().addValue(xPixelCell + 50, yPixelCell + 50, newValue);
                    this.data.setMinValue(Math.min(this.getMinValue(), newValue));
                    this.data.setMaxValue(Math.max(this.getMaxValue(), newValue));
                    continue;
                }
                if (!(cellPositionY > halfCellHeight) || !(cellPositionX < halfCellWidth)) continue;
                newValue = partC + partS + partW + partSW;
                this.getMultipleValueBuffer().addValue(xPixelCell + 50, yPixelCell + 50, newValue);
                this.data.setMinValue(Math.min(this.getMinValue(), newValue));
                this.data.setMaxValue(Math.max(this.getMaxValue(), newValue));
            }
        }
    }

    public float getValue(int xPixel, int yPixel) {
        return this.getMultipleValueBuffer().getAveragedValue(xPixel + 50, yPixel + 50);
    }

    public float getMaxValue(int xPixel, int yPixel) {
        return this.getMultipleValueBuffer().getMaxValue(xPixel + 50, yPixel + 50);
    }

    public void setValue(int xPixel, int yPixel, float value) {
        this.getMultipleValueBuffer().setValue(xPixel + 50, yPixel + 50, 0, value);
        this.getMultipleValueBuffer().setValue(xPixel + 50, yPixel + 50, 3, value);
        this.getMultipleValueBuffer().setValue(xPixel + 50, yPixel + 50, 2, value);
        this.getMultipleValueBuffer().setValue(xPixel + 50, yPixel + 50, 4, value);
        this.getMultipleValueBuffer().setValue(xPixel + 50, yPixel + 50, 1, 1.0f);
    }

    public float getValueFromBuffer(int xPixel, int yPixel) {
        return this.getMultipleValueBuffer().getAveragedValue(xPixel, yPixel);
    }

    public void setValueToBuffer(int xPixel, int yPixel, float value) {
        this.getMultipleValueBuffer().setValue(xPixel, yPixel, 0, value);
        this.getMultipleValueBuffer().setValue(xPixel, yPixel, 3, value);
        this.getMultipleValueBuffer().setValue(xPixel, yPixel, 2, value);
        this.getMultipleValueBuffer().setValue(xPixel, yPixel, 4, value);
        this.getMultipleValueBuffer().setValue(xPixel, yPixel, 1, 1.0f);
    }

    public boolean isInCollectorBounds(Line line) {
        Point start = line.getStart();
        Point stop = line.getStop();
        return start.getX() > -50.0 && start.getX() < (double)(this.getBufferedTileSize() - 50) && start.getY() > -50.0 && start.getY() < (double)(this.getBufferedTileSize() - 50) && stop.getX() > -50.0 && stop.getX() < (double)(this.getBufferedTileSize() - 50) && stop.getY() > -50.0 && stop.getY() < (double)(this.getBufferedTileSize() - 50);
    }

    public boolean needsCentralCellValuesPostProcessing() {
        return this.needsCentralCellValuesPostProcessing;
    }

    public void postProcessCentralCellValues() {
        int maxIterations = this.maxCentralCellSize;
        float[][] tempValues = new float[this.data.getBufferedTileSize()][this.data.getBufferedTileSize()];
        for (int i = 0; i < maxIterations; ++i) {
            int x;
            int y;
            for (y = 1; y < this.getBufferedTileSize() - 1; ++y) {
                for (x = 1; x < this.getBufferedTileSize() - 1; ++x) {
                    float valueNew;
                    float center = this.getData().getMultipleValueBuffer().getAveragedValue(x, y);
                    float left = this.getData().getMultipleValueBuffer().getAveragedValue(x - 1, y);
                    float leftTop = this.getData().getMultipleValueBuffer().getAveragedValue(x - 1, y - 1);
                    float top = this.getData().getMultipleValueBuffer().getAveragedValue(x, y - 1);
                    float rightTop = this.getData().getMultipleValueBuffer().getAveragedValue(x + 1, y - 1);
                    float right = this.getData().getMultipleValueBuffer().getAveragedValue(x + 1, y);
                    float rightBottom = this.getData().getMultipleValueBuffer().getAveragedValue(x + 1, y + 1);
                    float bottom = this.getData().getMultipleValueBuffer().getAveragedValue(x, y + 1);
                    float leftBottom = this.getData().getMultipleValueBuffer().getAveragedValue(x - 1, y + 1);
                    tempValues[x][y] = valueNew = (center + leftTop + rightTop + rightBottom + leftBottom + left + top + right + bottom) / 9.0f;
                }
            }
            for (y = 1; y < this.getBufferedTileSize() - 1; ++y) {
                for (x = 1; x < this.getBufferedTileSize() - 1; ++x) {
                    this.getData().getMultipleValueBuffer().setValue(x, y, 4, tempValues[x][y]);
                    this.getData().getMultipleValueBuffer().setValue(x, y, 0, tempValues[x][y]);
                    this.getData().getMultipleValueBuffer().setValue(x, y, 2, tempValues[x][y]);
                    this.getData().getMultipleValueBuffer().setValue(x, y, 3, tempValues[x][y]);
                    this.getData().getMultipleValueBuffer().setValue(x, y, 1, 1.0f);
                }
            }
        }
    }

    public HeightCollectorTile blur(int blurRadius) {
        MultiValueCollectorBuffer newMultipleValueBuffer = new MultiValueCollectorBuffer(this.getBufferedTileSize(), this.getBufferedTileSize());
        for (int y = 0; y < this.getBufferedTileSize(); ++y) {
            for (int x = 0; x < this.getBufferedTileSize(); ++x) {
                float smoothedValue;
                int bottomSmoothIndex;
                int topSmoothIndex;
                int rightSmoothIndex;
                int leftSmoothIndex = x - blurRadius;
                if (leftSmoothIndex < 0) {
                    leftSmoothIndex = 0;
                }
                if ((rightSmoothIndex = x + blurRadius) == leftSmoothIndex) {
                    rightSmoothIndex = leftSmoothIndex + 1;
                }
                if (rightSmoothIndex >= this.getBufferedTileSize()) {
                    rightSmoothIndex = this.getBufferedTileSize() - 1;
                }
                if ((topSmoothIndex = y - blurRadius) < 0) {
                    topSmoothIndex = 0;
                }
                if ((bottomSmoothIndex = y + blurRadius) == topSmoothIndex) {
                    bottomSmoothIndex = topSmoothIndex + 1;
                }
                if (bottomSmoothIndex >= this.getBufferedTileSize()) {
                    bottomSmoothIndex = this.getBufferedTileSize() - 1;
                }
                int sampleSizeX = 1;
                int sampleSizeY = 1;
                float totalValues = 0.0f;
                float counter = 0.0f;
                for (int i = leftSmoothIndex; i < rightSmoothIndex; i += sampleSizeX) {
                    for (int j = topSmoothIndex; j < bottomSmoothIndex; j += sampleSizeY) {
                        totalValues += this.getMultipleValueBuffer().getAveragedValue(i, j);
                        counter += 1.0f;
                    }
                }
                if (counter != 0.0f) {
                    smoothedValue = totalValues / counter;
                    newMultipleValueBuffer.addValue(x, y, smoothedValue);
                    continue;
                }
                smoothedValue = this.getMultipleValueBuffer().getAveragedValue(x, y);
                newMultipleValueBuffer.addValue(x, y, smoothedValue);
            }
        }
        this.data.setMultipleValueBuffer(newMultipleValueBuffer);
        return this;
    }

    public void logBuffer() {
        this.logBuffer(0, 0, this.getMultipleValueBuffer().getXSize(), 0, this.getMultipleValueBuffer().getYSize());
    }

    public void logBuffer(int z, int xMin, int xMax, int yMin, int yMax) {
        System.out.println("################################################# logBuffer HeightCollectTile");
        for (int y = yMin; y < yMax; ++y) {
            StringBuffer rowBuffy = new StringBuffer();
            for (int x = xMin; x < xMax; ++x) {
                float value = this.getMultipleValueBuffer().getValue(x, y, z);
                String lengthFilledValue = String.format("%.5f", Float.valueOf(value));
                rowBuffy.append(lengthFilledValue);
                rowBuffy.append(", ");
            }
            System.out.println("######################### " + y + ": " + rowBuffy.toString());
        }
    }

    public void logCentralCellValue() {
        System.out.println("################################################# logCentralCellValue HeightCollectTile");
        for (int y = 0; y < this.centralCellValues[0].length; ++y) {
            StringBuffer rowBuffy = new StringBuffer();
            for (int x = 0; x < this.centralCellValues.length; ++x) {
                if (this.centralCellValues[x][y] == 2) {
                    rowBuffy.append("1");
                } else if (this.centralCellValues[x][y] == 1) {
                    rowBuffy.append("0");
                } else {
                    rowBuffy.append(" ");
                }
                rowBuffy.append(", ");
            }
            System.out.println("######################### " + y + ": " + rowBuffy.toString());
        }
        System.out.println("######################### needsCentralCellValuesPostProcessing=" + this.needsCentralCellValuesPostProcessing);
    }

    public void logBufferAveraged() {
        this.logBufferAveraged(0, this.getMultipleValueBuffer().getXSize(), 0, this.getMultipleValueBuffer().getYSize());
    }

    public void logBufferAveraged(int xMin, int xMax, int yMin, int yMax) {
        System.out.println("################################################# logBuffer HeightCollectTile");
        StringBuffer rowBuffy = new StringBuffer();
        for (int x = xMin; x < xMax; ++x) {
            String column = String.format("%12s", "" + x);
            rowBuffy.append(column);
            rowBuffy.append(", ");
        }
        System.out.println("#########################  : " + rowBuffy.toString());
        for (int y = yMin; y < yMax; ++y) {
            rowBuffy = new StringBuffer();
            for (int x = xMin; x < xMax; ++x) {
                float value = this.getMultipleValueBuffer().getAveragedValue(x, y);
                String isCentralCellMarker = "  ";
                if (this.centralCellValues[x][y] == 2) {
                    isCentralCellMarker = "x ";
                } else if (this.centralCellValues[x][y] == 1) {
                    isCentralCellMarker = "o ";
                }
                String lengthFilledValue = isCentralCellMarker + String.format("%10s", String.format("%.5f", Float.valueOf(value)));
                rowBuffy.append(lengthFilledValue);
                rowBuffy.append(", ");
            }
            System.out.println("######################### " + y + ": " + rowBuffy.toString());
        }
    }
}

