/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.gebco;

import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.request.RenderRequest;
import de.wideportal.maprender.resources.height.HeightCollectorTile;
import de.wideportal.maprender.resources.height.ITile;
import de.wideportal.maprender.resources.height.ITileCache;
import de.wideportal.maprender.resources.output.format.AbstractMapTileOutput;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GebcoTile
implements ITile {
    private static final long serialVersionUID = -9178130789447658084L;
    public static final int BORDER_WIDTH = 1;
    public static final float VOID_VALUE = -32768.0f;
    public static final int NW = 0;
    public static final int N = 1;
    public static final int NE = 2;
    public static final int W = 3;
    public static final int C = 4;
    public static final int E = 5;
    public static final int SW = 6;
    public static final int S = 7;
    public static final int SE = 8;
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private float[][] rawBuffer;
    private int lat;
    private int lon;
    private int gebcoTileSize;
    private int heightDiffThreshold;
    private int heightPointDiffThreshold;
    private boolean loaded = false;
    private boolean flattened = false;
    private boolean mocked = false;
    private String fileName = null;

    public GebcoTile(int lat, int lon, int heightDiffThreshold, int heightPointDiffThreshold) {
        this.lat = lat;
        this.lon = lon;
        this.heightDiffThreshold = heightDiffThreshold;
        this.heightPointDiffThreshold = heightPointDiffThreshold;
    }

    @Override
    public boolean containsCell(double lon, double lat) {
        return (double)this.lat <= lat && (double)(this.lat + 90) > lat && (double)this.lon <= lon && (double)(this.lon + 90) > lon;
    }

    @Override
    public float[][] getRawBuffer() {
        return this.rawBuffer;
    }

    @Override
    public float[][] getFlattenedBuffer() {
        return this.rawBuffer;
    }

    @Override
    public void setMockedRawBuffer(int tileSizeForMock, String fileName) {
        this.fileName = fileName;
        this.rawBuffer = new float[tileSizeForMock][tileSizeForMock];
        this.gebcoTileSize = tileSizeForMock;
        this.loaded = true;
        this.flattened = true;
        this.mocked = true;
    }

    @Override
    public void setRawBuffer(float[][] rawBuffer, String fileName) {
        this.fileName = fileName;
        this.rawBuffer = rawBuffer;
        this.gebcoTileSize = rawBuffer.length;
        this.loaded = true;
    }

    public void setRawBuffer(BufferedImage bufferedImage, String fileName) {
        this.fileName = fileName;
        this.rawBuffer = this.convertToArray(bufferedImage);
        this.gebcoTileSize = this.rawBuffer.length;
        this.loaded = true;
    }

    private float[][] convertToArray(BufferedImage bufferedImage) {
        Raster raster = bufferedImage.getData();
        int width = raster.getWidth();
        int height = raster.getHeight();
        int size = Math.max(width, height);
        float[][] result = new float[size][size];
        double ratioX = (double)width / (double)size;
        double ratioY = (double)height / (double)size;
        float[] valuePixel = new float[5];
        float[][] stretched = new float[size][size];
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                int x = (int)((double)i * ratioX);
                int y = (int)((double)j * ratioY);
                valuePixel = raster.getPixel(x, y, valuePixel);
                stretched[j][i] = valuePixel[0];
            }
        }
        result = stretched;
        return result;
    }

    @Override
    public int getLat() {
        return this.lat;
    }

    @Override
    public void setLat(int lat) {
        this.lat = lat;
    }

    @Override
    public int getLon() {
        return this.lon;
    }

    @Override
    public void setLon(int lon) {
        this.lon = lon;
    }

    @Override
    public int getTileSize() {
        return this.gebcoTileSize;
    }

    @Override
    public boolean isMocked() {
        return this.mocked;
    }

    @Override
    public void setMocked(boolean mocked) {
        this.mocked = mocked;
    }

    @Override
    public boolean isFlattened() {
        return this.flattened;
    }

    @Override
    public BoundingBox getBoundingBox() {
        return new BoundingBox(this.lon, this.lat, this.lon + 90, this.lat + 90);
    }

    @Override
    public int getHeightDiffThreshold() {
        return this.heightDiffThreshold;
    }

    @Override
    public void setHeightDiffThreshold(int heightDiffThreshold) {
        this.heightDiffThreshold = heightDiffThreshold;
    }

    @Override
    public int getHeightPointDiffThreshold() {
        return this.heightPointDiffThreshold;
    }

    @Override
    public void setHeightPointDiffThreshold(int heightPointDiffThreshold) {
        this.heightPointDiffThreshold = heightPointDiffThreshold;
    }

    @Override
    public ITile[] getSurroundingTiles(ITileCache gebcoTileCache) {
        ITile[] tiles = new GebcoTile[9];
        int counter = 0;
        for (int latShift = 1; latShift >= -1; --latShift) {
            for (int lonShift = -1; lonShift <= 1; ++lonShift) {
                GebcoTile currentTile = (GebcoTile)this.getSurroundingTile(gebcoTileCache, lonShift, latShift);
                tiles[counter] = currentTile;
                ++counter;
            }
        }
        return tiles;
    }

    @Override
    public ITile getSurroundingTile(ITileCache gebcoTileCache, int lonShift, int latShift) {
        ITile currentTile = gebcoTileCache.getCachedTile(this.lon + lonShift * 90, this.lat + latShift * 90, this.heightDiffThreshold, this.heightPointDiffThreshold);
        if (!currentTile.isLoaded()) {
            gebcoTileCache.loadTile(currentTile, this.heightDiffThreshold);
        }
        return currentTile;
    }

    @Override
    public HeightCollectorTile renderIntoCollector(int zoom, int xTileIndex, int yTileIndex, RenderRequest renderRequest, HeightCollectorTile collector, AbstractMapTileOutput tileOutputter, ITileCache tileCache) {
        this.log.debug("renderIntoCollector: start rendering Gebco tile " + this.fileName + " into collector tile");
        if (this.loaded) {
            BoundingBox collectorBBox = collector.getLatLonCollectFromBox();
            double cellSize = 90.0 / (double)(this.gebcoTileSize - 2);
            double minRelevantLon = collectorBBox.getLeft();
            double maxRelevantLon = collectorBBox.getRight();
            double minRelevantLat = collectorBBox.getBottom();
            double maxRelevantLat = collectorBBox.getTop();
            int leftIndex = (int)Math.floor((minRelevantLon - (double)this.lon) / cellSize);
            int topIndex = (int)Math.floor(((double)this.lat + 90.0 - maxRelevantLat) / cellSize);
            int rightIndex = (int)Math.ceil((maxRelevantLon - (double)this.lon) / cellSize);
            int bottomIndex = (int)Math.ceil(((double)this.lat + 90.0 - minRelevantLat) / cellSize);
            if (leftIndex < 1) {
                leftIndex = 1;
            }
            if (topIndex < 1) {
                topIndex = 1;
            }
            if (rightIndex > this.gebcoTileSize - 1) {
                rightIndex = this.gebcoTileSize - 1;
            }
            if (bottomIndex > this.gebcoTileSize - 1) {
                bottomIndex = this.gebcoTileSize - 1;
            }
            for (int y = topIndex; y < bottomIndex; ++y) {
                for (int x = leftIndex; x < rightIndex; ++x) {
                    double cellShift = cellSize / 2.0;
                    double cellLeft = (double)this.lon + (double)x * cellSize - cellShift;
                    double cellRight = cellLeft + cellSize;
                    double cellTop = (double)(this.lat + 90) - (double)y * cellSize + cellShift;
                    double cellBottom = cellTop - cellSize;
                    float value = this.rawBuffer[y][x];
                    float[] gebcoSurroundingCellHeights = new float[9];
                    gebcoSurroundingCellHeights[4] = this.rawBuffer[y][x];
                    gebcoSurroundingCellHeights[0] = this.rawBuffer[y - 1][x - 1];
                    gebcoSurroundingCellHeights[1] = this.rawBuffer[y - 1][x];
                    gebcoSurroundingCellHeights[2] = this.rawBuffer[y - 1][x + 1];
                    gebcoSurroundingCellHeights[3] = this.rawBuffer[y][x - 1];
                    gebcoSurroundingCellHeights[5] = this.rawBuffer[y][x + 1];
                    gebcoSurroundingCellHeights[6] = this.rawBuffer[y + 1][x - 1];
                    gebcoSurroundingCellHeights[7] = this.rawBuffer[y + 1][x];
                    gebcoSurroundingCellHeights[8] = this.rawBuffer[y + 1][x + 1];
                    collector.addValue(cellLeft, cellTop, cellRight, cellBottom, zoom, value, gebcoSurroundingCellHeights, tileOutputter);
                }
            }
        }
        this.log.debug("renderIntoCollector: finished renderering srtm tile " + this.fileName + " into collector tile");
        return collector;
    }

    @Override
    public void flatten(int zoom, int xTileIndex, int yTileIndex, RenderRequest renderRequest) {
    }

    public boolean equals(Object other) {
        if (!this.getClass().isAssignableFrom(other.getClass())) {
            return false;
        }
        GebcoTile otherTile = (GebcoTile)other;
        return this.lat == otherTile.lat && this.lon == otherTile.lon && this.heightDiffThreshold == otherTile.heightDiffThreshold;
    }

    @Override
    public void logBufferFlattened() {
        for (int y = 0; y < this.rawBuffer.length; ++y) {
            StringBuffer rowBuffy = new StringBuffer();
            for (int x = 0; x < this.rawBuffer[y].length; ++x) {
                float value = this.rawBuffer[y][x];
                if (value != 0.0f) {
                    rowBuffy.append("1");
                    continue;
                }
                rowBuffy.append("0");
            }
        }
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String toString() {
        return "GebcoTile[lon=" + this.lon + ", lat=" + this.lat + ", loaded=" + this.loaded + ", heightDiffThreshold=" + this.heightDiffThreshold + ", size=[" + this.rawBuffer.length + "][" + this.rawBuffer[0].length + "]]";
    }
}

