/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.file;

import java.io.File;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileAccessor {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public Optional<File> getFile(String baseFolder, int zoom, int xIndex, int yIndex, String fileType, boolean createMissingFolders) {
        File xFolder;
        File rootFolder;
        if (!((String)(baseFolder = ((String)baseFolder).replaceAll("\\\\", "/"))).endsWith("/")) {
            baseFolder = (String)baseFolder + "/";
        }
        if (!(rootFolder = new File((String)baseFolder)).exists()) {
            if (createMissingFolders) {
                this.log.error("getFile: the folder does not exist. Trying to create it : " + (String)baseFolder);
                rootFolder.mkdirs();
            } else {
                return Optional.empty();
            }
        }
        if (!rootFolder.canWrite()) {
            this.log.error("getFile: the folder is not writable. Can not save tile: " + (String)baseFolder);
            return Optional.empty();
        }
        File zoomFolder = new File((String)baseFolder + zoom + "/");
        if (!zoomFolder.exists()) {
            if (createMissingFolders) {
                zoomFolder.mkdir();
            } else {
                return Optional.empty();
            }
        }
        if (!(xFolder = new File((String)baseFolder + zoom + "/" + xIndex + "/")).exists()) {
            if (createMissingFolders) {
                xFolder.mkdir();
            } else {
                return Optional.empty();
            }
        }
        File yFile = new File((String)baseFolder + zoom + "/" + xIndex + "/" + yIndex + "." + fileType);
        return Optional.of(yFile);
    }

    public Optional<File> getFile(String baseFolder, int zoom, String fileType, boolean createMissingFolders) {
        File rootFolder;
        if (!((String)(baseFolder = ((String)baseFolder).replaceAll("\\\\", "/"))).endsWith("/")) {
            baseFolder = (String)baseFolder + "/";
        }
        if (!(rootFolder = new File((String)baseFolder)).exists()) {
            if (createMissingFolders) {
                this.log.error("getFile: the folder does not exist. Trying to create it : " + (String)baseFolder);
                rootFolder.mkdirs();
            } else {
                return Optional.empty();
            }
        }
        if (!rootFolder.canWrite()) {
            this.log.error("getFile: the folder is not writable. Can not save tile: " + (String)baseFolder);
            return Optional.empty();
        }
        File zoomFolder = new File((String)baseFolder + zoom + "/");
        if (!zoomFolder.exists()) {
            if (createMissingFolders) {
                zoomFolder.mkdir();
            } else {
                return Optional.empty();
            }
        }
        File yFile = new File((String)baseFolder + zoom + "/bigimage." + fileType);
        return Optional.of(yFile);
    }

    public String getFolderName(String baseFolder, int zoom, int xIndex, boolean createMissingFolders) {
        File xFolder;
        File zoomFolder;
        File baseFolderFile;
        if (!((String)(baseFolder = ((String)baseFolder).replaceAll("\\\\", "/"))).endsWith("/")) {
            baseFolder = (String)baseFolder + "/";
        }
        if (!(baseFolderFile = new File((String)baseFolder)).exists()) {
            if (createMissingFolders) {
                baseFolderFile.mkdir();
            } else {
                return null;
            }
        }
        if (!(zoomFolder = new File((String)baseFolder + zoom + "/")).exists()) {
            if (createMissingFolders) {
                zoomFolder.mkdir();
            } else {
                return null;
            }
        }
        if (!(xFolder = new File((String)baseFolder + zoom + "/" + xIndex + "/")).exists()) {
            if (createMissingFolders) {
                xFolder.mkdir();
            } else {
                return null;
            }
        }
        return (String)baseFolder + zoom + "/" + xIndex;
    }

    public String getFileName(String baseFolder, int zoom, int xIndex, int yIndex, String fileType, boolean createMissingFolders) {
        if (!((String)(baseFolder = ((String)baseFolder).replaceAll("\\\\", "/"))).endsWith("/")) {
            baseFolder = (String)baseFolder + "/";
        }
        return this.getFolderName((String)baseFolder, zoom, xIndex, createMissingFolders) + "/" + yIndex + "." + fileType;
    }

    public Optional<File> getFile(String baseFolder, String fileName, String fileType, boolean createMissingFolders) {
        File rootFolder;
        if (!((String)(baseFolder = ((String)baseFolder).replaceAll("\\\\", "/"))).endsWith("/")) {
            baseFolder = (String)baseFolder + "/";
        }
        if (!(rootFolder = new File((String)baseFolder)).exists()) {
            if (createMissingFolders) {
                this.log.error("getFile: the folder does not exist. Trying to create it : " + (String)baseFolder);
                rootFolder.mkdirs();
            } else {
                return Optional.empty();
            }
        }
        if (!rootFolder.canWrite()) {
            this.log.error("getFile: the folder is not writable. Can not save tile: " + (String)baseFolder);
            return Optional.empty();
        }
        File yFile = new File((String)baseFolder + "/" + fileName + "." + fileType);
        return Optional.of(yFile);
    }

    public Optional<File> getFile(String folderAndFileName, boolean createMissingFolders) {
        File folderAndFile = new File(folderAndFileName);
        File folder = folderAndFile.getParentFile();
        if (!folder.exists()) {
            if (createMissingFolders) {
                this.log.error("getFile: the folder does not exist. Trying to create it : " + folder);
                folder.mkdirs();
            } else {
                return Optional.empty();
            }
        }
        if (!folder.canWrite()) {
            this.log.error("getFile: the folder is not writable. Can not save tile: " + folderAndFile);
            return Optional.empty();
        }
        return Optional.of(folderAndFile);
    }
}

