/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.renderer.progress;

import de.wideportal.maprender.config.ConfigurationLoader;
import de.wideportal.maprender.config.xml.RenderConfiguration;
import de.wideportal.maprender.config.xml.RenderConfigurationJob;
import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.renderer.progress.RenderProgressTracking;
import de.wideportal.maprender.resources.file.TilesAsImagePersister;
import de.wideportal.maprender.resources.output.format.AbstractMapTileOutput;
import de.wideportal.maprender.resources.output.format.OutputFormatFactory;
import java.io.File;
import java.util.List;
import java.util.Optional;

public class RenderProgressTrackingVerifier {
    public void verify(String configurationFile) {
        try {
            ConfigurationLoader configurationLoader = new ConfigurationLoader();
            RenderConfiguration configuration = configurationLoader.loadConfiguration(configurationFile);
            int zoomMin = Integer.parseInt(configuration.getMaprenderConfiguration().getBounds().getMinzoom());
            int zoomMax = Integer.parseInt(configuration.getMaprenderConfiguration().getBounds().getMaxzoom());
            BoundingBox areaToRenderLatLon = new BoundingBox(configuration.getMaprenderConfiguration().getBounds().getBoundingbox());
            AbstractMapTileOutput tileOutputter = OutputFormatFactory.getInstance().getMapTileOutputter(configuration.getMaprenderConfiguration().getProcessing().getProjection());
            TilesAsImagePersister persister = new TilesAsImagePersister();
            List<RenderConfigurationJob> jobs = configuration.getMaprenderConfiguration().getJobs().getJobs();
            for (int jobIndex = 0; jobIndex < jobs.size(); ++jobIndex) {
                RenderConfigurationJob job = jobs.get(jobIndex);
                System.out.println("Job: " + job.getName());
                RenderProgressTracking renderProgressTracking = new RenderProgressTracking(configuration, jobs.get(jobIndex));
                renderProgressTracking.startTracking();
                for (int zoom = zoomMin; zoom <= zoomMax; ++zoom) {
                    System.out.println("Zoom: " + zoom);
                    BoundingBox minMaxTileIndexBoundingBox = tileOutputter.getMinMaxTileBoundingBox(areaToRenderLatLon, zoom);
                    int tileIndexLeft = (int)minMaxTileIndexBoundingBox.getLeft();
                    int tileIndexRight = (int)minMaxTileIndexBoundingBox.getRight();
                    int tileIndexTop = (int)minMaxTileIndexBoundingBox.getTop();
                    int tileIndexBottom = (int)minMaxTileIndexBoundingBox.getBottom();
                    if (tileIndexRight < tileIndexLeft) {
                        tileIndexRight = tileIndexLeft;
                    }
                    if (tileIndexBottom < tileIndexTop) {
                        tileIndexBottom = tileIndexTop;
                    }
                    for (int y = tileIndexTop; y <= tileIndexBottom; ++y) {
                        for (int x = tileIndexLeft; x <= tileIndexRight; ++x) {
                            if (x >= tileIndexLeft && x <= tileIndexRight && y >= tileIndexTop && y <= tileIndexBottom) {
                                String outputFolder = job.getOutput().getFile().getFolder();
                                Optional<File> optionalYFile = persister.getFile(outputFolder, zoom, x, y, "png", true);
                                File yFile = null;
                                if (optionalYFile.isPresent()) {
                                    yFile = optionalYFile.get();
                                } else {
                                    System.out.println("Error: file is not accessible. Cannot save tile. Base folder is: " + outputFolder);
                                }
                                if (yFile.canRead()) continue;
                                System.out.println("File: does not exist: " + yFile.getAbsolutePath());
                                if (renderProgressTracking.isTileRenderingRequired(x, y, zoom)) continue;
                                System.out.println("File: tracked as rendered. Fixing this. ");
                                renderProgressTracking.trackRenderRequestIncomplete(x, y, zoom);
                                continue;
                            }
                            System.out.println("Error: out of index");
                        }
                    }
                }
                renderProgressTracking.stopTracking();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

