/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.renderer.buffer;

import de.wideportal.maprender.renderer.buffer.AbstractArrayBuffer;

public class FloatArrayBuffer
extends AbstractArrayBuffer {
    private static final long serialVersionUID = 487578588938412082L;
    protected float[][][] buffer;

    public FloatArrayBuffer(int xSize, int ySize, int zSize) {
        this.buffer = new float[ySize][xSize][zSize];
    }

    public float getValue(int x, int y, int z) {
        return this.buffer[y][x][z];
    }

    public void setValue(int x, int y, int z, float value) {
        this.buffer[y][x][z] = value;
    }

    public void setValues(int x, int y, float[] values) {
        this.buffer[y][x] = values;
    }

    public void addValue(int x, int y, int z, float value) {
        this.buffer[y][x][z] = this.buffer[y][x][z] + value;
    }

    public void releaseResources() {
        this.buffer = null;
    }

    @Override
    public int getXSize() {
        return this.buffer[0].length;
    }

    @Override
    public int getYSize() {
        return this.buffer.length;
    }

    @Override
    public int getZSize() {
        return this.buffer[0][0].length;
    }

    @Override
    public void logBuffer(int z, int xMin, int xMax, int yMin, int yMax) {
        System.out.println("################################################# logBuffer ");
        for (int y = yMin; y < yMax; ++y) {
            StringBuffer rowBuffy = new StringBuffer();
            for (int x = xMin; x < xMax; ++x) {
                float value = this.buffer[y][x][z];
                String roundedValue = String.format("%.5f", Float.valueOf(value));
                String lengthFilledValue = String.format("%1$10s", roundedValue);
                rowBuffy.append(lengthFilledValue);
                rowBuffy.append(", ");
            }
            System.out.println("######################### " + rowBuffy.toString());
        }
    }
}

