/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.renderer.blocking;

import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.geom.LineSequence;
import de.wideportal.maprender.renderer.blocking.AbstractBlockingItem;
import de.wideportal.maprender.renderer.blocking.RenderMarkerItem;
import de.wideportal.maprender.renderer.blocking.RenderShieldItem;
import de.wideportal.maprender.renderer.blocking.RenderSrtmTextItem;
import de.wideportal.maprender.renderer.blocking.RenderTextItem;
import de.wideportal.maprender.renderer.blocking.RenderTextLineItem;
import java.util.ArrayList;

public class RenderOverlapManager {
    private ArrayList<RenderTextLineItem> renderedTextLineItems = new ArrayList();
    private ArrayList<RenderTextItem> renderedTextItems = new ArrayList();
    private ArrayList<RenderMarkerItem> renderedMarkerItems = new ArrayList();
    private ArrayList<RenderShieldItem> renderedShieldItems = new ArrayList();
    private ArrayList<RenderSrtmTextItem> renderedSrtmTextItems = new ArrayList();

    public ArrayList<RenderTextItem> getRenderedTextItems() {
        return this.renderedTextItems;
    }

    public ArrayList<AbstractBlockingItem> getOverlappingTexts(AbstractBlockingItem blockingItem) {
        return this.getOverlappingTexts(blockingItem, 0.0);
    }

    public boolean hasOverlappingSrtmTextItems(RenderSrtmTextItem blockingItem, double textLineSpacing) {
        ArrayList<AbstractBlockingItem> overlappingSrtmTextItems = this.getOverlappingSrtmTextItems(blockingItem, textLineSpacing);
        return overlappingSrtmTextItems.size() > 0;
    }

    public ArrayList<AbstractBlockingItem> getOverlappingSrtmTextItems(RenderSrtmTextItem blockingItem, double textLineSpacing) {
        ArrayList<AbstractBlockingItem> result = new ArrayList<AbstractBlockingItem>();
        for (RenderSrtmTextItem item : this.renderedSrtmTextItems) {
            if (textLineSpacing > 0.0 && blockingItem.getDistance(item) < textLineSpacing) {
                result.add(item);
                continue;
            }
            if (!blockingItem.intersects(item)) continue;
            result.add(item);
        }
        return result;
    }

    public boolean hasOverlappingTextLineItemsWithSameName(RenderTextLineItem blockingItem, double textLineSpacing) {
        ArrayList<AbstractBlockingItem> overlappingTextLineItems = this.getOverlappingTextLineItemsWithSameName(blockingItem, textLineSpacing);
        return overlappingTextLineItems.size() > 0;
    }

    public ArrayList<AbstractBlockingItem> getOverlappingTextLineItemsWithSameName(RenderTextLineItem blockingItem, double textLineSpacing) {
        ArrayList<AbstractBlockingItem> result = new ArrayList<AbstractBlockingItem>();
        for (RenderTextLineItem item : this.renderedTextLineItems) {
            String blockingItemText = blockingItem.getText().getParsedText();
            String itemText = item.getText().getParsedText();
            if (textLineSpacing > 0.0 && blockingItemText != null && blockingItemText.equals(itemText) && blockingItem.getDistance(item) < textLineSpacing) {
                result.add(item);
                continue;
            }
            if (!blockingItem.intersects(item)) continue;
            result.add(item);
        }
        return result;
    }

    public ArrayList<AbstractBlockingItem> getOverlappingTexts(AbstractBlockingItem blockingItem, double spacingDistance) {
        ArrayList<AbstractBlockingItem> result = new ArrayList<AbstractBlockingItem>();
        for (AbstractBlockingItem abstractBlockingItem : this.renderedTextItems) {
            if (spacingDistance > 0.0 && blockingItem.getDistance(abstractBlockingItem) < spacingDistance) {
                result.add(abstractBlockingItem);
                continue;
            }
            if (!blockingItem.intersects(abstractBlockingItem)) continue;
            result.add(abstractBlockingItem);
        }
        return result;
    }

    public void addRenderTextLineItem(RenderTextLineItem renderTextLineItem) {
        this.renderedTextLineItems.add(renderTextLineItem);
    }

    public void addRenderSrtmTextItem(RenderSrtmTextItem renderSrtmTextItem) {
        this.renderedSrtmTextItems.add(renderSrtmTextItem);
    }

    public ArrayList<RenderTextLineItem> getRenderedTextLineItems() {
        return this.renderedTextLineItems;
    }

    public ArrayList<AbstractBlockingItem> getOverlappingBlockingItems(AbstractBlockingItem blockingItem) {
        ArrayList<AbstractBlockingItem> result = new ArrayList<AbstractBlockingItem>();
        result.addAll(this.getOverlappingMarkers(blockingItem));
        result.addAll(this.getOverlappingShields(blockingItem));
        result.addAll(this.getOverlappingTextLines(blockingItem));
        result.addAll(this.getOverlappingTexts(blockingItem));
        return result;
    }

    public ArrayList<AbstractBlockingItem> getOverlappingBlockingItems(AbstractBlockingItem blockingItem, double spacingDistance, LineSequence lineSequence) {
        ArrayList<AbstractBlockingItem> result = new ArrayList<AbstractBlockingItem>();
        result.addAll(this.getOverlappingMarkers(blockingItem, spacingDistance, lineSequence));
        result.addAll(this.getOverlappingShields(blockingItem));
        result.addAll(this.getOverlappingTextLines(blockingItem, spacingDistance));
        result.addAll(this.getOverlappingTexts(blockingItem, spacingDistance));
        return result;
    }

    public ArrayList<AbstractBlockingItem> getOverlappingTextLines(AbstractBlockingItem blockingItem) {
        return this.getOverlappingTextLines(blockingItem, 0.0);
    }

    public ArrayList<AbstractBlockingItem> getOverlappingTextLines(AbstractBlockingItem blockingItem, double spacingDistance) {
        ArrayList<AbstractBlockingItem> result = new ArrayList<AbstractBlockingItem>();
        for (RenderTextLineItem item : this.renderedTextLineItems) {
            if (spacingDistance > 0.0 && blockingItem.getDistance(item) < spacingDistance) {
                result.add(item);
                continue;
            }
            if (!blockingItem.intersects(item)) continue;
            result.add(item);
        }
        return result;
    }

    public void addRenderTextItem(RenderTextItem renderTextItem) {
        this.renderedTextItems.add(renderTextItem);
    }

    public ArrayList<RenderMarkerItem> getRenderedMarkerItems() {
        return this.renderedMarkerItems;
    }

    public ArrayList<AbstractBlockingItem> getOverlappingMarkers(AbstractBlockingItem blockingItem) {
        return this.getOverlappingMarkers(blockingItem, 0.0, null);
    }

    public ArrayList<AbstractBlockingItem> getOverlappingMarkers(AbstractBlockingItem blockingItem, double spacingDistance, LineSequence lineSequence) {
        ArrayList<AbstractBlockingItem> result = new ArrayList<AbstractBlockingItem>();
        for (RenderMarkerItem item : this.renderedMarkerItems) {
            String blockingItemText = blockingItem.getText().getParsedText();
            String itemText = item.getText().getParsedText();
            if (spacingDistance > 0.0 && blockingItemText != null && blockingItemText.equals(itemText)) {
                if (lineSequence != null) {
                    if (item.getLineOfMarker() != null && lineSequence.connected(item.getLineOfMarker()) && blockingItem.getDistance(item) < spacingDistance) {
                        result.add(item);
                        continue;
                    }
                    if (blockingItem.getDistance(item) < 30.0) {
                        result.add(item);
                        continue;
                    }
                } else if (blockingItem.getDistance(item) < spacingDistance) {
                    result.add(item);
                    continue;
                }
            }
            if (!blockingItem.intersects(item)) continue;
            result.add(item);
        }
        return result;
    }

    public void addRenderMarkerItem(RenderMarkerItem renderMarkerItem) {
        this.renderedMarkerItems.add(renderMarkerItem);
    }

    public void addAllItems(RenderOverlapManager other) {
        this.renderedMarkerItems.addAll(other.getRenderedMarkerItems());
        this.renderedTextItems.addAll(other.getRenderedTextItems());
        this.renderedShieldItems.addAll(other.getRenderedShieldItems());
        this.renderedTextLineItems.addAll(other.getRenderedTextLineItems());
    }

    public ArrayList<RenderShieldItem> getRenderedShieldItems() {
        return this.renderedShieldItems;
    }

    public ArrayList<AbstractBlockingItem> getOverlappingShields(AbstractBlockingItem blockingItem) {
        return this.getOverlappingShields(blockingItem, 0.0, 0.0);
    }

    public ArrayList<AbstractBlockingItem> getOverlappingShields(AbstractBlockingItem blockingItem, double spacingDistance, double shieldMargin) {
        ArrayList<AbstractBlockingItem> result = new ArrayList<AbstractBlockingItem>();
        for (RenderShieldItem item : this.renderedShieldItems) {
            if (blockingItem.intersects(item)) {
                result.add(item);
                continue;
            }
            if (shieldMargin > 0.0 && blockingItem.getBounds().getDistance(item.getBounds()) < shieldMargin) {
                result.add(item);
                continue;
            }
            String blockingItemText = blockingItem.getText().getParsedText();
            String itemText = item.getText().getParsedText();
            if (!(spacingDistance > 0.0) || blockingItemText == null || !blockingItemText.equals(itemText) || !(blockingItem.getDistance(item) < spacingDistance)) continue;
            result.add(item);
        }
        return result;
    }

    public void addRenderShieldItem(RenderShieldItem renderShieldItem) {
        this.renderedShieldItems.add(renderShieldItem);
    }

    public boolean isInTile(AbstractBlockingItem blockingItem, BoundingBox tileBBox) {
        BoundingBox blockingBBox = blockingItem.getBounds().clone();
        blockingBBox.increaseBBox(5.0);
        return tileBBox.contains(blockingBBox);
    }

    public boolean hasOverlappingItems(AbstractBlockingItem blockingItem, boolean checkTextLines, boolean checkTexts, boolean checkMarkers, boolean checkShields) {
        return this.hasOverlappingItems(blockingItem, checkTextLines, checkTexts, checkMarkers, checkShields, 0.0, 0.0, 0.0, 0.0, null);
    }

    public boolean hasOverlappingItemsMarkerSpacing(AbstractBlockingItem blockingItem, boolean checkTextLines, boolean checkTexts, boolean checkMarkers, boolean checkShields, double markerSpacing, LineSequence lineSequence) {
        return this.hasOverlappingItems(blockingItem, checkTextLines, checkTexts, checkMarkers, checkShields, 0.0, 0.0, 0.0, markerSpacing, lineSequence);
    }

    public boolean hasOverlappingItemsTextLineSpacing(AbstractBlockingItem blockingItem, boolean checkTextLines, boolean checkTexts, boolean checkMarkers, boolean checkShields, double textLineSpacing) {
        return this.hasOverlappingItems(blockingItem, checkTextLines, checkTexts, checkMarkers, checkShields, 0.0, 0.0, textLineSpacing, 0.0, null);
    }

    public boolean hasOverlappingItemsShieldSpacing(AbstractBlockingItem blockingItem, boolean checkTextLines, boolean checkTexts, boolean checkMarkers, boolean checkShields, double shieldSpacingDistance, double shieldMargin, String shieldContent) {
        return this.hasOverlappingItems(blockingItem, checkTextLines, checkTexts, checkMarkers, checkShields, shieldSpacingDistance, shieldMargin, 0.0, 0.0, null);
    }

    public boolean hasOverlappingItems(AbstractBlockingItem blockingItem, boolean checkTextLines, boolean checkTexts, boolean checkMarkers, boolean checkShields, double shieldSpacingDistance, double shieldMargin, double textLineSpacing, double markerSpacing, LineSequence lineSequence) {
        ArrayList<AbstractBlockingItem> overlappingShields;
        ArrayList<AbstractBlockingItem> overlappingTexts;
        ArrayList<AbstractBlockingItem> overlappingTextLines;
        ArrayList<AbstractBlockingItem> overlappingMarkers;
        if (checkMarkers && (overlappingMarkers = this.getOverlappingMarkers(blockingItem, markerSpacing, lineSequence)).size() > 0) {
            return true;
        }
        if (checkTextLines && (overlappingTextLines = this.getOverlappingTextLines(blockingItem, textLineSpacing)).size() > 0) {
            return true;
        }
        if (checkTexts && (overlappingTexts = this.getOverlappingTexts(blockingItem, shieldMargin)).size() > 0) {
            return true;
        }
        return checkShields && (overlappingShields = this.getOverlappingShields(blockingItem, shieldSpacingDistance, shieldMargin)).size() > 0;
    }
}

