/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.renderer;

import de.wideportal.maprender.config.xml.osm.accessor.IOsmTextAccessor;
import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.renderer.OsmTextPointRenderHints;
import de.wideportal.maprender.renderer.blocking.RenderMarkerItem;
import de.wideportal.maprender.renderer.blocking.RenderOverlapManager;
import de.wideportal.maprender.renderer.blocking.RenderShieldItem;
import de.wideportal.maprender.renderer.text.TextRowContainer;
import de.wideportal.maprender.request.RenderRequest;
import de.wideportal.maprender.resources.fonts.FontContext;
import de.wideportal.maprender.resources.fonts.FontsUtil;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Optional;

public class OsmTextBoxLayouter {
    private RenderRequest renderRequest;
    private IOsmTextAccessor genericTextAccessor;
    private Graphics canvas;
    private double zoom;
    private BoundingBox foundBoundingBox = null;
    private TextRowContainer textRowContainer = null;
    private OsmTextPointRenderHints foundTextPointRenderingHints = null;
    private RenderShieldItem foundRenderShieldItem = null;
    private FontContext fontContext = null;

    public void init(RenderRequest renderRequest, IOsmTextAccessor genericTextAccessor, Graphics2D canvas, double zoom) {
        this.renderRequest = renderRequest;
        this.genericTextAccessor = genericTextAccessor;
        this.canvas = canvas;
        this.zoom = zoom;
        this.fontContext = new FontContext(renderRequest, genericTextAccessor);
    }

    public boolean calculateBestFittingPosition(String textValue, Point xyTilePixel, double pixelSpacing, double pixelMargin, Optional<String> optionalPlacements, BoundingBox symbolBBox, int minimumLineLength, boolean isForbidBorderPlacement, BoundingBox tileBBox) {
        boolean tryPlacements;
        String[] placements = this.getPlacements(optionalPlacements);
        boolean bl = tryPlacements = placements != null && placements.length > 0;
        if (tryPlacements) {
            return this.calculateBestFittingPositionCompass(textValue, xyTilePixel, pixelSpacing, pixelMargin, placements, symbolBBox, minimumLineLength, isForbidBorderPlacement, tileBBox);
        }
        return this.calculateBestFittingPositionSimple(textValue, xyTilePixel, pixelSpacing, pixelMargin, minimumLineLength, isForbidBorderPlacement, tileBBox);
    }

    public boolean calculateBestFittingPosition(String textValue, Point xyTilePixel, double pixelSpacing, double pixelMargin, Optional<String> optionalPlacements, int minimumLineLength, boolean isForbidBorderPlacement, BoundingBox tileBBox) {
        return this.calculateBestFittingPosition(textValue, xyTilePixel, pixelSpacing, pixelMargin, optionalPlacements, null, minimumLineLength, isForbidBorderPlacement, tileBBox);
    }

    private boolean calculateBestFittingPositionCompass(String textValue, Point xyTilePixel, double pixelSpacing, double pixelMargin, String[] placements, BoundingBox symbolBBox, int minimumLineLength, boolean isForbidBorderPlacement, BoundingBox tileBBox) {
        double initialFontSize;
        Graphics dummyCanvas = this.canvas.create();
        RenderOverlapManager allOverlapManager = this.renderRequest.getRenderOverlapManager();
        TextRowContainer dummyContainer = TextRowContainer.createDummy(this.genericTextAccessor.toString());
        RenderMarkerItem tempMarkerItem = new RenderMarkerItem(symbolBBox, xyTilePixel, this.zoom, this.renderRequest.getTileIndex(), this.genericTextAccessor.toString(), dummyContainer);
        if (allOverlapManager.hasOverlappingItems(tempMarkerItem, true, true, true, true)) {
            return false;
        }
        if (isForbidBorderPlacement && !allOverlapManager.isInTile(tempMarkerItem, tileBBox)) {
            return false;
        }
        for (double currentFontSize = initialFontSize = this.genericTextAccessor.getSize().doubleValue(); currentFontSize > 5.0; currentFontSize -= 1.0) {
            FontContext fontsizeAdjustedFontContext = new FontContext(this.fontContext, currentFontSize);
            Font font = FontsUtil.getBestFittingFont(fontsizeAdjustedFontContext, textValue);
            dummyCanvas.setFont(font);
            for (int compassIndex = 0; compassIndex < placements.length; ++compassIndex) {
                String currentCompass = placements[compassIndex];
                this.foundTextPointRenderingHints = new OsmTextPointRenderHints(this.genericTextAccessor);
                this.textRowContainer = TextRowContainer.parse(textValue, this.genericTextAccessor, fontsizeAdjustedFontContext, dummyCanvas, minimumLineLength);
                this.foundBoundingBox = this.foundTextPointRenderingHints.getTextBoundingBox(xyTilePixel, this.textRowContainer, currentCompass, symbolBBox, fontsizeAdjustedFontContext, dummyCanvas);
                this.foundRenderShieldItem = new RenderShieldItem(this.foundBoundingBox, xyTilePixel, this.zoom, this.renderRequest.getTileIndex(), this.genericTextAccessor.toString(), this.textRowContainer);
                this.fontContext = fontsizeAdjustedFontContext;
                if (allOverlapManager.hasOverlappingItemsShieldSpacing(this.foundRenderShieldItem, true, true, true, true, pixelSpacing, pixelMargin, textValue)) continue;
                dummyCanvas.dispose();
                return true;
            }
        }
        dummyCanvas.dispose();
        return false;
    }

    private boolean calculateBestFittingPositionSimple(String textValue, Point xyTilePixel, double pixelSpacing, double pixelMargin, int minimumLineLength, boolean isForbidBorderPlacement, BoundingBox tileBBox) {
        Graphics dummyCanvas = this.canvas.create();
        this.foundTextPointRenderingHints = new OsmTextPointRenderHints(this.genericTextAccessor);
        this.textRowContainer = TextRowContainer.parse(textValue, this.genericTextAccessor, this.fontContext, dummyCanvas, minimumLineLength);
        this.foundBoundingBox = this.foundTextPointRenderingHints.getTextBoundingBox(xyTilePixel, this.textRowContainer, null, this.fontContext, dummyCanvas);
        this.foundRenderShieldItem = new RenderShieldItem(this.foundBoundingBox, xyTilePixel, this.zoom, this.renderRequest.getTileIndex(), this.genericTextAccessor.toString(), this.textRowContainer);
        RenderOverlapManager allOverlapManager = this.renderRequest.getRenderOverlapManager();
        if (allOverlapManager.hasOverlappingItemsShieldSpacing(this.foundRenderShieldItem, true, true, true, true, pixelSpacing, pixelMargin, textValue)) {
            dummyCanvas.dispose();
            return false;
        }
        if (isForbidBorderPlacement && !allOverlapManager.isInTile(this.foundRenderShieldItem, tileBBox)) {
            return false;
        }
        dummyCanvas.dispose();
        return true;
    }

    public String[] getPlacements(Optional<String> placements) {
        if (placements.isPresent()) {
            String[] parts = placements.get().split(",");
            for (int i = 0; i < parts.length; ++i) {
                parts[i] = parts[i].trim();
            }
            return parts;
        }
        return null;
    }

    public BoundingBox getFoundBoundingBox() {
        return this.foundBoundingBox;
    }

    public OsmTextPointRenderHints getFoundTextPointRenderingHints() {
        return this.foundTextPointRenderingHints;
    }

    public TextRowContainer getTextRowContainer() {
        return this.textRowContainer;
    }

    public RenderShieldItem getFoundRenderShieldItem() {
        return this.foundRenderShieldItem;
    }

    public FontContext getFontContext() {
        return this.fontContext;
    }
}

