/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.renderer;

import de.wideportal.maprender.config.xml.osm.accessor.OsmLayerAccessor;
import de.wideportal.maprender.config.xml.osm.accessor.OsmPolygonPatternSymbolizerAccessor;
import de.wideportal.maprender.config.xml.osm.accessor.OsmRuleAccessor;
import de.wideportal.maprender.datasource.osm.PostgresPolygon;
import de.wideportal.maprender.datasource.osm.PostgresPolygonElement;
import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.math.GeoCalculator;
import de.wideportal.maprender.renderer.AbstractSymbolizerRenderer;
import de.wideportal.maprender.request.RenderImageLayer;
import de.wideportal.maprender.request.RenderRequest;
import de.wideportal.maprender.resources.output.format.AbstractMapTileOutput;
import de.wideportal.maprender.resources.symbols.SymbolsCache;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsmPolygonPatternSymbolizerRenderer
extends AbstractSymbolizerRenderer {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public void renderPolygonPatternSymbolizer(OsmPolygonPatternSymbolizerAccessor polygonPatternSymbolizer, RenderImageLayer renderLayer, PostgresPolygon latLonPolygon, double xOffset, double yOffset, double zoom, AbstractMapTileOutput tileOutputter, GeoCalculator geoCalculator, SymbolsCache symbolsCache, OsmRuleAccessor rule, RenderRequest renderRequest, OsmLayerAccessor layer) {
        Graphics2D canvas = renderLayer.getCanvas();
        float opacity = polygonPatternSymbolizer.getOpacity().floatValue();
        AlphaComposite renderOpacity = AlphaComposite.getInstance(3, opacity);
        canvas.setComposite(renderOpacity);
        Optional<String> optionalFile = polygonPatternSymbolizer.getFile();
        if (!optionalFile.isPresent()) {
            this.log.error("renderPolygonPatternSymbolizer: no symbol file given");
            throw new RuntimeException("renderPolygonPatternSymbolizer: no symbol file was given. This is most likely a misconfiguration.");
        }
        BufferedImage symbol = symbolsCache.getSymbol(optionalFile.get());
        if (symbol == null) {
            this.log.error("renderPolygonPatternSymbolizer: no symbol file available: " + optionalFile + ". Skip rendering of tile.");
            throw new RuntimeException("renderPolygonPatternSymbolizer: no symbol file available: " + optionalFile + ". Skip rendering of tile.");
        }
        TexturePaint texture = new TexturePaint(symbol, new Rectangle(0, 0, symbol.getWidth(), symbol.getHeight()));
        canvas.setPaint(texture);
        Polygon rootPolygon = this.getPolygonForMercatorElement(geoCalculator, tileOutputter, latLonPolygon.getPolygonElements()[0], zoom, xOffset, yOffset);
        Area polygonArea = new Area(rootPolygon);
        BoundingBox clipBBox = renderRequest.getBoundingBoxPixel().clone();
        clipBBox.increaseBBox(clipBBox.getWidth());
        polygonArea = this.clipAreaToBBox(polygonArea, clipBBox);
        for (int i = 1; i < latLonPolygon.getPolygonElements().length; ++i) {
            Polygon subPolygon = this.getPolygonForMercatorElement(geoCalculator, tileOutputter, latLonPolygon.getPolygonElements()[i], zoom, xOffset, yOffset);
            Area subPolygonArea = new Area(subPolygon);
            polygonArea.subtract(subPolygonArea);
        }
        canvas.fill(polygonArea);
    }

    private Polygon getPolygonForMercatorElement(GeoCalculator geoCalculator, AbstractMapTileOutput tileOutputter, PostgresPolygonElement mercatorPolygonElement, double zoom, double xOffset, double yOffset) {
        Point[] xyTilePoints = this.convertMercatorLineStringToTilePoints(mercatorPolygonElement.getPoints(), xOffset, yOffset, zoom, tileOutputter, geoCalculator);
        int[][] xyValues = PostgresPolygonElement.getPointsAsIntArray(xyTilePoints);
        Polygon polygon = new Polygon(xyValues[0], xyValues[1], xyValues[0].length);
        return polygon;
    }

    private Area clipAreaToBBox(Area area, BoundingBox pixelBBox) {
        Rectangle pixelBBoxRect = pixelBBox.getRectangle();
        Area bboxArea = new Area(pixelBBoxRect);
        area.intersect(bboxArea);
        return area;
    }
}

