/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.renderer;

import de.wideportal.maprender.config.xml.osm.OsmTextSymbolizer;
import de.wideportal.maprender.config.xml.osm.accessor.OsmHeightLinesSymbolizerAccessor;
import de.wideportal.maprender.config.xml.osm.accessor.OsmRuleAccessor;
import de.wideportal.maprender.config.xml.osm.compop.OsmStyleImageCompOpCutOutOpacity;
import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.geom.Line;
import de.wideportal.maprender.geom.LineFilterSkipPoints;
import de.wideportal.maprender.geom.LineSequence;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.math.GeoCalculator;
import de.wideportal.maprender.math.LineSmoother;
import de.wideportal.maprender.renderer.AbstractSymbolizerRenderer;
import de.wideportal.maprender.renderer.OsmTextSymbolizerRenderer;
import de.wideportal.maprender.renderer.buffer.BooleanArrayBuffer;
import de.wideportal.maprender.request.RenderImageLayer;
import de.wideportal.maprender.request.RenderRequest;
import de.wideportal.maprender.resources.height.HeightCollectorTile;
import de.wideportal.maprender.resources.height.HeightTileAccessor;
import de.wideportal.maprender.resources.output.format.AbstractMapTileOutput;
import de.wideportal.maprender.resources.srtm.SrtmLineHeightContainer;
import de.wideportal.maprender.resources.srtm.SrtmLinePointsContainer;
import de.wideportal.maprender.resources.srtm.algos.PointGroupDeadendRemoverAlgo;
import de.wideportal.maprender.resources.srtm.algos.PointGroupFinderAlgo;
import de.wideportal.maprender.resources.srtm.algos.PointGroupHullFinderAlgo;
import de.wideportal.maprender.resources.srtm.algos.PointGroupRemoveUnneccessaryPointsAlgo;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsmHeightLinesSymbolizerRenderer
extends AbstractSymbolizerRenderer {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public void renderHeight(RenderRequest renderRequest, OsmHeightLinesSymbolizerAccessor heightLinesSymbolizer, RenderImageLayer renderLayer, double xOffset, double yOffset, double zoom, AbstractMapTileOutput tileOutputter, GeoCalculator geoCalculator, OsmRuleAccessor rule) {
        BoundingBox latLonBoundingBox;
        int yTileIndex;
        Color color = heightLinesSymbolizer.getColor();
        double heightMin = heightLinesSymbolizer.getHeightMin();
        double heightMax = heightLinesSymbolizer.getHeightMax();
        boolean renderMockTiles = heightLinesSymbolizer.getRenderMockTiles();
        int flattenNoise = heightLinesSymbolizer.getFlattenNoise();
        int flattenPointNoise = heightLinesSymbolizer.getFlattenPointNoise();
        int linesSpacing = heightLinesSymbolizer.getLinesSpacing();
        int linesMajor = heightLinesSymbolizer.getLinesMajor();
        float linesWidth = heightLinesSymbolizer.getLinesWidth().floatValue();
        float linesWidthMajor = heightLinesSymbolizer.getLinesWidthMajor().floatValue();
        int expensiveBlur = heightLinesSymbolizer.getExpensiveBlur();
        Optional<Double> simplifyDistanceTolerance = heightLinesSymbolizer.getSimplifyDistanceTolerance();
        Optional<Integer> splinePointsPerSegment = heightLinesSymbolizer.getSplinePointsPerSegment();
        boolean renderText = heightLinesSymbolizer.getRenderText();
        ArrayList<Float> skipHeights = this.parseSkipHeights(heightLinesSymbolizer.getSkipHeights());
        int deleteSmallCyclicLines = heightLinesSymbolizer.getDeleteSmallCyclicLines();
        String textColor = heightLinesSymbolizer.getOsmHeightLinesSymbolizer().getColor();
        String textFont = heightLinesSymbolizer.getFontsetName().orElse(null);
        String textHaloColor = heightLinesSymbolizer.getOsmHeightLinesSymbolizer().getHaloFill();
        String textHaloRadius = heightLinesSymbolizer.getOsmHeightLinesSymbolizer().getHaloRadius();
        String textRepeatDistance = heightLinesSymbolizer.getOsmHeightLinesSymbolizer().getRepeatDistance();
        String textSpacing = heightLinesSymbolizer.getOsmHeightLinesSymbolizer().getSpacing();
        String textSize = heightLinesSymbolizer.getOsmHeightLinesSymbolizer().getSize();
        HeightTileAccessor heightTileAccessor = renderRequest.getHeightTileAccessor();
        OsmTextSymbolizerRenderer textSymbolizerRenderer = new OsmTextSymbolizerRenderer();
        int xTileIndex = (int)renderRequest.getTileIndex().getX();
        HeightCollectorTile heightCollectorTile = heightTileAccessor.collectValues((int)zoom, xTileIndex, yTileIndex = (int)renderRequest.getTileIndex().getY(), latLonBoundingBox = renderRequest.getBoundingBoxLatLon(), renderRequest, tileOutputter.getTileSize(), renderMockTiles, flattenNoise, flattenPointNoise, tileOutputter);
        if (heightCollectorTile == null) {
            this.log.error("renderHeightLines: could not render lines because the srtmCollectorTile was null");
            return;
        }
        long tileSize = heightCollectorTile.getPixelTileSize();
        if (expensiveBlur > 0) {
            heightCollectorTile.blur(expensiveBlur);
        }
        RenderImageLayer srtmLayer = renderRequest.getRenderImage().createLayer("srtm", tileOutputter.getTileSize());
        Graphics2D srtmCanvas = srtmLayer.getCanvas();
        srtmCanvas.setColor(color);
        float[] lineColor = new float[]{color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()};
        this.removePlateaus(heightCollectorTile, heightMin, heightMax, linesSpacing, skipHeights);
        int heightSteps = (int)Math.floor((heightMax - heightMin) / (double)linesSpacing);
        BooleanArrayBuffer cellOnLineBuffer = this.createCellOnLineBuffer(heightCollectorTile, heightMin, heightMax, linesSpacing, skipHeights, heightSteps);
        ArrayList<SrtmLineHeightContainer> heightLineContainers = new ArrayList<SrtmLineHeightContainer>();
        ArrayList<SrtmLinePointsContainer> linePointsContainers = new ArrayList<SrtmLinePointsContainer>();
        for (int z = 0; z < cellOnLineBuffer.getZSize(); ++z) {
            int height = (int)(heightMin + (double)(z * linesSpacing));
            if ((float)height < heightCollectorTile.getMinValue() || (float)height > heightCollectorTile.getMaxValue()) continue;
            boolean skipThisHeight = false;
            for (Float skipHeight : skipHeights) {
                if (skipHeight.floatValue() != (float)height) continue;
                skipThisHeight = true;
                break;
            }
            if (skipThisHeight) continue;
            SrtmLinePointsContainer linePointsContainer = new SrtmLinePointsContainer(height, tileSize);
            linePointsContainer.addPoints(cellOnLineBuffer, z);
            PointGroupFinderAlgo.groupTouchingPoints(linePointsContainer);
            PointGroupRemoveUnneccessaryPointsAlgo.removeUnneccessaryPoints(cellOnLineBuffer, linePointsContainer, z);
            PointGroupDeadendRemoverAlgo.removeDeadendLines(cellOnLineBuffer, linePointsContainer, z, tileSize);
            PointGroupHullFinderAlgo.removeHullContents(cellOnLineBuffer, linePointsContainer, z, tileSize);
            linePointsContainers.add(linePointsContainer);
            SrtmLineHeightContainer heightLineContainer = linePointsContainer.buildLineSequenceFromPoints(height, z);
            if (simplifyDistanceTolerance.isPresent() && splinePointsPerSegment.isPresent()) {
                LineSmoother lineSmoother = new LineSmoother();
                lineSmoother.simplifyDouglasPeuckerThenSplineCatmullRom(heightLineContainer, simplifyDistanceTolerance.get(), splinePointsPerSegment.get(), tileSize);
            }
            heightLineContainer.removeSmallLines(5, tileSize);
            heightLineContainer.removeSmallCyclicLines(deleteSmallCyclicLines);
            float currentLineWidth = linesWidth;
            boolean isMajorLine = false;
            if (z % linesMajor == 0) {
                isMajorLine = true;
                currentLineWidth = linesWidthMajor;
            }
            BasicStroke baseStroke = this.getBasicStroke(currentLineWidth);
            srtmCanvas.setStroke(baseStroke);
            heightLineContainers.add(heightLineContainer);
            OsmStyleImageCompOpCutOutOpacity compOpCutOutOpacity = new OsmStyleImageCompOpCutOutOpacity("");
            RenderImageLayer srtmTextLayer = renderRequest.getRenderImage().createLayer("srtmText", tileOutputter.getTileSize());
            for (LineSequence lineSequence : heightLineContainer.getHeightLines()) {
                if (lineSequence.getLines().size() <= 0) continue;
                LineSequence thinnedLineSequence = lineSequence;
                for (Line line : thinnedLineSequence.getLines()) {
                    srtmCanvas.drawLine((int)line.getStart().getX(), (int)line.getStart().getY(), (int)line.getStop().getX(), (int)line.getStop().getY());
                }
                if (!isMajorLine || !renderText) continue;
                OsmTextSymbolizer osmTextSymbolizer = new OsmTextSymbolizer();
                osmTextSymbolizer.setIdentifier("OsmHeightSymbolizer");
                osmTextSymbolizer.setParent(rule.getOsmRule());
                osmTextSymbolizer.setFill(textColor);
                osmTextSymbolizer.setFontsetName(textFont);
                osmTextSymbolizer.setHaloFill(textHaloColor);
                osmTextSymbolizer.setHaloRadius(textHaloRadius);
                osmTextSymbolizer.setRepeatDistance(textRepeatDistance);
                osmTextSymbolizer.setSpacing(textSpacing);
                osmTextSymbolizer.setSize(textSize);
                osmTextSymbolizer.setValue("" + height);
                LineFilterSkipPoints lineFilter = new LineFilterSkipPoints(4);
                Point[] unfilteredPoints = lineSequence.getPoints();
                Point[] filteredPoints = lineFilter.filter(unfilteredPoints);
                double maxSingleCharRotation = 5.0;
                boolean isHeightText = true;
                textSymbolizerRenderer.renderTextSymbolizer(osmTextSymbolizer.getAccessor(), srtmTextLayer, filteredPoints, xOffset, yOffset, zoom, tileOutputter, geoCalculator, null, renderRequest, rule, maxSingleCharRotation, isHeightText);
            }
            compOpCutOutOpacity.applyCompOp(srtmTextLayer, srtmLayer);
            renderRequest.getRenderImage().mergeBackLayer(srtmTextLayer);
        }
        renderRequest.getRenderImage().mergeBackLayer(srtmLayer);
    }

    private BooleanArrayBuffer createCellOnLineBuffer(HeightCollectorTile srtmCollectorTile, double heightMin, double heightMax, int linesSpacing, ArrayList<Float> skipHeights, int heightSteps) {
        BooleanArrayBuffer cellOnLineBuffer = new BooleanArrayBuffer(srtmCollectorTile.getPixelTileSize(), srtmCollectorTile.getPixelTileSize(), heightSteps);
        for (int y = 0; y < srtmCollectorTile.getPixelTileSize(); ++y) {
            for (int x = 0; x < srtmCollectorTile.getPixelTileSize(); ++x) {
                int heightStep = 0;
                float lineHeight = (int)heightMin;
                while ((double)lineHeight <= heightMax) {
                    if (lineHeight < srtmCollectorTile.getMinValue() || lineHeight > srtmCollectorTile.getMaxValue()) {
                        ++heightStep;
                    } else if (heightStep < heightSteps) {
                        boolean skipThisHeight = false;
                        for (Float skipHeight : skipHeights) {
                            if (skipHeight.floatValue() != lineHeight) continue;
                            skipThisHeight = true;
                            break;
                        }
                        if (!skipThisHeight) {
                            if (lineHeight == 0.0f) {
                                lineHeight += 0.001f;
                            }
                            float centerValue = srtmCollectorTile.getValue(x, y);
                            float leftValue = srtmCollectorTile.getValue(x - 1, y);
                            float leftTopValue = srtmCollectorTile.getValue(x - 1, y - 1);
                            float topValue = srtmCollectorTile.getValue(x, y - 1);
                            if (lineHeight > centerValue && lineHeight < leftValue) {
                                cellOnLineBuffer.setValue(x, y, heightStep, true);
                            } else if (lineHeight < centerValue && lineHeight > leftValue) {
                                cellOnLineBuffer.setValue(x, y, heightStep, true);
                            } else if (lineHeight > centerValue && lineHeight < leftTopValue) {
                                cellOnLineBuffer.setValue(x, y, heightStep, true);
                            } else if (lineHeight < centerValue && lineHeight > leftTopValue) {
                                cellOnLineBuffer.setValue(x, y, heightStep, true);
                            } else if (lineHeight > centerValue && lineHeight < topValue) {
                                cellOnLineBuffer.setValue(x, y, heightStep, true);
                            } else if (lineHeight < centerValue && lineHeight > topValue) {
                                cellOnLineBuffer.setValue(x, y, heightStep, true);
                            }
                            ++heightStep;
                        }
                    }
                    lineHeight += (float)linesSpacing;
                }
            }
        }
        return cellOnLineBuffer;
    }

    private void removePlateaus(HeightCollectorTile srtmCollectorTile, double heightMin, double heightMax, int linesSpacing, ArrayList<Float> skipHeights) {
        for (int y = 0; y < srtmCollectorTile.getBufferedTileSize(); ++y) {
            for (int x = 0; x < srtmCollectorTile.getBufferedTileSize(); ++x) {
                float lineHeight = (int)heightMin;
                while ((double)lineHeight <= heightMax) {
                    boolean skipThisHeight = false;
                    for (Float skipHeight : skipHeights) {
                        if (skipHeight.floatValue() != lineHeight) continue;
                        skipThisHeight = true;
                        break;
                    }
                    if (!(skipThisHeight || lineHeight < srtmCollectorTile.getMinValue() || lineHeight > srtmCollectorTile.getMaxValue())) {
                        float lineHeightDiff;
                        float centerValue = srtmCollectorTile.getValueFromBuffer(x, y);
                        if (centerValue >= -0.02f && centerValue <= 0.02f) {
                            srtmCollectorTile.setValueToBuffer(x, y, 0.0f);
                            centerValue = 0.0f;
                        }
                        if ((lineHeightDiff = centerValue - lineHeight) >= 0.0f && lineHeightDiff < 1.0E-4f) {
                            srtmCollectorTile.setValueToBuffer(x, y, lineHeight - 0.001f);
                        }
                    }
                    lineHeight += (float)linesSpacing;
                }
            }
        }
    }

    private float trimToBounds(float value, float min, float max) {
        if (value > max) {
            value = max;
        } else if (value < min) {
            value = min;
        }
        return value;
    }

    private BasicStroke getBasicStroke(float width) {
        int lineCap = 1;
        int lineJoin = 1;
        BasicStroke basicStroke = new BasicStroke(width, lineCap, lineJoin);
        return basicStroke;
    }

    private void printPointArray(int xMin, int xMax, int yMin, int yMax, SrtmLineHeightContainer linesContainer) {
        ArrayList<LineSequence> lines = linesContainer.getHeightLines();
        ArrayList<Point> linePoints = new ArrayList<Point>();
        for (LineSequence line : lines) {
            Point[] points = line.getPoints();
            linePoints.addAll(Arrays.stream(points).collect(Collectors.toList()));
        }
        this.printPointArray(xMin, xMax, yMin, yMax, linePoints);
    }

    private void printPointArray(int xMin, int xMax, int yMin, int yMax, ArrayList<Point> points) {
        System.out.println("################################################# logPoints ");
        for (int y = yMin; y < yMax; ++y) {
            StringBuffer rowBuffy = new StringBuffer();
            for (int x = xMin; x < xMax; ++x) {
                Point currentPoint = null;
                for (int i = 0; i < points.size(); ++i) {
                    if (points.get(i).getX() != (double)x || points.get(i).getY() != (double)y) continue;
                    currentPoint = points.get(i);
                    break;
                }
                String value = "-";
                if (currentPoint != null) {
                    value = "start".equals(currentPoint.getOptionalFlag()) ? "0" : ("stop".equals(currentPoint.getOptionalFlag()) ? "1" : "#");
                }
                String lengthFilledValue = String.format("%1$1s", value);
                rowBuffy.append(lengthFilledValue);
            }
            System.out.println("######################### " + rowBuffy.toString());
        }
    }

    private void printPointArray(int xMin, int xMax, int yMin, int yMax, ArrayList<Point> points, ArrayList<Integer> analysis) {
        System.out.println("################################################# logPoints ");
        int SAME_X = 1;
        int SAME_Y = 2;
        int BACKWARD = 3;
        int FORWARD = 4;
        for (int y = yMin; y < yMax; ++y) {
            StringBuffer rowBuffy = new StringBuffer();
            for (int x = xMin; x < xMax; ++x) {
                Point currentPoint = null;
                Integer currentAnalysis = null;
                for (int i = 0; i < points.size(); ++i) {
                    if (points.get(i).getX() != (double)x || points.get(i).getY() != (double)y) continue;
                    currentPoint = points.get(i);
                    currentAnalysis = analysis.get(i);
                    break;
                }
                String value = "-";
                if (currentPoint != null) {
                    if (currentAnalysis == SAME_X) {
                        value = "X";
                    } else if (currentAnalysis == SAME_Y) {
                        value = "Y";
                    } else if (currentAnalysis == BACKWARD) {
                        value = "<";
                    } else if (currentAnalysis == FORWARD) {
                        value = ">";
                    }
                }
                String lengthFilledValue = String.format("%1$1s", value);
                rowBuffy.append(lengthFilledValue);
            }
            System.out.println("######################### " + rowBuffy.toString());
        }
    }
}

