/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.renderer;

import de.wideportal.maprender.datasource.RenderResultSetCache;
import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.geom.Circle;
import de.wideportal.maprender.geom.Line;
import de.wideportal.maprender.geom.LineSequence;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.math.GeoCalculator;
import de.wideportal.maprender.renderer.CanvasStash;
import de.wideportal.maprender.renderer.blocking.AbstractBlockingItem;
import de.wideportal.maprender.renderer.blocking.RenderTextLineItem;
import de.wideportal.maprender.resources.output.format.AbstractMapTileOutput;
import de.wideportal.maprender.util.color.ColorUtil;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSymbolizerRenderer {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    public static final float[] COLOR_TRANSPARENT = new float[]{0.0f, 0.0f, 0.0f, 0.0f};

    protected void DEBUG_PAINT_RECTANGLE(Graphics2D canvas, Color color, BoundingBox bbox) {
        Rectangle rect = new Rectangle((int)bbox.getLeft(), (int)bbox.getTop(), (int)bbox.getWidth(), (int)bbox.getHeight());
        this.DEBUG_PAINT_RECTANGLE(canvas, color, rect);
    }

    protected void DEBUG_PAINT_RECTANGLE(Graphics2D canvas, Color color, Rectangle2D rect) {
        CanvasStash canvasStash = CanvasStash.saveCanvas(canvas);
        canvas.setColor(color);
        canvas.setStroke(new BasicStroke(1.0f, 1, 1));
        canvas.setComposite(AlphaComposite.getInstance(3, 1.0f));
        canvas.draw(rect);
        CanvasStash.restoreCanvas(canvas, canvasStash);
    }

    protected void DEBUG_PAINT_POINT(Graphics2D canvas, Color color, Point point) {
        CanvasStash canvasStash = CanvasStash.saveCanvas(canvas);
        canvas.setColor(color);
        canvas.setStroke(new BasicStroke(1.0f, 1, 1));
        canvas.setComposite(AlphaComposite.getInstance(3, 1.0f));
        canvas.drawLine((int)(point.getX() - 10.0), (int)(point.getY() - 10.0), (int)(point.getX() + 10.0), (int)(point.getY() + 10.0));
        canvas.drawLine((int)(point.getX() - 10.0), (int)(point.getY() + 10.0), (int)(point.getX() + 10.0), (int)(point.getY() - 10.0));
        CanvasStash.restoreCanvas(canvas, canvasStash);
    }

    protected void DEBUG_PAINT_POINT_LIST(Graphics2D canvas, Color color, ArrayList<Point> points) {
        Point point;
        int i;
        CanvasStash canvasStash = CanvasStash.saveCanvas(canvas);
        canvas.setColor(color);
        canvas.setStroke(new BasicStroke(1.0f, 1, 1));
        canvas.setComposite(AlphaComposite.getInstance(3, 1.0f));
        for (i = 0; i < points.size(); ++i) {
            point = points.get(i);
            canvas.drawLine((int)(point.getX() - 10.0), (int)(point.getY() - 10.0), (int)(point.getX() + 10.0), (int)(point.getY() + 10.0));
            canvas.drawLine((int)(point.getX() - 10.0), (int)(point.getY() + 10.0), (int)(point.getX() + 10.0), (int)(point.getY() - 10.0));
        }
        canvas.setColor(Color.WHITE);
        for (i = 0; i < points.size(); ++i) {
            point = points.get(i);
            canvas.fillOval((int)(point.getX() + 4.0), (int)(point.getY() - 6.0), 12, 12);
        }
        canvas.setColor(color);
        for (i = 0; i < points.size(); ++i) {
            point = points.get(i);
            canvas.drawString("" + i, (int)(point.getX() + 7.0), (int)(point.getY() + 3.0));
        }
        CanvasStash.restoreCanvas(canvas, canvasStash);
    }

    protected void DEBUG_PAINT_CROSS(Graphics2D canvas, Color color, Point point) {
        CanvasStash canvasStash = CanvasStash.saveCanvas(canvas);
        canvas.setColor(color);
        canvas.setStroke(new BasicStroke(1.0f, 1, 1));
        canvas.setComposite(AlphaComposite.getInstance(3, 1.0f));
        canvas.drawLine((int)(point.getX() - 10.0), (int)point.getY(), (int)(point.getX() + 10.0), (int)point.getY());
        canvas.drawLine((int)point.getX(), (int)(point.getY() + 10.0), (int)point.getX(), (int)(point.getY() - 10.0));
        CanvasStash.restoreCanvas(canvas, canvasStash);
    }

    protected void DEBUG_PAINT_LINE(Graphics2D canvas, Color color, Point start, Point stop) {
        CanvasStash canvasStash = CanvasStash.saveCanvas(canvas);
        canvas.setColor(color);
        canvas.setStroke(new BasicStroke(1.0f, 1, 1));
        canvas.setComposite(AlphaComposite.getInstance(3, 1.0f));
        canvas.drawLine((int)start.getX(), (int)start.getY(), (int)stop.getX(), (int)stop.getY());
        CanvasStash.restoreCanvas(canvas, canvasStash);
    }

    protected void DEBUG_PAINT_LINE_SEQUENCE(Graphics2D canvas, Color color, LineSequence lineSequence) {
        CanvasStash canvasStash = CanvasStash.saveCanvas(canvas);
        canvas.setColor(color);
        canvas.setStroke(new BasicStroke(1.0f, 1, 1));
        canvas.setComposite(AlphaComposite.getInstance(3, 1.0f));
        for (Line line : lineSequence.getLines()) {
            Point start = line.getStart();
            Point stop = line.getStop();
            canvas.drawLine((int)start.getX(), (int)start.getY(), (int)stop.getX(), (int)stop.getY());
        }
        CanvasStash.restoreCanvas(canvas, canvasStash);
    }

    protected void DEBUG_PAINT_CIRCLE(Graphics2D canvas, Color color, Circle circle) {
        CanvasStash canvasStash = CanvasStash.saveCanvas(canvas);
        canvas.setColor(color);
        canvas.setStroke(new BasicStroke(1.0f, 1, 1));
        canvas.setComposite(AlphaComposite.getInstance(3, 1.0f));
        canvas.drawOval((int)(circle.getCenter().getX() - circle.getRadius()), (int)(circle.getCenter().getY() - circle.getRadius()), (int)(circle.getRadius() * 2.0), (int)(circle.getRadius() * 2.0));
        CanvasStash.restoreCanvas(canvas, canvasStash);
    }

    protected void DEBUG_PAINT_BLOCKING_ITEM(Graphics2D canvas, Color color, AbstractBlockingItem blockingItem) {
        CanvasStash canvasStash = CanvasStash.saveCanvas(canvas);
        canvas.setColor(color);
        canvas.setStroke(new BasicStroke(1.0f, 1, 1));
        canvas.setComposite(AlphaComposite.getInstance(3, 1.0f));
        if (blockingItem instanceof RenderTextLineItem) {
            RenderTextLineItem blockingTextLine = (RenderTextLineItem)blockingItem;
            for (Circle circle : blockingTextLine.getBoundingCircles()) {
                canvas.drawOval((int)(circle.getCenter().getX() - circle.getRadius()), (int)(circle.getCenter().getY() - circle.getRadius()), (int)(circle.getRadius() * 2.0), (int)(circle.getRadius() * 2.0));
            }
        } else {
            for (BoundingBox box : blockingItem.getBoundingBoxes()) {
                Rectangle rectangle = box.getRectangle();
                canvas.draw(rectangle);
            }
        }
        CanvasStash.restoreCanvas(canvas, canvasStash);
    }

    protected Color extractColorFromCData(Optional<String> optionalCDataColor, Color directColor, RenderResultSetCache resultSetCache, Float strokeOpacity) {
        if (optionalCDataColor.isPresent() && resultSetCache != null) {
            String textValue = this.extractText(optionalCDataColor, resultSetCache);
            Color preColor = ColorUtil.getColorFromString(textValue);
            Color color = ColorUtil.getColor(preColor, strokeOpacity.floatValue());
            return color;
        }
        Color color = ColorUtil.getColor(directColor, strokeOpacity.floatValue());
        return color;
    }

    protected String extractText(Optional<String> optionalTextTableColumn, RenderResultSetCache resultSetCache) {
        if (!optionalTextTableColumn.isPresent()) {
            this.log.error("extractText: textSymbolizer did not provide a text identifier");
            return "";
        }
        String textTableColumn = optionalTextTableColumn.get();
        if (textTableColumn.startsWith("<![CDATA")) {
            textTableColumn = textTableColumn.substring(8);
            textTableColumn = textTableColumn.substring(0, textTableColumn.lastIndexOf("]") - 1);
        }
        ArrayList<String> columns = new ArrayList<String>();
        int indexOpeningBracked = 0;
        int indexClosingBracked = 0;
        for (int i = 0; i < textTableColumn.length(); ++i) {
            if (textTableColumn.charAt(i) == '[') {
                indexOpeningBracked = i;
                if (i > 0) {
                    columns.add(textTableColumn.substring(indexClosingBracked + 1, indexOpeningBracked));
                }
            }
            if (textTableColumn.charAt(i) == ']') {
                indexClosingBracked = i;
                columns.add(textTableColumn.substring(indexOpeningBracked, indexClosingBracked + 1));
            }
            if (i != textTableColumn.length() - 1 || indexClosingBracked == i) continue;
            if (indexClosingBracked == 0) {
                columns.add(textTableColumn.substring(indexClosingBracked, i + 1));
                continue;
            }
            columns.add(textTableColumn.substring(indexClosingBracked + 1, i + 1));
        }
        Object result = "";
        for (String column : columns) {
            if (column.startsWith("[") && column.endsWith("]")) {
                column = column.substring(1, column.length() - 1);
                try {
                    String textValue = resultSetCache.getString(column);
                    if (textValue == null) {
                        textValue = "";
                    }
                    result = (String)result + textValue;
                }
                catch (Exception e) {
                    this.log.error("extractText: could not get text: textTableColumn=" + textTableColumn, (Throwable)e);
                }
                continue;
            }
            column = column.replaceAll("\\+", "").trim();
            if ((column = column.replaceAll("\\\\n", "\n").trim()).length() > 0) {
                char stringIdentifier = '$';
                for (int i = 0; i < column.length(); ++i) {
                    if (column.charAt(i) != '\'' && column.charAt(i) != '\"') continue;
                    stringIdentifier = column.charAt(i);
                    break;
                }
                if (stringIdentifier != '$') {
                    column = column.replaceAll("" + stringIdentifier, "");
                }
            }
            result = (String)result + column;
        }
        return result;
    }

    protected Point[] convertLatLonLineStringToTilePoints(Point[] latLonPoints, double xOffset, double yOffset, double zoom, AbstractMapTileOutput tileOutputter) {
        Point[] xyTilePoints = new Point[latLonPoints.length];
        for (int i = 0; i < latLonPoints.length; ++i) {
            Point point = latLonPoints[i];
            Point xyPixel = tileOutputter.getLonLatToPixel(point.getX(), point.getY(), zoom);
            xyPixel.x -= xOffset;
            xyPixel.y -= yOffset;
            xyTilePoints[i] = xyPixel;
        }
        return xyTilePoints;
    }

    protected Point[] convertMercatorLineStringToTilePoints(Point[] mercatorPoints, double xOffset, double yOffset, double zoom, AbstractMapTileOutput tileOutputter, GeoCalculator geoCalculator) {
        Point[] xyTilePoints = new Point[mercatorPoints.length];
        for (int i = 0; i < mercatorPoints.length; ++i) {
            Point pointLatLon = geoCalculator.convertMercatorToLatLon(mercatorPoints[i]);
            Point xyPixel = tileOutputter.getLonLatToPixel(pointLatLon.getX(), pointLatLon.getY(), zoom);
            xyPixel.x -= xOffset;
            xyPixel.y -= yOffset;
            xyTilePoints[i] = xyPixel;
        }
        return xyTilePoints;
    }

    protected Optional<BasicStroke> getTextHaloStroke(float haloRadius) {
        if (haloRadius > 0.0f) {
            return Optional.of(new BasicStroke(haloRadius += 1.5f, 1, 1));
        }
        return Optional.empty();
    }

    protected BufferedImage getMaskedSymbol(BufferedImage symbol, Color mask) {
        return this.getMaskedSymbol(symbol, mask, false);
    }

    protected BufferedImage getMaskedSymbol(BufferedImage symbol, Color mask, boolean log) {
        int y;
        ColorModel cm = symbol.getColorModel();
        WritableRaster symbolRaster = symbol.copyData(null);
        BufferedImage result = new BufferedImage(cm, symbolRaster, false, null);
        WritableRaster raster = result.getRaster();
        WritableRaster symbolData = symbol.getRaster();
        int[] symbolPixel = new int[4];
        int width = symbol.getWidth();
        int height = symbol.getHeight();
        int[][][] rasterBefore = new int[height][width][4];
        int[][][] rasterAfter = new int[height][width][4];
        for (y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                symbolPixel = symbolData.getPixel(x, y, symbolPixel);
                if (log) {
                    rasterBefore[y][x] = symbolPixel;
                }
                int[] newSymbolPixel = new int[4];
                if (symbolPixel[0] == 0 && symbolPixel[1] == 0 && symbolPixel[2] == 0) {
                    newSymbolPixel[0] = mask.getRed();
                    newSymbolPixel[1] = mask.getGreen();
                    newSymbolPixel[2] = mask.getBlue();
                    newSymbolPixel[3] = symbolPixel[3];
                }
                raster.setPixel(x, y, newSymbolPixel);
                if (!log) continue;
                rasterAfter[y][x] = newSymbolPixel;
            }
        }
        result.setData(raster);
        if (log) {
            int[] pixel;
            System.out.println("########################################################################### before ");
            for (y = 0; y < height; ++y) {
                Object line = "";
                for (int x = 0; x < width; ++x) {
                    pixel = rasterBefore[y][x];
                    line = (String)line + "[" + pixel[0] + "," + pixel[1] + "," + pixel[2] + "," + pixel[3] + "], ";
                }
                System.out.println("######################################### " + (String)line);
            }
            System.out.println("########################################################################### after ");
            for (y = 0; y < height; ++y) {
                Object line = "";
                for (int x = 0; x < width; ++x) {
                    pixel = rasterAfter[y][x];
                    line = (String)line + "[" + pixel[0] + "," + pixel[1] + "," + pixel[2] + "," + pixel[3] + "], ";
                }
                System.out.println("######################################### " + (String)line);
            }
        }
        return result;
    }

    protected double getZoomScaleMultiplicator(double zoom, double scaleMultiplicator) {
        double inverseZoom = 19.0 - zoom;
        double scaler = Math.pow(scaleMultiplicator, inverseZoom);
        return 1.0 / inverseZoom * scaler;
    }

    protected ArrayList<Point> cleanup(ArrayList<Point> xyTilePoints, double minDistance) {
        ArrayList<Point> result = new ArrayList<Point>();
        Point lastRenderedPoint = null;
        for (int i = 0; i < xyTilePoints.size(); ++i) {
            Point point = xyTilePoints.get(i);
            if (i == 0) {
                lastRenderedPoint = point;
                result.add(point);
                continue;
            }
            double distanceToLastRenderedPoint = lastRenderedPoint.getDistance(point);
            if (!(distanceToLastRenderedPoint >= minDistance) && i != xyTilePoints.size() - 1) continue;
            lastRenderedPoint = point;
            result.add(point);
        }
        return result;
    }

    protected ArrayList<Point> clip(ArrayList<Point> allPoints, BoundingBox bbox) {
        ArrayList<Point> clippedPoints = new ArrayList<Point>();
        for (int i = 0; i < allPoints.size(); ++i) {
            Point currentPoint = allPoints.get(i);
            if (!bbox.contains(currentPoint)) continue;
            clippedPoints.add(currentPoint);
        }
        return clippedPoints;
    }

    protected double getZoomScaleMultiplicatorTextLine(double zoom) {
        double[] results = new double[]{1.0, 1.0, 0.9, 0.9, 0.9, 0.9, 0.9, 0.9, 0.9, 0.9, 0.9, 0.9, 0.9, 0.9, 0.9, 0.9, 0.9, 0.9, 0.9, 0.9, 0.9};
        return results[(int)zoom];
    }

    protected ArrayList<Float> parseSkipHeights(String skipHeightsString) {
        ArrayList<Float> result = new ArrayList<Float>();
        if (skipHeightsString != null && !skipHeightsString.isEmpty()) {
            String[] skipHeightsArray = skipHeightsString.split(",");
            for (int i = 0; i < skipHeightsArray.length; ++i) {
                result.add(Float.valueOf(Float.parseFloat(skipHeightsArray[i])));
            }
        }
        return result;
    }
}

