/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.math;

import com.vividsolutions.jts.geom.Coordinate;
import java.util.ArrayList;
import java.util.List;

public class SplineCatmullRom {
    public static List<Coordinate> interpolate(List<Coordinate> coordinates, int pointsPerSegment) throws Exception {
        boolean isClosed;
        ArrayList<Coordinate> vertices = new ArrayList<Coordinate>();
        for (Coordinate c : coordinates) {
            vertices.add(new Coordinate(c.x, c.y));
        }
        if (pointsPerSegment < 2) {
            throw new Exception("The pointsPerSegment parameter must be greater than 2, since 2 points is just the linear segment.");
        }
        if (vertices.size() < 3) {
            return vertices;
        }
        boolean bl = isClosed = ((Coordinate)vertices.get((int)0)).x == ((Coordinate)vertices.get((int)(vertices.size() - 1))).x && ((Coordinate)vertices.get((int)0)).y == ((Coordinate)vertices.get((int)(vertices.size() - 1))).y;
        if (isClosed) {
            Coordinate p2 = new Coordinate((Coordinate)vertices.get(1));
            Coordinate pn1 = new Coordinate((Coordinate)vertices.get(vertices.size() - 2));
            vertices.add(0, pn1);
            vertices.add(p2);
        } else {
            double dx = ((Coordinate)vertices.get((int)1)).x - ((Coordinate)vertices.get((int)0)).x;
            double dy = ((Coordinate)vertices.get((int)1)).y - ((Coordinate)vertices.get((int)0)).y;
            double x1 = ((Coordinate)vertices.get((int)0)).x - dx;
            double y1 = ((Coordinate)vertices.get((int)0)).y - dy;
            Coordinate start = new Coordinate(x1, y1);
            int n = vertices.size() - 1;
            dx = ((Coordinate)vertices.get((int)n)).x - ((Coordinate)vertices.get((int)(n - 1))).x;
            dy = ((Coordinate)vertices.get((int)n)).y - ((Coordinate)vertices.get((int)(n - 1))).y;
            double xn = ((Coordinate)vertices.get((int)n)).x + dx;
            double yn = ((Coordinate)vertices.get((int)n)).y + dy;
            Coordinate end = new Coordinate(xn, yn);
            vertices.add(0, start);
            vertices.add(end);
        }
        ArrayList<Coordinate> result = new ArrayList<Coordinate>();
        for (int i = 0; i < vertices.size() - 3; ++i) {
            List<Coordinate> points = SplineCatmullRom.interpolate(vertices, i, pointsPerSegment);
            if (result.size() > 0) {
                points.remove(0);
            }
            result.addAll(points);
        }
        return result;
    }

    public static List<Coordinate> interpolate(List<Coordinate> points, int index, int pointsPerSegment) {
        ArrayList<Coordinate> result = new ArrayList<Coordinate>();
        double[] x = new double[4];
        double[] y = new double[4];
        double[] time = new double[4];
        for (int i = 0; i < 4; ++i) {
            x[i] = points.get((int)(index + i)).x;
            y[i] = points.get((int)(index + i)).y;
            time[i] = i;
        }
        double total = 0.0;
        for (int i = 1; i < 4; ++i) {
            double dx = x[i] - x[i - 1];
            double dy = y[i] - y[i - 1];
            time[i] = total += Math.pow(dx * dx + dy * dy, 0.25);
        }
        double tstart = time[1];
        double tend = time[2];
        int segments = pointsPerSegment - 1;
        result.add(points.get(index + 1));
        for (int i = 1; i < segments; ++i) {
            double xi = SplineCatmullRom.interpolate(x, time, tstart + (double)i * (tend - tstart) / (double)segments);
            double yi = SplineCatmullRom.interpolate(y, time, tstart + (double)i * (tend - tstart) / (double)segments);
            result.add(new Coordinate(xi, yi));
        }
        result.add(points.get(index + 2));
        return result;
    }

    public static double interpolate(double[] p, double[] time, double t) {
        double L01 = p[0] * (time[1] - t) / (time[1] - time[0]) + p[1] * (t - time[0]) / (time[1] - time[0]);
        double L12 = p[1] * (time[2] - t) / (time[2] - time[1]) + p[2] * (t - time[1]) / (time[2] - time[1]);
        double L23 = p[2] * (time[3] - t) / (time[3] - time[2]) + p[3] * (t - time[2]) / (time[3] - time[2]);
        double L012 = L01 * (time[2] - t) / (time[2] - time[0]) + L12 * (t - time[0]) / (time[2] - time[0]);
        double L123 = L12 * (time[3] - t) / (time[3] - time[1]) + L23 * (t - time[1]) / (time[3] - time[1]);
        double C12 = L012 * (time[2] - t) / (time[2] - time[1]) + L123 * (t - time[1]) / (time[2] - time[1]);
        return C12;
    }
}

