/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.manifest;

import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class ManifestAccessor {
    public Manifest getManifest() throws Exception {
        Enumeration<URL> resources = this.getClass().getClassLoader().getResources("META-INF/MANIFEST.MF");
        while (resources.hasMoreElements()) {
            InputStream manifestStream = resources.nextElement().openStream();
            Manifest manifest = new Manifest(manifestStream);
            manifestStream.close();
            String implementationTitle = manifest.getMainAttributes().getValue("Implementation-Title");
            if (!"maprender".equals(implementationTitle)) continue;
            return manifest;
        }
        return null;
    }

    public String getManifestEntry(String entryName) throws Exception {
        Manifest manifest = this.getManifest();
        Attributes mainAttributes = manifest.getMainAttributes();
        String value = mainAttributes.getValue(entryName);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public Date getManifestEntryAsDate(String entryName) throws Exception {
        String value = this.getManifestEntry(entryName);
        if (value != null) {
            Date dateValue = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").parse(value);
            return dateValue;
        }
        return null;
    }
}

