/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.geom;

import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.geom.Line;
import de.wideportal.maprender.geom.Point;

public class Circle {
    public Point center;
    public double radius = 0.0;

    public Circle() {
    }

    public Circle(Point center, double radius) {
        this.center = center;
        this.radius = radius;
    }

    public Circle(double x, double y, double radius) {
        this.center = new Point(x, y);
        this.radius = radius;
    }

    public Point getCenter() {
        return this.center;
    }

    public void setCenter(Point center) {
        this.center = center;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public BoundingBox getBoundingBox() {
        return new BoundingBox(this.center.getX() - this.radius, this.center.getY() + this.radius, this.center.getX() + this.radius, this.center.getY() - this.radius);
    }

    public double getDistance(Circle other) {
        Line line = new Line(this.getCenter(), other.getCenter());
        return line.getLength();
    }

    public boolean intersects(Circle other) {
        double addedRadii;
        double distance = this.getDistance(other);
        return distance <= (addedRadii = this.radius + other.radius);
    }

    public boolean intersects(BoundingBox other) {
        double centerDistanceX = Math.abs(this.getCenter().getX() - other.getCenter().getX());
        double centerDistanceY = Math.abs(this.getCenter().getY() - other.getCenter().getY());
        if (centerDistanceX > other.getWidth() / 2.0 + this.getRadius()) {
            return false;
        }
        if (centerDistanceY > other.getHeight() / 2.0 + this.getRadius()) {
            return false;
        }
        if (centerDistanceX <= other.getWidth() / 2.0) {
            return true;
        }
        if (centerDistanceY <= other.getHeight() / 2.0) {
            return true;
        }
        double cornerDistance = Math.pow(centerDistanceX - other.getWidth() / 2.0, 2.0) + Math.pow(centerDistanceY - other.getHeight() / 2.0, 2.0);
        return cornerDistance <= Math.pow(this.getRadius(), 2.0);
    }

    public String toString() {
        return "Circle[center=" + this.center + ", radius=" + this.radius + "]";
    }
}

