/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.deprecated;

import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.geom.Line;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.resources.srtm.buffer.MultipleValueCollectorBuffer;
import java.io.Serializable;

public class SrtmCollectTile
implements Serializable {
    private static final long serialVersionUID = -5217612422043428618L;
    public static final int TILE_BORDER_BUFFER_PIXELS_BASE = 50;
    private BoundingBox latLonBBox;
    private BoundingBox latLonCollectFromBox;
    private int pixelTileSize;
    private int bufferedTileSize;
    private MultipleValueCollectorBuffer multipleValueBuffer;
    private boolean needsExpensiveSmoothing = false;
    private float minValue = Float.MAX_VALUE;
    private float maxValue = -3.4028235E38f;
    public int subTileSizeX = -1;
    public int subTileSizeY = -1;

    private SrtmCollectTile(BoundingBox latLonBBox, BoundingBox latLonCollectFromBox, int pixelTileSize) {
        this.latLonBBox = latLonBBox;
        this.latLonCollectFromBox = latLonCollectFromBox;
        this.pixelTileSize = pixelTileSize;
        this.bufferedTileSize = pixelTileSize + 100;
        this.multipleValueBuffer = new MultipleValueCollectorBuffer(this.bufferedTileSize, this.bufferedTileSize);
    }

    public BoundingBox getLatLonBBox() {
        return this.latLonBBox;
    }

    public long getPixelTileSize() {
        return this.pixelTileSize;
    }

    public int getBufferedTileSize() {
        return this.bufferedTileSize;
    }

    public BoundingBox getLatLonCollectFromBox() {
        return this.latLonCollectFromBox;
    }

    public int getSubTileSizeX() {
        return this.subTileSizeX;
    }

    public int getSubTileSizeY() {
        return this.subTileSizeY;
    }

    public float getMinValue() {
        return this.minValue;
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public MultipleValueCollectorBuffer getMultipleValueBuffer() {
        return this.multipleValueBuffer;
    }

    public boolean performNeedsExpensiveSmoothingCheck(double srtmCellWidth, double srtmCellHeight, long tileSize) {
        double collectorTileLonLeft = this.latLonBBox.getLeft();
        double collectorTileLonRight = this.latLonBBox.getRight();
        double collectorTileLatBottom = this.latLonBBox.getBottom();
        double collectorTileLatTop = this.latLonBBox.getTop();
        double collectorCellWidth = Math.abs(collectorTileLonRight - collectorTileLonLeft) / (double)tileSize;
        double collectorCellHeight = Math.abs(collectorTileLatTop - collectorTileLatBottom) / (double)tileSize;
        if (collectorCellWidth >= srtmCellWidth / 3.0 || collectorCellHeight >= srtmCellHeight / 3.0) {
            this.needsExpensiveSmoothing = true;
        }
        return this.needsExpensiveSmoothing;
    }

    public boolean needsExpensiveSmoothing() {
        return this.needsExpensiveSmoothing;
    }

    public void addValueSimple(double srtmLeftLon, double srtmTopLat, double srtmRightLon, double srtmBottomLat, float value) {
        int bottomSrtmCellIndex;
        int topSrtmCellIndex;
        int rightSrtmCellIndex;
        double collectorTileLonLeft = this.latLonBBox.getLeft();
        double collectorTileLonRight = this.latLonBBox.getRight();
        double collectorTileLatBottom = this.latLonBBox.getBottom();
        double collectorTileLatTop = this.latLonBBox.getTop();
        double collectorCellPixelRatioLon = Math.abs(collectorTileLonRight - collectorTileLonLeft) / (double)this.pixelTileSize;
        double collectorCellPixelRatioLat = Math.abs(collectorTileLatTop - collectorTileLatBottom) / (double)this.pixelTileSize;
        int leftSrtmCellIndex = (int)Math.floor((srtmLeftLon - collectorTileLonLeft) / collectorCellPixelRatioLon);
        if (leftSrtmCellIndex < -50) {
            leftSrtmCellIndex = -50;
        }
        if ((rightSrtmCellIndex = (int)Math.ceil((srtmRightLon - collectorTileLonLeft) / collectorCellPixelRatioLon)) == leftSrtmCellIndex) {
            rightSrtmCellIndex = leftSrtmCellIndex + 1;
        }
        if (rightSrtmCellIndex < -50) {
            rightSrtmCellIndex = -50;
        }
        if (rightSrtmCellIndex > this.pixelTileSize + 50) {
            rightSrtmCellIndex = this.pixelTileSize + 50;
        }
        if ((topSrtmCellIndex = (int)Math.floor((collectorTileLatTop - srtmTopLat) / collectorCellPixelRatioLat)) < -50) {
            topSrtmCellIndex = -50;
        }
        if ((bottomSrtmCellIndex = (int)Math.ceil((collectorTileLatTop - srtmBottomLat) / collectorCellPixelRatioLat)) == topSrtmCellIndex) {
            bottomSrtmCellIndex = topSrtmCellIndex + 1;
        }
        if (bottomSrtmCellIndex < -50) {
            bottomSrtmCellIndex = -50;
        }
        if (bottomSrtmCellIndex > this.pixelTileSize + 50) {
            bottomSrtmCellIndex = this.pixelTileSize + 50;
        }
        for (int yPixelSrtmCell = topSrtmCellIndex; yPixelSrtmCell < bottomSrtmCellIndex; ++yPixelSrtmCell) {
            for (int xPixelSrtmCell = leftSrtmCellIndex; xPixelSrtmCell < rightSrtmCellIndex; ++xPixelSrtmCell) {
                this.multipleValueBuffer.addValue(xPixelSrtmCell + 50, yPixelSrtmCell + 50, value);
                this.minValue = Math.min(this.minValue, value);
                this.maxValue = Math.max(this.maxValue, value);
            }
        }
    }

    public void addValue(double srtmLeftLon, double srtmTopLat, double srtmRightLon, double srtmBottomLat, float value, float[] srtmSurroundingCellHeights) {
        int bottomSrtmCellIndex;
        int topSrtmCellIndex;
        int rightSrtmCellIndex;
        int leftSrtmCellIndex;
        double collectorTileLonLeft = this.latLonBBox.getLeft();
        double collectorTileLonRight = this.latLonBBox.getRight();
        double collectorTileLatBottom = this.latLonBBox.getBottom();
        double collectorTileLatTop = this.latLonBBox.getTop();
        double collectorCellPixelRatioLon = Math.abs(collectorTileLonRight - collectorTileLonLeft) / (double)this.pixelTileSize;
        double collectorCellPixelRatioLat = Math.abs(collectorTileLatTop - collectorTileLatBottom) / (double)this.pixelTileSize;
        int leftSrtmCellIndexWithoutBorders = leftSrtmCellIndex = (int)Math.floor((srtmLeftLon - collectorTileLonLeft) / collectorCellPixelRatioLon);
        if (leftSrtmCellIndex < -50) {
            leftSrtmCellIndex = -50;
        }
        int rightSrtmCellIndexWithoutBorders = rightSrtmCellIndex = (int)Math.ceil((srtmRightLon - collectorTileLonLeft) / collectorCellPixelRatioLon);
        if (rightSrtmCellIndex == leftSrtmCellIndex) {
            rightSrtmCellIndex = leftSrtmCellIndex + 1;
        }
        if (rightSrtmCellIndex < -50) {
            rightSrtmCellIndex = -50;
        }
        if (rightSrtmCellIndex > this.pixelTileSize + 50) {
            rightSrtmCellIndex = this.pixelTileSize + 50;
        }
        int topSrtmCellIndexWithoutBorders = topSrtmCellIndex = (int)Math.floor((collectorTileLatTop - srtmTopLat) / collectorCellPixelRatioLat);
        if (topSrtmCellIndex < -50) {
            topSrtmCellIndex = -50;
        }
        int bottomSrtmCellIndexWithoutBorders = bottomSrtmCellIndex = (int)Math.ceil((collectorTileLatTop - srtmBottomLat) / collectorCellPixelRatioLat);
        if (bottomSrtmCellIndex == topSrtmCellIndex) {
            bottomSrtmCellIndex = topSrtmCellIndex + 1;
        }
        if (bottomSrtmCellIndex < -50) {
            bottomSrtmCellIndex = -50;
        }
        if (bottomSrtmCellIndex > this.pixelTileSize + 50) {
            bottomSrtmCellIndex = this.pixelTileSize + 50;
        }
        int srtmCellPixelsWidth = Math.abs(rightSrtmCellIndexWithoutBorders - leftSrtmCellIndexWithoutBorders);
        int srtmCellPixelsHeight = Math.abs(topSrtmCellIndexWithoutBorders - bottomSrtmCellIndexWithoutBorders);
        int currentSrtmCellSizeX = rightSrtmCellIndex - leftSrtmCellIndex;
        this.subTileSizeX = Math.max(this.subTileSizeX, currentSrtmCellSizeX);
        this.subTileSizeX = Math.max(this.subTileSizeX, 1);
        int currentSrtmCellSizeY = bottomSrtmCellIndex - topSrtmCellIndex;
        this.subTileSizeY = Math.max(this.subTileSizeY, currentSrtmCellSizeY);
        this.subTileSizeY = Math.max(this.subTileSizeY, 1);
        for (int yPixelSrtmCell = topSrtmCellIndex; yPixelSrtmCell < bottomSrtmCellIndex; ++yPixelSrtmCell) {
            for (int xPixelSrtmCell = leftSrtmCellIndex; xPixelSrtmCell < rightSrtmCellIndex; ++xPixelSrtmCell) {
                float newValue;
                float newValue2;
                int bottomSmoothIndex;
                int topSmoothIndex;
                int rightSmoothIndex;
                float srtmCellPositionX = xPixelSrtmCell - leftSrtmCellIndexWithoutBorders;
                float srtmCellPositionY = yPixelSrtmCell - topSrtmCellIndexWithoutBorders;
                int xWithBorder = xPixelSrtmCell + 50;
                int yWithBorder = yPixelSrtmCell + 50;
                int leftSmoothIndex = xWithBorder - this.subTileSizeX / 2 - 1;
                if (leftSmoothIndex < 0) {
                    leftSmoothIndex = 0;
                }
                if ((rightSmoothIndex = xWithBorder + this.subTileSizeX / 2 + 1) == leftSmoothIndex) {
                    rightSmoothIndex = leftSmoothIndex + 1;
                }
                if (rightSmoothIndex > this.bufferedTileSize) {
                    rightSmoothIndex = this.bufferedTileSize;
                }
                if ((topSmoothIndex = yWithBorder - this.subTileSizeY / 2 - 1) < 0) {
                    topSmoothIndex = 0;
                }
                if ((bottomSmoothIndex = yWithBorder + this.subTileSizeY / 2 + 1) == topSmoothIndex) {
                    bottomSmoothIndex = topSmoothIndex + 1;
                }
                if (bottomSmoothIndex > this.bufferedTileSize) {
                    bottomSmoothIndex = this.bufferedTileSize;
                }
                float[] surroundingHeights = srtmSurroundingCellHeights;
                float halfSrtmCellWidth = (float)srtmCellPixelsWidth / 2.0f;
                float halfSrtmCellHeight = (float)srtmCellPixelsHeight / 2.0f;
                float ratioX = 1.0f;
                ratioX = srtmCellPositionX < halfSrtmCellWidth ? 0.5f + 0.5f * (srtmCellPositionX / halfSrtmCellWidth) : 0.5f + 0.5f * (((float)srtmCellPixelsWidth - srtmCellPositionX) / halfSrtmCellWidth);
                float ratioY = 1.0f;
                ratioY = srtmCellPositionY < halfSrtmCellHeight ? 0.5f + 0.5f * (srtmCellPositionY / halfSrtmCellHeight) : 0.5f + 0.5f * (((float)srtmCellPixelsHeight - srtmCellPositionY) / halfSrtmCellHeight);
                if (srtmCellPositionX == halfSrtmCellWidth && srtmCellPositionY == halfSrtmCellHeight) {
                    newValue2 = surroundingHeights[4];
                    this.multipleValueBuffer.addValue(xPixelSrtmCell + 50, yPixelSrtmCell + 50, newValue2);
                    this.minValue = Math.min(this.minValue, newValue2);
                    this.maxValue = Math.max(this.maxValue, newValue2);
                    continue;
                }
                if (srtmCellPositionX == halfSrtmCellWidth) {
                    if (srtmCellPositionY < halfSrtmCellHeight) {
                        newValue2 = surroundingHeights[4] * ratioY + surroundingHeights[1] * (1.0f - ratioY);
                        this.multipleValueBuffer.addValue(xPixelSrtmCell + 50, yPixelSrtmCell + 50, newValue2);
                        this.minValue = Math.min(this.minValue, newValue2);
                        this.maxValue = Math.max(this.maxValue, newValue2);
                        continue;
                    }
                    newValue2 = surroundingHeights[4] * ratioY + surroundingHeights[7] * (1.0f - ratioY);
                    this.multipleValueBuffer.addValue(xPixelSrtmCell + 50, yPixelSrtmCell + 50, newValue2);
                    this.minValue = Math.min(this.minValue, newValue2);
                    this.maxValue = Math.max(this.maxValue, newValue2);
                    continue;
                }
                if (srtmCellPositionY == halfSrtmCellHeight) {
                    if (srtmCellPositionX < halfSrtmCellWidth) {
                        newValue2 = surroundingHeights[4] * ratioX + surroundingHeights[3] * (1.0f - ratioX);
                        this.multipleValueBuffer.addValue(xPixelSrtmCell + 50, yPixelSrtmCell + 50, newValue2);
                        this.minValue = Math.min(this.minValue, newValue2);
                        this.maxValue = Math.max(this.maxValue, newValue2);
                        continue;
                    }
                    newValue2 = surroundingHeights[4] * ratioX + surroundingHeights[5] * (1.0f - ratioX);
                    this.multipleValueBuffer.addValue(xPixelSrtmCell + 50, yPixelSrtmCell + 50, newValue2);
                    this.minValue = Math.min(this.minValue, newValue2);
                    this.maxValue = Math.max(this.maxValue, newValue2);
                    continue;
                }
                float ratioC = ratioX * ratioY;
                float ratioN = (1.0f - ratioY) * ratioX;
                float ratioE = (1.0f - ratioX) * ratioY;
                float ratioS = (1.0f - ratioY) * ratioX;
                float ratioW = (1.0f - ratioX) * ratioY;
                float ratioNE = (1.0f - ratioX) * (1.0f - ratioY);
                float ratioSE = (1.0f - ratioX) * (1.0f - ratioY);
                float ratioSW = (1.0f - ratioX) * (1.0f - ratioY);
                float ratioNW = (1.0f - ratioX) * (1.0f - ratioY);
                float partC = surroundingHeights[4] * ratioC;
                float partN = surroundingHeights[1] * ratioN;
                float partE = surroundingHeights[5] * ratioE;
                float partS = surroundingHeights[7] * ratioS;
                float partW = surroundingHeights[3] * ratioW;
                float partNE = surroundingHeights[2] * ratioNE;
                float partSE = surroundingHeights[8] * ratioSE;
                float partSW = surroundingHeights[6] * ratioSW;
                float partNW = surroundingHeights[0] * ratioNW;
                if (srtmCellPositionY < halfSrtmCellHeight && srtmCellPositionX < halfSrtmCellWidth) {
                    newValue = partC + partN + partW + partNW;
                    this.multipleValueBuffer.addValue(xPixelSrtmCell + 50, yPixelSrtmCell + 50, newValue);
                    this.minValue = Math.min(this.minValue, newValue);
                    this.maxValue = Math.max(this.maxValue, newValue);
                    continue;
                }
                if (srtmCellPositionY < halfSrtmCellHeight && srtmCellPositionX > halfSrtmCellWidth) {
                    newValue = partC + partN + partE + partNE;
                    this.multipleValueBuffer.addValue(xPixelSrtmCell + 50, yPixelSrtmCell + 50, newValue);
                    this.minValue = Math.min(this.minValue, newValue);
                    this.maxValue = Math.max(this.maxValue, newValue);
                    continue;
                }
                if (srtmCellPositionY > halfSrtmCellHeight && srtmCellPositionX > halfSrtmCellWidth) {
                    newValue = partC + partS + partE + partSE;
                    this.multipleValueBuffer.addValue(xPixelSrtmCell + 50, yPixelSrtmCell + 50, newValue);
                    this.minValue = Math.min(this.minValue, newValue);
                    this.maxValue = Math.max(this.maxValue, newValue);
                    continue;
                }
                if (!(srtmCellPositionY > halfSrtmCellHeight) || !(srtmCellPositionX < halfSrtmCellWidth)) continue;
                newValue = partC + partS + partW + partSW;
                this.multipleValueBuffer.addValue(xPixelSrtmCell + 50, yPixelSrtmCell + 50, newValue);
                this.minValue = Math.min(this.minValue, newValue);
                this.maxValue = Math.max(this.maxValue, newValue);
            }
        }
    }

    public float getValue(int xPixel, int yPixel) {
        return this.multipleValueBuffer.getAveragedValue(xPixel + 50, yPixel + 50);
    }

    public void setValue(int xPixel, int yPixel, float value) {
        this.multipleValueBuffer.setValue(xPixel + 50, yPixel + 50, 0, value);
        this.multipleValueBuffer.setValue(xPixel + 50, yPixel + 50, 3, value);
        this.multipleValueBuffer.setValue(xPixel + 50, yPixel + 50, 2, value);
        this.multipleValueBuffer.setValue(xPixel + 50, yPixel + 50, 4, value);
        this.multipleValueBuffer.setValue(xPixel + 50, yPixel + 50, 1, 1.0f);
    }

    public float getValueFromBuffer(int xPixel, int yPixel) {
        return this.multipleValueBuffer.getAveragedValue(xPixel, yPixel);
    }

    public void setValueToBuffer(int xPixel, int yPixel, float value) {
        this.multipleValueBuffer.setValue(xPixel, yPixel, 0, value);
        this.multipleValueBuffer.setValue(xPixel, yPixel, 3, value);
        this.multipleValueBuffer.setValue(xPixel, yPixel, 2, value);
        this.multipleValueBuffer.setValue(xPixel, yPixel, 4, value);
        this.multipleValueBuffer.setValue(xPixel, yPixel, 1, 1.0f);
    }

    public boolean isInCollectorBounds(Line line) {
        Point start = line.getStart();
        Point stop = line.getStop();
        return start.getX() > -50.0 && start.getX() < (double)(this.bufferedTileSize - 50) && start.getY() > -50.0 && start.getY() < (double)(this.bufferedTileSize - 50) && stop.getX() > -50.0 && stop.getX() < (double)(this.bufferedTileSize - 50) && stop.getY() > -50.0 && stop.getY() < (double)(this.bufferedTileSize - 50);
    }

    public SrtmCollectTile blur(int blurRadius) {
        MultipleValueCollectorBuffer newMultipleValueBuffer = new MultipleValueCollectorBuffer(this.bufferedTileSize, this.bufferedTileSize);
        for (int y = 0; y < this.bufferedTileSize; ++y) {
            for (int x = 0; x < this.bufferedTileSize; ++x) {
                float smoothedValue;
                int bottomSmoothIndex;
                int topSmoothIndex;
                int rightSmoothIndex;
                int leftSmoothIndex = x - blurRadius;
                if (leftSmoothIndex < 0) {
                    leftSmoothIndex = 0;
                }
                if ((rightSmoothIndex = x + blurRadius) == leftSmoothIndex) {
                    rightSmoothIndex = leftSmoothIndex + 1;
                }
                if (rightSmoothIndex >= this.bufferedTileSize) {
                    rightSmoothIndex = this.bufferedTileSize - 1;
                }
                if ((topSmoothIndex = y - blurRadius) < 0) {
                    topSmoothIndex = 0;
                }
                if ((bottomSmoothIndex = y + blurRadius) == topSmoothIndex) {
                    bottomSmoothIndex = topSmoothIndex + 1;
                }
                if (bottomSmoothIndex >= this.bufferedTileSize) {
                    bottomSmoothIndex = this.bufferedTileSize - 1;
                }
                int sampleSizeX = 1;
                int sampleSizeY = 1;
                float totalValues = 0.0f;
                float counter = 0.0f;
                for (int i = leftSmoothIndex; i < rightSmoothIndex; i += sampleSizeX) {
                    for (int j = topSmoothIndex; j < bottomSmoothIndex; j += sampleSizeY) {
                        totalValues += this.multipleValueBuffer.getAveragedValue(i, j);
                        counter += 1.0f;
                    }
                }
                if (counter != 0.0f) {
                    smoothedValue = totalValues / counter;
                    newMultipleValueBuffer.addValue(x, y, smoothedValue);
                    continue;
                }
                smoothedValue = this.multipleValueBuffer.getAveragedValue(x, y);
                newMultipleValueBuffer.addValue(x, y, smoothedValue);
            }
        }
        this.multipleValueBuffer = newMultipleValueBuffer;
        return this;
    }

    public void logBuffer() {
        this.logBuffer(0, 0, this.multipleValueBuffer.getXSize(), 0, this.multipleValueBuffer.getYSize());
    }

    public void logBuffer(int z, int xMin, int xMax, int yMin, int yMax) {
        System.out.println("################################################# logBuffer SrtmCollectTile");
        for (int y = yMin; y < yMax; ++y) {
            StringBuffer rowBuffy = new StringBuffer();
            for (int x = xMin; x < xMax; ++x) {
                float value = this.multipleValueBuffer.getValue(x, y, z);
                String lengthFilledValue = String.format("%.5f", Float.valueOf(value));
                rowBuffy.append(lengthFilledValue);
                rowBuffy.append(", ");
            }
            System.out.println("######################### " + y + ": " + rowBuffy.toString());
        }
    }

    public void logBufferAveraged() {
        this.logBufferAveraged(0, this.multipleValueBuffer.getXSize(), 0, this.multipleValueBuffer.getYSize());
    }

    public void logBufferAveraged(int xMin, int xMax, int yMin, int yMax) {
        System.out.println("################################################# logBuffer SrtmCollectTile");
        StringBuffer rowBuffy = new StringBuffer();
        for (int x = xMin; x < xMax; ++x) {
            String column = String.format("%10s", "" + x);
            rowBuffy.append(column);
            rowBuffy.append(", ");
        }
        System.out.println("#########################  : " + rowBuffy.toString());
        for (int y = yMin; y < yMax; ++y) {
            rowBuffy = new StringBuffer();
            for (int x = xMin; x < xMax; ++x) {
                float value = this.multipleValueBuffer.getAveragedValue(x, y);
                String lengthFilledValue = String.format("%10s", String.format("%.5f", Float.valueOf(value)));
                rowBuffy.append(lengthFilledValue);
                rowBuffy.append(", ");
            }
            System.out.println("######################### " + y + ": " + rowBuffy.toString());
        }
    }
}

