/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.datasource.osm;

import de.wideportal.maprender.datasource.IDatasourceGeometry;
import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.geom.Point;
import java.util.ArrayList;

public class PostgresPoint
implements IDatasourceGeometry {
    public static final String GEOMETRY_PREFIX = "POINT";
    private String source;
    private Point point;

    private PostgresPoint() {
    }

    public PostgresPoint(String geometryString) {
        this.source = geometryString;
        this.parseGeometryString(geometryString);
    }

    public static boolean isFittingGeometry(String geometryString) {
        return geometryString != null && geometryString.startsWith("POINT(");
    }

    private void parseGeometryString(String geometryString) {
        Point mercatorPoint;
        geometryString = geometryString.replaceAll("/", ".");
        geometryString = geometryString.replaceAll("!", ".");
        geometryString = geometryString.replaceAll("([0-9])\\-([\\-0-9])", "$1,$2");
        String prefixToCut = "POINT(";
        geometryString = geometryString.substring(prefixToCut.length(), geometryString.length() - 1);
        String[] webMercatorPoints = geometryString.split(" ");
        this.point = mercatorPoint = new Point(Double.parseDouble(webMercatorPoints[0]), Double.parseDouble(webMercatorPoints[1]));
    }

    public Point getPoint() {
        return this.point;
    }

    public void setPoint(Point point) {
        this.point = point;
    }

    public ArrayList<Point> getPointsInBoundingBoxMercator(BoundingBox boundingBox) {
        ArrayList<Point> pointsInBoundingBox = new ArrayList<Point>();
        if (this.point.x >= boundingBox.left && this.point.x <= boundingBox.right && this.point.y <= boundingBox.top && this.point.y >= boundingBox.bottom) {
            pointsInBoundingBox.add(this.point);
        }
        return pointsInBoundingBox;
    }

    public String getSource() {
        return this.source;
    }

    public PostgresPoint clone() {
        PostgresPoint clone = new PostgresPoint();
        clone.source = this.source;
        clone.point = this.point;
        return clone;
    }

    public String toString() {
        return "PostgresPoint[#point=" + this.point + ", source=" + this.source + "]";
    }
}

