/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.datasource.osm;

import de.wideportal.maprender.datasource.IDatasourceGeometry;
import de.wideportal.maprender.datasource.osm.PostgresLineString;

public class PostgresMultiLineString
implements IDatasourceGeometry {
    public static final String GEOMETRY_PREFIX = "MULTILINESTRING";
    private String source;
    private PostgresLineString[] lineStrings = null;

    private PostgresMultiLineString() {
    }

    public PostgresMultiLineString(String geometryString) {
        this.source = geometryString;
        this.parseGeometryString(geometryString);
    }

    public static boolean isFittingGeometry(String geometryString) {
        return geometryString != null && geometryString.startsWith("MULTILINESTRING(");
    }

    private void parseGeometryString(String geometryString) {
        String prefixToCut = "MULTILINESTRING(";
        geometryString = geometryString.substring(prefixToCut.length(), geometryString.length() - 1);
        String[] lineStringList = geometryString.split("\\),\\(");
        this.lineStrings = new PostgresLineString[lineStringList.length];
        for (int i = 0; i < lineStringList.length; ++i) {
            String currentLineString = lineStringList[i];
            if (currentLineString.startsWith("(")) {
                currentLineString = currentLineString.substring(1);
            }
            if (currentLineString.endsWith(")")) {
                currentLineString = currentLineString.substring(0, currentLineString.length() - 1);
            }
            this.lineStrings[i] = new PostgresLineString("LINESTRING(" + currentLineString + ")");
        }
    }

    public PostgresLineString[] getLineStrings() {
        return this.lineStrings;
    }

    public String getSource() {
        return this.source;
    }

    public PostgresMultiLineString clone() {
        PostgresMultiLineString clone = new PostgresMultiLineString();
        clone.source = this.source;
        clone.lineStrings = new PostgresLineString[this.lineStrings.length];
        for (int i = 0; i < this.lineStrings.length; ++i) {
            clone.lineStrings[i] = this.lineStrings[i].clone();
        }
        return clone;
    }

    public String toString() {
        return "PostgresMultiLineString[#lineStrings=" + this.lineStrings.length + ", source=" + this.source + "]";
    }
}

