/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.config.xml.osm.imagefilter;

import de.wideportal.maprender.config.xml.osm.imagefilter.OsmStyleImageFilterScaleHSLA;
import de.wideportal.maprender.request.RenderImageLayer;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOsmStyleImageFilter {
    private static Logger log = LoggerFactory.getLogger(AbstractOsmStyleImageFilter.class);

    public abstract void applyFilter(RenderImageLayer var1);

    public static ArrayList<AbstractOsmStyleImageFilter> parse(String filterString) {
        ArrayList<AbstractOsmStyleImageFilter> results = new ArrayList<AbstractOsmStyleImageFilter>();
        if (filterString != null && !filterString.isBlank()) {
            log.debug("parse: starting to parse filter string: " + filterString);
            int indexBlockStart = 0;
            int openingBracketIndex = -1;
            int openBracketsCounter = 0;
            int closingBracketIndex = -1;
            for (int i = 0; i < filterString.length(); ++i) {
                if (filterString.charAt(i) == '(') {
                    if (++openBracketsCounter != 1) continue;
                    openingBracketIndex = i;
                    continue;
                }
                if (filterString.charAt(i) == ')') {
                    if (--openBracketsCounter != 0) continue;
                    closingBracketIndex = i;
                    String filterName = filterString.substring(indexBlockStart, openingBracketIndex);
                    String configuration = filterString.substring(openingBracketIndex + 1, closingBracketIndex);
                    results.add(AbstractOsmStyleImageFilter.createFilter(filterName.trim(), configuration.trim()));
                    continue;
                }
                if (filterString.charAt(i) != ',' || openBracketsCounter != 0) continue;
                indexBlockStart = i + 1;
            }
            log.debug("parse: found filters: " + results);
        }
        return results;
    }

    private static AbstractOsmStyleImageFilter createFilter(String filterName, String configuration) {
        if (filterName != null && configuration != null && filterName.equalsIgnoreCase("scale-hsla")) {
            return new OsmStyleImageFilterScaleHSLA(configuration);
        }
        return null;
    }
}

