/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.config.xml.osm.accessor;

import de.wideportal.maprender.config.xml.osm.OsmMap;
import de.wideportal.maprender.config.xml.osm.OsmRule;
import de.wideportal.maprender.config.xml.osm.OsmStyle;
import de.wideportal.maprender.config.xml.osm.accessor.BaseAccessor;
import de.wideportal.maprender.config.xml.osm.compop.AbstractOsmStyleImageCompOp;
import de.wideportal.maprender.config.xml.osm.imagefilter.AbstractOsmStyleImageFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class OsmStyleAccessor
extends BaseAccessor {
    public static final float DEFAULT_OPACITY = 1.0f;
    public static final String DEFAULT_FILTER_MODE = "first";
    private Optional<Float> cachedOpacity = null;
    private ArrayList<AbstractOsmStyleImageFilter> cachedFilters = null;
    private ArrayList<AbstractOsmStyleImageFilter> cachedBaseFilters = null;
    private Optional<AbstractOsmStyleImageCompOp> cachedCompOp = null;
    private OsmStyle osmStyle;

    public OsmStyleAccessor(OsmStyle osmStyle) {
        this.osmStyle = osmStyle;
    }

    public Optional<String> getIdentifier() {
        return Optional.ofNullable(this.osmStyle.getIdentifier());
    }

    public List<OsmRule> getRules() {
        List<OsmRule> rules = this.osmStyle.getRules();
        if (rules == null) {
            rules = new ArrayList<OsmRule>();
            this.osmStyle.setRules(rules);
        }
        return rules;
    }

    public String getFilterMode() {
        return this.getFromOptionalOrElse(Optional.ofNullable(this.osmStyle.getFilterMode()), DEFAULT_FILTER_MODE);
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.osmStyle.getName());
    }

    public Optional<Float> getOpacity() {
        if (this.cachedOpacity == null) {
            this.cachedOpacity = this.safeParseFloat(this.osmStyle.getOpacity());
        }
        return this.cachedOpacity;
    }

    public OsmMap getParent() {
        return this.osmStyle.getParent();
    }

    public OsmStyle getOsmStyle() {
        return this.osmStyle;
    }

    public ArrayList<AbstractOsmStyleImageFilter> getImageFilters() {
        if (this.cachedFilters == null) {
            this.cachedFilters = AbstractOsmStyleImageFilter.parse(this.osmStyle.getImageFilters());
        }
        return this.cachedFilters;
    }

    public ArrayList<AbstractOsmStyleImageFilter> getBaseImageFilters() {
        if (this.cachedBaseFilters == null) {
            this.cachedBaseFilters = AbstractOsmStyleImageFilter.parse(this.osmStyle.getBaseImageFilters());
        }
        return this.cachedBaseFilters;
    }

    public Optional<AbstractOsmStyleImageCompOp> getCompOp() {
        if (this.cachedCompOp == null) {
            this.cachedCompOp = Optional.ofNullable(AbstractOsmStyleImageCompOp.parse(this.osmStyle.getCompOp()));
        }
        return this.cachedCompOp;
    }

    public String toString() {
        return "OsmStyleAccessor[" + this.osmStyle + "]";
    }
}

