/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.config.xml.osm.accessor;

import de.wideportal.maprender.config.xml.osm.OsmHeightAngleSymbolizer;
import de.wideportal.maprender.config.xml.osm.accessor.BaseAccessor;
import de.wideportal.maprender.util.color.ColorUtil;
import java.awt.Color;
import java.util.Optional;

public class OsmHeightAngleSymbolizerAccessor
extends BaseAccessor {
    public static final Color DEFAULT_COLOR = Color.BLACK;
    public static final Float DEFAULT_ANGLE_IMPACT = Float.valueOf(1.0f);
    public static final Boolean DEFAULT_RENDER_MOCK_TILES = true;
    private OsmHeightAngleSymbolizer osmHeightAngleSymbolizer;
    private Color cachedColor = null;
    private Float cachedAngleImpact = null;
    private Boolean cachedRenderMockTiles = null;

    public OsmHeightAngleSymbolizerAccessor(OsmHeightAngleSymbolizer osmHeightAngleSymbolizer) {
        this.osmHeightAngleSymbolizer = osmHeightAngleSymbolizer;
    }

    public OsmHeightAngleSymbolizer getOsmHeightAngleSymbolizer() {
        return this.osmHeightAngleSymbolizer;
    }

    public Optional<String> getIdentifier() {
        return Optional.ofNullable(this.osmHeightAngleSymbolizer.getIdentifier());
    }

    public Float getAngleImpact() {
        if (this.cachedAngleImpact == null) {
            this.cachedAngleImpact = this.getFromOptionalOrElse(this.safeParseFloat(this.osmHeightAngleSymbolizer.getAngleImpact()), DEFAULT_ANGLE_IMPACT.floatValue());
        }
        return this.cachedAngleImpact;
    }

    public Color getColor() {
        if (this.cachedColor == null) {
            Optional<String> optionalColor = this.safeGetNonEmptyString(this.osmHeightAngleSymbolizer.getColor());
            this.cachedColor = optionalColor.isPresent() ? ColorUtil.getColorFromString(optionalColor.get()) : DEFAULT_COLOR;
        }
        return this.cachedColor;
    }

    public Boolean getRenderMockTiles() {
        if (this.cachedRenderMockTiles == null) {
            this.cachedRenderMockTiles = this.getFromOptionalOrElse(this.safeParseBoolean(this.osmHeightAngleSymbolizer.getRenderMockTiles()), DEFAULT_RENDER_MOCK_TILES);
        }
        return this.cachedRenderMockTiles;
    }

    public String toString() {
        return "OsmHeightAngleSymbolizerAccessor[" + this.osmHeightAngleSymbolizer + "]";
    }
}

