/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg.hsql;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class SqlScriptReader {
    boolean fetched = true;
    StringBuilder builder = new StringBuilder();
    BufferedReader reader;

    public SqlScriptReader(Reader reader) {
        this.reader = new BufferedReader(reader);
    }

    public boolean hasNext() throws IOException {
        if (!this.fetched) {
            return this.builder.length() > 0;
        }
        this.builder.setLength(0);
        String line = null;
        boolean insideString = false;
        while ((line = this.reader.readLine()) != null) {
            int quoteCount;
            if ("".equals(line = line.trim()) || line.startsWith("--")) continue;
            if (line.contains("'") && (quoteCount = line.length() - line.replace("'", "").length()) % 2 != 0) {
                boolean bl = insideString = !insideString;
            }
            if (!insideString && line.endsWith(";")) {
                this.builder.append(line).append("\n");
                this.fetched = false;
                break;
            }
            this.builder.append(line);
        }
        if (line == null && this.builder.length() > 0) {
            throw new IOException("The file ends with a non ; terminated command");
        }
        return line != null;
    }

    public String next() throws IOException {
        if (this.fetched) {
            throw new IOException("hasNext was not called, or was called and it returned false");
        }
        this.fetched = true;
        return this.builder.toString();
    }

    public void dispose() {
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

