/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.datum;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.api.referencing.ReferenceIdentifier;
import org.geotools.api.referencing.datum.Datum;
import org.geotools.api.referencing.datum.Ellipsoid;
import org.geotools.api.referencing.datum.GeodeticDatum;
import org.geotools.api.referencing.datum.PrimeMeridian;
import org.geotools.api.referencing.operation.Matrix;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.datum.AbstractDatum;
import org.geotools.referencing.datum.BursaWolfParameters;
import org.geotools.referencing.datum.DefaultEllipsoid;
import org.geotools.referencing.datum.DefaultPrimeMeridian;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.referencing.proj.PROJFormattable;
import org.geotools.referencing.proj.PROJFormatter;
import org.geotools.referencing.wkt.Formatter;

public class DefaultGeodeticDatum
extends AbstractDatum
implements GeodeticDatum,
PROJFormattable {
    private static final long serialVersionUID = 8832100095648302943L;
    public static final DefaultGeodeticDatum WGS84;
    public static final String BURSA_WOLF_KEY = "bursaWolf";
    private final Ellipsoid ellipsoid;
    private final PrimeMeridian primeMeridian;
    private final BursaWolfParameters[] bursaWolf;

    public DefaultGeodeticDatum(GeodeticDatum datum) {
        super((Datum)datum);
        this.ellipsoid = datum.getEllipsoid();
        this.primeMeridian = datum.getPrimeMeridian();
        this.bursaWolf = datum instanceof DefaultGeodeticDatum ? ((DefaultGeodeticDatum)datum).bursaWolf : null;
    }

    public DefaultGeodeticDatum(String name, Ellipsoid ellipsoid, PrimeMeridian primeMeridian) {
        this(Collections.singletonMap("name", name), ellipsoid, primeMeridian);
    }

    public DefaultGeodeticDatum(Map<String, ?> properties, Ellipsoid ellipsoid, PrimeMeridian primeMeridian) {
        super(properties);
        BursaWolfParameters[] bursaWolf;
        this.ellipsoid = ellipsoid;
        this.primeMeridian = primeMeridian;
        DefaultGeodeticDatum.ensureNonNull("ellipsoid", ellipsoid);
        DefaultGeodeticDatum.ensureNonNull("primeMeridian", primeMeridian);
        Object object = properties.get(BURSA_WOLF_KEY);
        if (object instanceof BursaWolfParameters) {
            bursaWolf = new BursaWolfParameters[]{((BursaWolfParameters)object).clone()};
        } else {
            bursaWolf = (BursaWolfParameters[])object;
            if (bursaWolf != null) {
                if (bursaWolf.length == 0) {
                    bursaWolf = null;
                } else {
                    LinkedHashSet<BursaWolfParameters> s = new LinkedHashSet<BursaWolfParameters>();
                    for (BursaWolfParameters bursaWolfParameters : bursaWolf) {
                        s.add(bursaWolfParameters.clone());
                    }
                    bursaWolf = s.toArray(new BursaWolfParameters[s.size()]);
                }
            }
        }
        this.bursaWolf = bursaWolf;
    }

    public Ellipsoid getEllipsoid() {
        return this.ellipsoid;
    }

    public PrimeMeridian getPrimeMeridian() {
        return this.primeMeridian;
    }

    public BursaWolfParameters[] getBursaWolfParameters() {
        if (this.bursaWolf != null) {
            return (BursaWolfParameters[])this.bursaWolf.clone();
        }
        return new BursaWolfParameters[0];
    }

    public BursaWolfParameters getBursaWolfParameters(GeodeticDatum target) {
        if (this.bursaWolf != null) {
            for (BursaWolfParameters candidate : this.bursaWolf) {
                if (!DefaultGeodeticDatum.equals((IdentifiedObject)target, (IdentifiedObject)candidate.targetDatum, false)) continue;
                return candidate.clone();
            }
        }
        return null;
    }

    public static Matrix getAffineTransform(GeodeticDatum source, GeodeticDatum target) {
        return DefaultGeodeticDatum.getAffineTransform(source, target, null);
    }

    private static XMatrix getAffineTransform(GeodeticDatum source, GeodeticDatum target, Set<GeodeticDatum> exclusion) {
        BursaWolfParameters[] bursaWolf;
        DefaultGeodeticDatum.ensureNonNull("source", source);
        DefaultGeodeticDatum.ensureNonNull("target", target);
        if (source instanceof DefaultGeodeticDatum && (bursaWolf = ((DefaultGeodeticDatum)source).bursaWolf) != null) {
            for (BursaWolfParameters transformation : bursaWolf) {
                if (!DefaultGeodeticDatum.equals((IdentifiedObject)target, (IdentifiedObject)transformation.targetDatum, false)) continue;
                return transformation.getAffineTransform();
            }
        }
        if (target instanceof DefaultGeodeticDatum && (bursaWolf = ((DefaultGeodeticDatum)target).bursaWolf) != null) {
            for (BursaWolfParameters transformation : bursaWolf) {
                if (!DefaultGeodeticDatum.equals((IdentifiedObject)source, (IdentifiedObject)transformation.targetDatum, false)) continue;
                XMatrix matrix = transformation.getAffineTransform();
                matrix.invert();
                return matrix;
            }
        }
        if (source instanceof DefaultGeodeticDatum && target instanceof DefaultGeodeticDatum) {
            BursaWolfParameters[] sourceParam = ((DefaultGeodeticDatum)source).bursaWolf;
            BursaWolfParameters[] targetParam = ((DefaultGeodeticDatum)target).bursaWolf;
            if (sourceParam != null && targetParam != null) {
                for (BursaWolfParameters wolfParameters : sourceParam) {
                    GeodeticDatum sourceStep = wolfParameters.targetDatum;
                    for (BursaWolfParameters bursaWolfParameters : targetParam) {
                        GeodeticDatum targetStep = bursaWolfParameters.targetDatum;
                        if (!DefaultGeodeticDatum.equals((IdentifiedObject)sourceStep, (IdentifiedObject)targetStep, false)) continue;
                        if (exclusion == null) {
                            exclusion = new HashSet<GeodeticDatum>();
                        }
                        if (!exclusion.add(source)) continue;
                        if (exclusion.add(target)) {
                            XMatrix step2;
                            XMatrix step1 = DefaultGeodeticDatum.getAffineTransform(source, sourceStep, exclusion);
                            if (step1 != null && (step2 = DefaultGeodeticDatum.getAffineTransform(targetStep, target, exclusion)) != null) {
                                step2.multiply(step1);
                                return step2;
                            }
                            exclusion.remove(target);
                        }
                        exclusion.remove(source);
                    }
                }
            }
        }
        return null;
    }

    public static boolean isWGS84(Datum datum) {
        if (datum instanceof AbstractIdentifiedObject) {
            return WGS84.equals((AbstractIdentifiedObject)datum, false);
        }
        return datum != null && datum.equals(WGS84);
    }

    @Override
    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareMetadata)) {
            DefaultGeodeticDatum that = (DefaultGeodeticDatum)object;
            if (DefaultGeodeticDatum.equals((IdentifiedObject)this.ellipsoid, (IdentifiedObject)that.ellipsoid, compareMetadata) && DefaultGeodeticDatum.equals((IdentifiedObject)this.primeMeridian, (IdentifiedObject)that.primeMeridian, compareMetadata)) {
                return !compareMetadata || Arrays.equals(this.bursaWolf, that.bursaWolf);
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int code = 0x15CF875F ^ 37 * (super.hashCode() ^ 37 * (this.ellipsoid.hashCode() ^ 37 * this.primeMeridian.hashCode()));
        return code;
    }

    @Override
    protected String formatWKT(Formatter formatter) {
        formatter.append((IdentifiedObject)this.ellipsoid);
        if (this.bursaWolf != null) {
            for (BursaWolfParameters transformation : this.bursaWolf) {
                if (!DefaultGeodeticDatum.isWGS84((Datum)transformation.targetDatum)) continue;
                formatter.append(transformation);
                break;
            }
        }
        return "DATUM";
    }

    @Override
    public String formatPROJ(PROJFormatter formatter) {
        if (this.ellipsoid instanceof PROJFormattable && !formatter.isDatumProvided()) {
            formatter.append((PROJFormattable)this.ellipsoid);
        }
        return formatter.isDatumProvided() ? "+datum=" : "";
    }

    static {
        ReferenceIdentifier[] identifiers = new ReferenceIdentifier[]{new NamedIdentifier(Citations.OGC, "WGS84"), new NamedIdentifier(Citations.ORACLE, "WGS 84"), new NamedIdentifier(null, "WGS_84"), new NamedIdentifier(null, "WGS 1984"), new NamedIdentifier(Citations.EPSG, "WGS_1984"), new NamedIdentifier(Citations.ESRI, "D_WGS_1984"), new NamedIdentifier(Citations.EPSG, "World Geodetic System 1984"), new NamedIdentifier(Citations.PROJ, "WGS84")};
        HashMap<String, Object> properties = new HashMap<String, Object>(4);
        properties.put("name", identifiers[0]);
        properties.put("alias", identifiers);
        WGS84 = new DefaultGeodeticDatum(properties, (Ellipsoid)DefaultEllipsoid.WGS84, (PrimeMeridian)DefaultPrimeMeridian.GREENWICH);
    }
}

