/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import java.util.List;
import org.geotools.api.parameter.GeneralParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptorGroup;
import org.geotools.api.parameter.ParameterNotFoundException;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;
import si.uom.NonSI;

public final class Gnomonic
extends MapProjection {
    private static final long serialVersionUID = -1334127158883911268L;
    private static final double EPSILON = 1.0E-6;
    private final double sinPhi0;
    private final double cosPhi0;
    private final double latitudeOfCentre;
    private final double primeVert0;
    private final double projectedCylindricalZ0;

    protected Gnomonic(ParameterValueGroup parameters) throws ParameterNotFoundException {
        super(parameters);
        List expected = this.getParameterDescriptors().descriptors();
        this.latitudeOfCentre = this.doubleValue(expected, Provider.LATITUDE_OF_CENTRE, parameters);
        this.centralMeridian = this.doubleValue(expected, Provider.LONGITUDE_OF_CENTRE, parameters);
        Gnomonic.ensureLatitudeInRange(Provider.LATITUDE_OF_CENTRE, this.latitudeOfCentre, true);
        Gnomonic.ensureLongitudeInRange(Provider.LONGITUDE_OF_CENTRE, this.centralMeridian, true);
        this.sinPhi0 = Math.sin(this.latitudeOfCentre);
        this.cosPhi0 = Math.cos(this.latitudeOfCentre);
        this.primeVert0 = 1.0 / Math.sqrt(1.0 - this.excentricitySquared * this.sinPhi0 * this.sinPhi0);
        this.projectedCylindricalZ0 = this.primeVert0 * this.sinPhi0;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        ParameterValueGroup values = super.getParameterValues();
        List expected = this.getParameterDescriptors().descriptors();
        this.set(expected, Provider.LATITUDE_OF_CENTRE, values, this.latitudeOfCentre);
        this.set(expected, Provider.LONGITUDE_OF_CENTRE, values, this.centralMeridian);
        return values;
    }

    @Override
    protected Point2D transformNormalized(double lambda, double phi, Point2D ptDst) throws ProjectionException {
        double sinPhi = Math.sin(phi);
        double cosPhi = Math.cos(phi);
        double sinLam = Math.sin(lambda);
        double cosLam = Math.cos(lambda);
        double primeVert = 1.0 / Math.sqrt(1.0 - this.excentricitySquared * sinPhi * sinPhi);
        double projected_cylindrical_z = primeVert * sinPhi;
        double delta_projected_cylindrical_z = this.excentricitySquared * (projected_cylindrical_z - this.projectedCylindricalZ0);
        double z_factor = this.cosPhi0 * cosPhi * cosLam + this.sinPhi0 * sinPhi;
        if (z_factor <= 1.0E-6) {
            throw new ProjectionException("Point outside hemisphere of projection.");
        }
        double height = (this.primeVert0 + delta_projected_cylindrical_z * this.sinPhi0) / z_factor;
        double x = height * cosPhi * sinLam;
        double y = height * (this.cosPhi0 * sinPhi - this.sinPhi0 * cosPhi * cosLam) - delta_projected_cylindrical_z * this.cosPhi0;
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    @Override
    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) {
        double normalisedCylindricalZ = this.sinPhi0 * (this.primeVert0 * (1.0 - this.excentricitySquared)) + this.cosPhi0 * y;
        double primeVerticalCylindricalRadius = this.cosPhi0 * this.primeVert0 - this.sinPhi0 * y;
        double lambda = Math.atan2(x, primeVerticalCylindricalRadius);
        double normalisedCylindricalRadius = Math.hypot(x, primeVerticalCylindricalRadius);
        double phi = this.getLatitudeFromPolar(normalisedCylindricalRadius, normalisedCylindricalZ);
        if (ptDst != null) {
            ptDst.setLocation(lambda, phi);
            return ptDst;
        }
        return new Point2D.Double(lambda, phi);
    }

    private double getLatitudeFromPolar(double normalisedCylindricalRadius, double normalisedZ) {
        double eccentricityRatio = this.excentricitySquared / Math.sqrt(1.0 - this.excentricitySquared);
        double modifiedRadiusSq = normalisedCylindricalRadius * normalisedCylindricalRadius / (1.0 - this.excentricitySquared);
        double zExtension = 1.0;
        double estimate = 0.0;
        while (Math.abs(estimate - zExtension) > 1.0E-6) {
            zExtension = estimate;
            double producedZ = normalisedZ + zExtension;
            estimate = eccentricityRatio * producedZ / Math.sqrt(modifiedRadiusSq + producedZ * producedZ);
        }
        double latitude = Math.abs(normalisedCylindricalRadius) <= 1.0E-6 ? (normalisedZ + estimate > 0.0 ? 1.5707963267948966 : -1.5707963267948966) : Math.atan((normalisedZ + estimate) / normalisedCylindricalRadius);
        return latitude;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            Gnomonic that = (Gnomonic)object;
            return Gnomonic.equals(this.latitudeOfCentre, that.latitudeOfCentre);
        }
        return false;
    }

    @Override
    public int hashCode() {
        long code = Double.doubleToLongBits(this.latitudeOfCentre);
        return ((int)code ^ (int)(code >>> 32)) + 37 * super.hashCode();
    }

    public static class Provider
    extends MapProjection.AbstractProvider {
        private static final long serialVersionUID = 7216851295693867026L;
        public static final ParameterDescriptor LATITUDE_OF_CENTRE = Provider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "latitude_of_center"), new NamedIdentifier(Citations.EPSG, "Latitude of natural origin"), new NamedIdentifier(Citations.EPSG, "Spherical latitude of origin"), new NamedIdentifier(Citations.ESRI, "Latitude_Of_Origin"), new NamedIdentifier(Citations.GEOTIFF, "ProjCenterLat"), new NamedIdentifier(Citations.PROJ, "lat_0")}, 0.0, -90.0, 90.0, NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor LONGITUDE_OF_CENTRE = Provider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "longitude_of_center"), new NamedIdentifier(Citations.EPSG, "Longitude of natural origin"), new NamedIdentifier(Citations.EPSG, "Spherical longitude of origin"), new NamedIdentifier(Citations.ESRI, "Central_Meridian"), new NamedIdentifier(Citations.GEOTIFF, "ProjCenterLong"), new NamedIdentifier(Citations.PROJ, "lon_0")}, 0.0, -180.0, 180.0, NonSI.DEGREE_ANGLE);
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "Gnomonic"), new NamedIdentifier(Citations.GEOTIFF, "CT_Gnomonic"), new NamedIdentifier(Citations.PROJ, "gnom")}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, LATITUDE_OF_CENTRE, LONGITUDE_OF_CENTRE, FALSE_EASTING, FALSE_NORTHING});

        public Provider() {
            super(PARAMETERS);
        }

        @Override
        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            return new Gnomonic(parameters);
        }
    }
}

