/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.parameter;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.Set;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.geotools.api.parameter.GeneralParameterDescriptor;
import org.geotools.api.parameter.InvalidParameterTypeException;
import org.geotools.api.parameter.InvalidParameterValueException;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.api.util.CodeList;
import org.geotools.measure.Units;
import org.geotools.parameter.AbstractParameter;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.util.Classes;
import org.geotools.util.Utilities;
import si.uom.NonSI;
import si.uom.SI;
import tech.units.indriya.AbstractUnit;

public class Parameter<T>
extends AbstractParameter
implements ParameterValue<T> {
    private static final long serialVersionUID = -5837826787089486776L;
    private T value;
    private Unit<?> unit;

    public Parameter(ParameterDescriptor<T> descriptor) {
        super((GeneralParameterDescriptor)descriptor);
        this.value = descriptor.getDefaultValue();
        this.unit = descriptor.getUnit();
    }

    public Parameter(ParameterDescriptor<T> descriptor, T value) throws InvalidParameterValueException {
        super((GeneralParameterDescriptor)descriptor);
        this.unit = descriptor.getUnit();
        this.setValue(value);
    }

    public static Parameter<Integer> create(String name, int value) {
        DefaultParameterDescriptor<Integer> descriptor = DefaultParameterDescriptor.create(name, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        Parameter<Integer> parameter = new Parameter<Integer>((ParameterDescriptor<Integer>)descriptor);
        parameter.value = value;
        return parameter;
    }

    public static Parameter<Double> create(String name, double value, Unit<?> unit) {
        if (unit != null) {
            if (SI.METRE.isCompatible(unit)) {
                unit = SI.METRE;
            } else if (SI.DAY.isCompatible(unit)) {
                unit = SI.DAY;
            } else if (NonSI.DEGREE_ANGLE.isCompatible(unit)) {
                unit = NonSI.DEGREE_ANGLE;
            }
        }
        DefaultParameterDescriptor<Double> descriptor = DefaultParameterDescriptor.create(name, Double.NaN, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, unit);
        Parameter<Double> parameter = new Parameter<Double>((ParameterDescriptor<Double>)descriptor);
        parameter.value = value;
        parameter.unit = unit;
        return parameter;
    }

    public static <T extends CodeList> Parameter<T> create(String name, Class<T> type, T value) {
        DefaultParameterDescriptor<Object> descriptor = DefaultParameterDescriptor.create(name, null, type, null, true);
        Parameter<Object> parameter = new Parameter<Object>((ParameterDescriptor<Object>)descriptor);
        parameter.value = value;
        return parameter;
    }

    public static <T> T ensureValidValue(ParameterDescriptor<T> descriptor, Object value) throws InvalidParameterValueException {
        String error;
        if (value == null) {
            return null;
        }
        Class type = descriptor.getValueClass();
        if (!type.isInstance(value)) {
            error = MessageFormat.format("This operation can't be applied to values of class '{0}'.", Classes.getClass((Object)value));
        } else {
            Comparable minimum = descriptor.getMinimumValue();
            Comparable maximum = descriptor.getMaximumValue();
            if (minimum != null && minimum.compareTo(value) > 0 || maximum != null && maximum.compareTo(value) < 0) {
                error = MessageFormat.format("Value {0} is out of range [{1}..{2}].", value, minimum, maximum);
            } else {
                Set validValues = descriptor.getValidValues();
                if (validValues != null && !validValues.contains(value)) {
                    String arg0 = Parameter.getName(descriptor);
                    error = MessageFormat.format("Illegal argument: \"{0}={1}\".", arg0, value);
                } else {
                    return type.cast(value);
                }
            }
        }
        throw new InvalidParameterValueException(error, Parameter.getName(descriptor), value);
    }

    private String getClassTypeError() {
        Class arg0 = ((ParameterDescriptor)this.descriptor).getValueClass();
        return MessageFormat.format("This operation can't be applied to values of class '{0}'.", arg0);
    }

    public ParameterDescriptor<T> getDescriptor() {
        return (ParameterDescriptor)super.getDescriptor();
    }

    public Unit<?> getUnit() {
        return this.unit;
    }

    static String getUnitMessageID(Unit<?> unit) {
        if (AbstractUnit.ONE.isCompatible(unit) || Units.PPM.equals(unit)) {
            return "\"{0}\" is not a scale unit.";
        }
        if (SI.METRE.isCompatible(unit)) {
            return "\"{0}\" is not a linear unit.";
        }
        if (SI.SECOND.isCompatible(unit)) {
            return "\"{0}\" is not a time unit.";
        }
        if (SI.RADIAN.isCompatible(unit)) {
            return "Not an angular unit: \"{0}\".";
        }
        return "Incompatible unit: {0}";
    }

    public double doubleValue(Unit<?> unit) throws InvalidParameterTypeException {
        if (this.unit == null) {
            throw Parameter.unitlessParameter(this.descriptor);
        }
        Parameter.ensureNonNull("unit", unit);
        String expectedID = Parameter.getUnitMessageID(this.unit);
        if (!Objects.equals(Parameter.getUnitMessageID(unit), expectedID)) {
            throw new IllegalArgumentException(MessageFormat.format(expectedID, unit));
        }
        return Units.getConverterToAny(this.unit, unit).convert(this.doubleValue());
    }

    public double doubleValue() throws InvalidParameterTypeException {
        if (this.value instanceof Number) {
            return ((Number)this.value).doubleValue();
        }
        String name = Parameter.getName(this.descriptor);
        if (this.value == null) {
            throw new IllegalStateException(MessageFormat.format("Parameter \"{0}\" is missing.", name));
        }
        throw new InvalidParameterTypeException(this.getClassTypeError(), name);
    }

    public int intValue() throws InvalidParameterTypeException {
        if (this.value instanceof Number) {
            return ((Number)this.value).intValue();
        }
        String name = Parameter.getName(this.descriptor);
        if (this.value == null) {
            throw new IllegalStateException(MessageFormat.format("Parameter \"{0}\" is missing.", name));
        }
        throw new InvalidParameterTypeException(this.getClassTypeError(), name);
    }

    public boolean booleanValue() throws InvalidParameterTypeException {
        if (this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        String name = Parameter.getName(this.descriptor);
        if (this.value == null) {
            throw new IllegalStateException(MessageFormat.format("Parameter \"{0}\" is missing.", name));
        }
        throw new InvalidParameterTypeException(this.getClassTypeError(), name);
    }

    public String stringValue() throws InvalidParameterTypeException {
        if (this.value instanceof CharSequence) {
            return this.value.toString();
        }
        String name = Parameter.getName(this.descriptor);
        if (this.value == null) {
            throw new IllegalStateException(MessageFormat.format("Parameter \"{0}\" is missing.", name));
        }
        throw new InvalidParameterTypeException(this.getClassTypeError(), name);
    }

    public double[] doubleValueList(Unit<?> unit) throws InvalidParameterTypeException {
        if (this.unit == null) {
            throw Parameter.unitlessParameter(this.descriptor);
        }
        Parameter.ensureNonNull("unit", unit);
        String expectedID = Parameter.getUnitMessageID(this.unit);
        if (!Objects.equals(Parameter.getUnitMessageID(unit), expectedID)) {
            throw new IllegalArgumentException(MessageFormat.format(expectedID, unit));
        }
        UnitConverter converter = Units.getConverterToAny(this.unit, unit);
        double[] values = (double[])this.doubleValueList().clone();
        for (int i = 0; i < values.length; ++i) {
            values[i] = converter.convert(values[i]);
        }
        return values;
    }

    public double[] doubleValueList() throws InvalidParameterTypeException {
        if (this.value instanceof double[]) {
            return (double[])this.value;
        }
        String name = Parameter.getName(this.descriptor);
        if (this.value == null) {
            throw new IllegalStateException(MessageFormat.format("Parameter \"{0}\" is missing.", name));
        }
        throw new InvalidParameterTypeException(this.getClassTypeError(), name);
    }

    public int[] intValueList() throws InvalidParameterTypeException {
        if (this.value instanceof int[]) {
            return (int[])this.value;
        }
        String name = Parameter.getName(this.descriptor);
        if (this.value == null) {
            throw new IllegalStateException(MessageFormat.format("Parameter \"{0}\" is missing.", name));
        }
        throw new InvalidParameterTypeException(this.getClassTypeError(), name);
    }

    public URI valueFile() throws InvalidParameterTypeException {
        if (this.value instanceof URI) {
            return (URI)this.value;
        }
        if (this.value instanceof File) {
            return ((File)this.value).toURI();
        }
        URISyntaxException cause = null;
        try {
            if (this.value instanceof URL) {
                return ((URL)this.value).toURI();
            }
            if (this.value instanceof String) {
                return new URI((String)this.value);
            }
        }
        catch (URISyntaxException exception) {
            cause = exception;
        }
        String name = Parameter.getName(this.descriptor);
        if (this.value == null) {
            throw new IllegalStateException(MessageFormat.format("Parameter \"{0}\" is missing.", name));
        }
        InvalidParameterTypeException exception = new InvalidParameterTypeException(this.getClassTypeError(), name);
        if (cause != null) {
            exception.initCause((Throwable)cause);
        }
        throw exception;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(double value, Unit<?> unit) throws InvalidParameterValueException {
        Parameter.ensureNonNull("unit", unit);
        ParameterDescriptor descriptor = (ParameterDescriptor)this.descriptor;
        Unit targetUnit = descriptor.getUnit();
        if (targetUnit == null) {
            throw Parameter.unitlessParameter((GeneralParameterDescriptor)descriptor);
        }
        String expectedID = Parameter.getUnitMessageID(targetUnit);
        if (!Objects.equals(Parameter.getUnitMessageID(unit), expectedID)) {
            throw new InvalidParameterValueException(MessageFormat.format(expectedID, unit), descriptor.getName().getCode(), value);
        }
        Double converted = Units.getConverterToAny(unit, (Unit)targetUnit).convert(value);
        Parameter.ensureValidValue(descriptor, converted);
        this.value = descriptor.getValueClass().cast(value);
        this.unit = unit;
    }

    public void setValue(double value) throws InvalidParameterValueException {
        Double check = value;
        ParameterDescriptor descriptor = (ParameterDescriptor)this.descriptor;
        this.value = Parameter.ensureValidValue(descriptor, check);
    }

    public void setValue(int value) throws InvalidParameterValueException {
        ParameterDescriptor descriptor = (ParameterDescriptor)this.descriptor;
        Class type = descriptor.getValueClass();
        if (Double.class.equals((Object)type) || Double.TYPE.equals(type)) {
            this.setValue((double)value);
            return;
        }
        Integer check = value;
        this.value = Parameter.ensureValidValue(descriptor, check);
    }

    public void setValue(boolean value) throws InvalidParameterValueException {
        ParameterDescriptor descriptor = (ParameterDescriptor)this.descriptor;
        Boolean check = value;
        this.value = Parameter.ensureValidValue(descriptor, check);
    }

    public void setValue(Object value) throws InvalidParameterValueException {
        ParameterDescriptor descriptor = (ParameterDescriptor)this.descriptor;
        this.value = Parameter.ensureValidValue(descriptor, value);
    }

    public void setValue(double[] values, Unit<?> unit) throws InvalidParameterValueException {
        Parameter.ensureNonNull("unit", unit);
        ParameterDescriptor descriptor = (ParameterDescriptor)this.descriptor;
        Unit targetUnit = descriptor.getUnit();
        if (targetUnit == null) {
            throw Parameter.unitlessParameter((GeneralParameterDescriptor)descriptor);
        }
        String expectedID = Parameter.getUnitMessageID(targetUnit);
        if (!Objects.equals(Parameter.getUnitMessageID(unit), expectedID)) {
            throw new IllegalArgumentException(MessageFormat.format(expectedID, unit));
        }
        double[] converted = (double[])values.clone();
        UnitConverter converter = Units.getConverterToAny(unit, (Unit)targetUnit);
        for (int i = 0; i < converted.length; ++i) {
            converted[i] = converter.convert(converted[i]);
        }
        this.value = Parameter.ensureValidValue(descriptor, converted);
        this.unit = unit;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            Parameter that = (Parameter)object;
            return Utilities.equals(this.value, that.value) && Utilities.equals(this.unit, that.unit);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int code = super.hashCode() * 37;
        if (this.value != null) {
            code += this.value.hashCode();
        }
        if (this.unit != null) {
            code += 37 * this.unit.hashCode();
        }
        return code ^ 0x9F456C48;
    }

    @Override
    public Parameter clone() {
        return (Parameter)super.clone();
    }
}

