/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.licenselib;

import de.wideportal.maprender.licenselib.LicenseContainer;
import de.wideportal.maprender.licenselib.exceptions.LicenseException;
import de.wideportal.maprender.licenselib.xml.LicenseConfigurationRoot;
import java.io.File;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseLoader {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public LicenseContainer loadLicense(String licenseFileString) throws LicenseException {
        this.log.info("loadLicense: start loading license: " + licenseFileString);
        File licenseFile = new File(licenseFileString);
        if (!licenseFile.exists() || licenseFile.isDirectory()) {
            throw new LicenseException("License file does not exist: " + licenseFileString);
        }
        LicenseConfigurationRoot licenseConfigurationRoot = this.unmarshallLicense(licenseFile);
        LicenseContainer licenseContainer = new LicenseContainer(licenseConfigurationRoot);
        this.log.debug("loadLicense: finished loading license");
        return licenseContainer;
    }

    private LicenseConfigurationRoot unmarshallLicense(File configurationFile) throws LicenseException {
        this.log.debug("unmarshallLicense: " + configurationFile);
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{LicenseConfigurationRoot.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            LicenseConfigurationRoot licenseConfigurationRoot = (LicenseConfigurationRoot)jaxbUnmarshaller.unmarshal(configurationFile);
            return licenseConfigurationRoot;
        }
        catch (Exception e) {
            this.log.error("unmarshallLicense: could not unmarshal license", (Throwable)e);
            throw new LicenseException("Could not read the content of the license file: " + e.getMessage());
        }
    }
}

