/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.licenselib;

import de.wideportal.maprender.licenselib.LicenseContainer;
import de.wideportal.maprender.licenselib.LicenseEncryption;
import de.wideportal.maprender.licenselib.LicenseLoader;
import de.wideportal.maprender.licenselib.LicensePublicKeyProvider;
import de.wideportal.maprender.licenselib.exceptions.LicenseException;
import de.wideportal.maprender.licenselib.xml.LicenseConfigurationEntry;
import de.wideportal.maprender.licenselib.xml.LicenseConfigurationOptional;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseCheck {
    public static final SimpleDateFormat DDMMYYYY_Format = new SimpleDateFormat("dd.MM.yyyy");
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public LicenseContainer isLicenseValid(String licenseFileString, Date buildDate) throws LicenseException {
        LicenseLoader licenseLoader = new LicenseLoader();
        LicenseContainer license = licenseLoader.loadLicense(licenseFileString);
        LicensePublicKeyProvider publicKeyProvider = new LicensePublicKeyProvider();
        LicenseEncryption licenseEncryption = new LicenseEncryption();
        try {
            String decryptedLicense = licenseEncryption.decryptLicense(license, publicKeyProvider);
            String openLicense = license.getLicenseInformationAsString();
            if (openLicense.equals(decryptedLicense)) {
                if (this.isLicenseInValidDateRange(license)) {
                    if (this.isMaprenderBuildTimestampOk(license, buildDate)) {
                        this.log.info("isLicenseValid: license is valid");
                        this.log.info("isLicenseValid: license valid until: " + license.getLicense().getSource().getMandatory().getEndDate());
                        this.log.info("isLicenseValid: license owner: " + license.getLicense().getSource().getMandatory().getCustomer());
                        this.log.info("isLicenseValid: license owner ID: " + license.getLicense().getSource().getMandatory().getCustomerId());
                        this.log.info("isLicenseValid: license owner mail: " + license.getLicense().getSource().getMandatory().getEmail());
                        Optional<LicenseConfigurationOptional> optionalLicenseConfigurations = license.getOptionalLicenseEntries();
                        if (optionalLicenseConfigurations.isPresent()) {
                            for (LicenseConfigurationEntry optionalEntry : optionalLicenseConfigurations.get().getEntries()) {
                                this.log.info("isLicenseValid: license optional entry: " + optionalEntry.getName() + " = " + optionalEntry.getValue());
                            }
                        }
                        return license;
                    }
                    this.log.error("isLicenseValid: license is not valid: the currently use maprender was released after this license expired. Therefore the license must be invalid.");
                    this.log.error("isLicenseValid: license end date:     " + license.getLicense().getSource().getMandatory().getEndDate());
                    this.log.error("isLicenseValid: maprender build date: " + DDMMYYYY_Format.format(buildDate));
                    throw new LicenseException("Invalid license");
                }
                this.log.error("isLicenseValid: license is not valid: the system is not in the licensed date range.");
                this.log.error("isLicenseValid: license start date: " + license.getLicense().getSource().getMandatory().getStartDate());
                this.log.error("isLicenseValid: license end date:   " + license.getLicense().getSource().getMandatory().getEndDate());
                throw new LicenseException("Invalid license");
            }
            this.log.error("isLicenseValid: license is not valid: open information and encrypted information does not match. Manually updating the license file will corrupt it.");
            this.log.error("isLicenseValid: open license information:      " + openLicense);
            this.log.error("isLicenseValid: encrypted license information: " + decryptedLicense);
            throw new LicenseException("Invalid license");
        }
        catch (Exception e) {
            this.log.error("isLicenseValid: exception during decryption of license", (Throwable)e);
            throw new LicenseException(e);
        }
    }

    private boolean isLicenseInValidDateRange(LicenseContainer license) throws Exception {
        String startDateString = license.getLicense().getSource().getMandatory().getStartDate();
        Date startDate = DDMMYYYY_Format.parse(startDateString);
        long startTimestamp = startDate.getTime();
        String endDateString = license.getLicense().getSource().getMandatory().getEndDate();
        Date endDate = DDMMYYYY_Format.parse(endDateString);
        long oneDay = 86400000L;
        long endTimestamp = endDate.getTime() + oneDay;
        long currentSystemTime = System.currentTimeMillis();
        boolean isValid = false;
        if (startTimestamp <= currentSystemTime && currentSystemTime <= endTimestamp) {
            isValid = true;
        }
        return isValid;
    }

    private boolean isMaprenderBuildTimestampOk(LicenseContainer license, Date buildDate) throws Exception {
        String endDateString = license.getLicense().getSource().getMandatory().getEndDate();
        Date endDate = DDMMYYYY_Format.parse(endDateString);
        long oneDay = 86400000L;
        long endTimestamp = endDate.getTime() + oneDay;
        long buildTimestamp = buildDate.getTime();
        boolean isValid = false;
        if (buildTimestamp <= endTimestamp) {
            isValid = true;
        }
        return isValid;
    }
}

