/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import org.openstreetmap.josm.io.UrlPattern;

public final class UrlPatterns {
    private static final String HTTPS = "https?://";
    private static final String COMPRESSED = "(gz|xz|bz2?|zip)";

    private UrlPatterns() {
    }

    public static enum OsmUrlPattern implements UrlPattern
    {
        OSM_API_URL(".*/api/0.6/(map|nodes?|ways?|relations?|\\*).*"),
        OVERPASS_API_URL(".*/interpreter\\?data=.*"),
        OVERPASS_API_XAPI_URL(".*/xapi(\\?.*\\[@meta\\]|_meta\\?).*"),
        EXTERNAL_OSM_FILE(".*/(.*\\.osm)"),
        EXTERNAL_COMPRESSED_FILE(".*/(.*\\.osm\\.(gz|xz|bz2?|zip))");

        private final String urlPattern;

        private OsmUrlPattern(String urlPattern) {
            this.urlPattern = UrlPatterns.HTTPS + urlPattern;
        }

        @Override
        public String pattern() {
            return this.urlPattern;
        }
    }

    public static enum OsmChangeUrlPattern implements UrlPattern
    {
        OSM_WEBSITE("www\\.(osm|openstreetmap)\\.org/changeset/(\\p{Digit}+).*"),
        OSM_API(".*/api/0.6/changeset/\\p{Digit}+/download"),
        EXTERNAL_OSC_FILE(".*/(.*\\.osc)"),
        EXTERNAL_COMPRESSED_FILE(".*/(.*\\.osc.(gz|xz|bz2?|zip))");

        private final String urlPattern;

        private OsmChangeUrlPattern(String urlPattern) {
            this.urlPattern = UrlPatterns.HTTPS + urlPattern;
        }

        @Override
        public String pattern() {
            return this.urlPattern;
        }
    }

    public static enum NoteUrlPattern implements UrlPattern
    {
        API_URL(".*/api/0.6/notes.*"),
        DUMP_FILE(".*/(.*\\.osn(\\.(gz|xz|bz2?|zip))?)");

        private final String urlPattern;

        private NoteUrlPattern(String urlPattern) {
            this.urlPattern = UrlPatterns.HTTPS + urlPattern;
        }

        @Override
        public String pattern() {
            return this.urlPattern;
        }
    }

    public static enum GpxUrlPattern implements UrlPattern
    {
        TRACE_ID(".*(osm|openstreetmap).org/trace/\\p{Digit}+/data"),
        USER_TRACE_ID(".*(osm|openstreetmap).org/user/[^/]+/traces/(\\p{Digit}+)"),
        EDIT_TRACE_ID(".*(osm|openstreetmap).org/edit/?\\?gpx=(\\p{Digit}+)(#.*)?"),
        TRACKPOINTS_BBOX(".*/api/0.6/trackpoints\\?bbox=.*,.*,.*,.*"),
        TASKING_MANAGER(".*/api/v\\p{Digit}+/projects?/\\p{Digit}+/(tasks_as_gpx?.*|tasks/queries/gpx/\\?tasks=.*)"),
        EXTERNAL_GPX_SCRIPT(".*exportgpx.*"),
        EXTERNAL_GPX_FILE(".*/(.*\\.gpx)");

        private final String urlPattern;

        private GpxUrlPattern(String urlPattern) {
            this.urlPattern = UrlPatterns.HTTPS + urlPattern;
        }

        @Override
        public String pattern() {
            return this.urlPattern;
        }

        public static boolean isGpxFromServer(String url) {
            return TRACE_ID.matches(url) || TRACKPOINTS_BBOX.matches(url);
        }
    }

    public static enum GeoJsonUrlPattern implements UrlPattern
    {
        COMPRESSED_FILE(".*/(.*\\.(json|geojson)(\\.(gz|xz|bz2?|zip))?)"),
        FORMAT_GEOJSON(".*format=geojson.*");

        private final String urlPattern;

        private GeoJsonUrlPattern(String urlPattern) {
            this.urlPattern = UrlPatterns.HTTPS + urlPattern;
        }

        @Override
        public String pattern() {
            return this.urlPattern;
        }
    }
}

