/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.RelationToChildReference;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.PrimitiveRenderer;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class DeleteFromRelationConfirmationDialog
extends JDialog
implements TableModelListener {
    private static DeleteFromRelationConfirmationDialog instance;
    private RelationMemberTableModel model;
    private final HtmlPanel htmlPanel = new HtmlPanel();
    private boolean canceled;
    private final JButton btnOK = new JButton(new OKAction());

    public static synchronized DeleteFromRelationConfirmationDialog getInstance() {
        if (instance == null) {
            instance = new DeleteFromRelationConfirmationDialog();
        }
        return instance;
    }

    protected JPanel buildRelationMemberTablePanel() {
        JTable table = new JTable(this.model, new RelationMemberTableColumnModel());
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add(new JScrollPane(table));
        return pnl;
    }

    protected JPanel buildButtonPanel() {
        JPanel pnl = new JPanel(new FlowLayout());
        pnl.add(this.btnOK);
        this.btnOK.setFocusable(true);
        pnl.add(new JButton(new CancelAction()));
        pnl.add(new JButton(new ContextSensitiveHelpAction(HelpUtil.ht("/Action/Delete#DeleteFromRelations"))));
        return pnl;
    }

    protected final void build() {
        this.model = new RelationMemberTableModel();
        this.model.addTableModelListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.htmlPanel, "North");
        this.getContentPane().add((Component)this.buildRelationMemberTablePanel(), "Center");
        this.getContentPane().add((Component)this.buildButtonPanel(), "South");
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("/Action/Delete#DeleteFromRelations"));
        this.addWindowListener(new WindowEventHandler());
    }

    protected void updateMessage() {
        int numObjectsToDelete = this.model.getNumObjectsToDelete();
        int numParentRelations = this.model.getNumParentRelations();
        String msg1 = I18n.trn("Please confirm to remove <strong>{0} object</strong>.", "Please confirm to remove <strong>{0} objects</strong>.", numObjectsToDelete, numObjectsToDelete);
        String msg2 = I18n.trn("{0} relation is affected.", "{0} relations are affected.", numParentRelations, numParentRelations);
        String msg = "<html>" + msg1 + ' ' + msg2 + "</html>";
        this.htmlPanel.getEditorPane().setText(msg);
        this.invalidate();
    }

    protected void updateTitle() {
        int numObjectsToDelete = this.model.getNumObjectsToDelete();
        if (numObjectsToDelete > 0) {
            this.setTitle(I18n.trn("Deleting {0} object", "Deleting {0} objects", numObjectsToDelete, numObjectsToDelete));
        } else {
            this.setTitle(I18n.tr("Delete objects", new Object[0]));
        }
    }

    public DeleteFromRelationConfirmationDialog() {
        super((Window)GuiHelper.getFrameForComponent(MainApplication.getMainFrame()), "", Dialog.ModalityType.DOCUMENT_MODAL);
        this.build();
    }

    public RelationMemberTableModel getModel() {
        return this.model;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    protected void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(MainApplication.getMainFrame(), new Dimension(400, 200))).applySafe(this);
            this.setCanceled(false);
        } else if (this.isShowing()) {
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(visible);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.updateMessage();
        this.updateTitle();
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            DeleteFromRelationConfirmationDialog.this.setCanceled(true);
        }

        @Override
        public void windowOpened(WindowEvent e) {
            DeleteFromRelationConfirmationDialog.this.btnOK.requestFocusInWindow();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", I18n.tr("Cancel", new Object[0]));
            new ImageProvider("cancel").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Click to close the dialog and to abort deleting the objects", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DeleteFromRelationConfirmationDialog.this.setCanceled(true);
            DeleteFromRelationConfirmationDialog.this.setVisible(false);
        }
    }

    class OKAction
    extends AbstractAction {
        OKAction() {
            this.putValue("Name", I18n.tr("OK", new Object[0]));
            new ImageProvider("ok").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Click to close the dialog and remove the object from the relations", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DeleteFromRelationConfirmationDialog.this.setCanceled(false);
            DeleteFromRelationConfirmationDialog.this.setVisible(false);
        }
    }

    private static class RelationMemberTableColumnModel
    extends DefaultTableColumnModel {
        protected final void createColumns() {
            TableColumn col = new TableColumn(0);
            col.setHeaderValue(I18n.tr("To delete", new Object[0]));
            col.setResizable(true);
            col.setWidth(100);
            col.setPreferredWidth(100);
            col.setCellRenderer(new PrimitiveRenderer());
            this.addColumn(col);
            col = new TableColumn(1);
            col.setHeaderValue(I18n.tr("From Relation", new Object[0]));
            col.setResizable(true);
            col.setWidth(100);
            col.setPreferredWidth(100);
            col.setCellRenderer(new PrimitiveRenderer());
            this.addColumn(col);
            col = new TableColumn(2);
            col.setHeaderValue(I18n.tr("Pos.", new Object[0]));
            col.setResizable(true);
            col.setWidth(30);
            col.setPreferredWidth(30);
            this.addColumn(col);
            col = new TableColumn(3);
            col.setHeaderValue(I18n.tr("Role", new Object[0]));
            col.setResizable(true);
            col.setWidth(50);
            col.setPreferredWidth(50);
            this.addColumn(col);
        }

        RelationMemberTableColumnModel() {
            this.createColumns();
        }
    }

    public static class RelationMemberTableModel
    extends DefaultTableModel {
        private final transient List<RelationToChildReference> data = new ArrayList<RelationToChildReference>();

        @Override
        public int getRowCount() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        public void populate(Collection<RelationToChildReference> references) {
            this.data.clear();
            if (references != null) {
                this.data.addAll(references);
            }
            this.data.sort(new RelationToChildReferenceComparator());
            this.fireTableDataChanged();
        }

        public Set<OsmPrimitive> getObjectsToDelete() {
            HashSet<OsmPrimitive> ret = new HashSet<OsmPrimitive>();
            for (RelationToChildReference ref : this.data) {
                ret.add(ref.getChild());
            }
            return ret;
        }

        public int getNumObjectsToDelete() {
            return this.getObjectsToDelete().size();
        }

        public Set<OsmPrimitive> getParentRelations() {
            HashSet<OsmPrimitive> ret = new HashSet<OsmPrimitive>();
            for (RelationToChildReference ref : this.data) {
                ret.add(ref.getParent());
            }
            return ret;
        }

        public int getNumParentRelations() {
            return this.getParentRelations().size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.data == null) {
                return null;
            }
            RelationToChildReference ref = this.data.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return ref.getChild();
                }
                case 1: {
                    return ref.getParent();
                }
                case 2: {
                    return ref.getPosition() + 1;
                }
                case 3: {
                    return ref.getRole();
                }
            }
            assert (false) : "Illegal column index";
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        private static class RelationToChildReferenceComparator
        implements Comparator<RelationToChildReference>,
        Serializable {
            private static final long serialVersionUID = 1L;

            private RelationToChildReferenceComparator() {
            }

            @Override
            public int compare(RelationToChildReference o1, RelationToChildReference o2) {
                DefaultNameFormatter nf = DefaultNameFormatter.getInstance();
                int cmp = o1.getChild().getDisplayName(nf).compareTo(o2.getChild().getDisplayName(nf));
                if (cmp != 0) {
                    return cmp;
                }
                cmp = o1.getParent().getDisplayName(nf).compareTo(o2.getParent().getDisplayName(nf));
                if (cmp != 0) {
                    return cmp;
                }
                return Integer.compare(o1.getPosition(), o2.getPosition());
            }
        }
    }
}

