/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.disk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.jcs.auxiliary.AbstractAuxiliaryCacheEventLogging;
import org.apache.commons.jcs.auxiliary.disk.PurgatoryElement;
import org.apache.commons.jcs.auxiliary.disk.behavior.IDiskCacheAttributes;
import org.apache.commons.jcs.engine.CacheEventQueueFactory;
import org.apache.commons.jcs.engine.CacheInfo;
import org.apache.commons.jcs.engine.CacheStatus;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.ICacheEventQueue;
import org.apache.commons.jcs.engine.behavior.ICacheListener;
import org.apache.commons.jcs.engine.behavior.ICacheType;
import org.apache.commons.jcs.engine.stats.StatElement;
import org.apache.commons.jcs.engine.stats.Stats;
import org.apache.commons.jcs.engine.stats.behavior.IStats;
import org.apache.commons.jcs.utils.struct.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractDiskCache<K, V>
extends AbstractAuxiliaryCacheEventLogging<K, V> {
    private static final Log log = LogFactory.getLog(AbstractDiskCache.class);
    private IDiskCacheAttributes diskCacheAttributes = null;
    private Map<K, PurgatoryElement<K, V>> purgatory;
    private ICacheEventQueue<K, V> cacheEventQueue;
    private boolean alive = false;
    private String cacheName;
    private int purgHits = 0;
    private final ReentrantReadWriteLock removeAllLock = new ReentrantReadWriteLock();

    protected AbstractDiskCache(IDiskCacheAttributes attr) {
        this.diskCacheAttributes = attr;
        this.cacheName = attr.getCacheName();
        CacheEventQueueFactory fact = new CacheEventQueueFactory();
        this.cacheEventQueue = fact.createCacheEventQueue(new MyCacheListener(), CacheInfo.listenerId, this.cacheName, this.diskCacheAttributes.getEventQueuePoolName(), this.diskCacheAttributes.getEventQueueType());
        this.initPurgatory();
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void setAlive(boolean alive) {
        this.alive = alive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPurgatory() {
        this.removeAllLock.writeLock().lock();
        try {
            AbstractDiskCache abstractDiskCache = this;
            synchronized (abstractDiskCache) {
                this.purgatory = this.diskCacheAttributes.getMaxPurgatorySize() >= 0 ? new LRUMap<K, PurgatoryElement<K, V>>(this.diskCacheAttributes.getMaxPurgatorySize()) : new HashMap<K, PurgatoryElement<K, V>>();
            }
        }
        finally {
            this.removeAllLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void update(ICacheElement<K, V> cacheElement) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Putting element in purgatory, cacheName: " + this.cacheName + ", key: " + cacheElement.getKey());
        }
        try {
            PurgatoryElement<K, V> pe = new PurgatoryElement<K, V>(cacheElement);
            pe.setSpoolable(true);
            Map<K, PurgatoryElement<K, V>> map = this.purgatory;
            synchronized (map) {
                this.purgatory.put(pe.getKey(), pe);
            }
            this.cacheEventQueue.addPutEvent(pe);
        }
        catch (IOException ex) {
            log.error("Problem adding put event to queue.", ex);
            this.cacheEventQueue.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ICacheElement<K, V> get(K key) {
        if (!this.alive) {
            if (log.isDebugEnabled()) {
                log.debug("get was called, but the disk cache is not alive.");
            }
            return null;
        }
        PurgatoryElement<K, V> pe = null;
        Map<K, PurgatoryElement<K, V>> map = this.purgatory;
        synchronized (map) {
            pe = this.purgatory.get(key);
        }
        if (pe != null) {
            ++this.purgHits;
            if (log.isDebugEnabled() && this.purgHits % 100 == 0) {
                log.debug("Purgatory hits = " + this.purgHits);
            }
            if (log.isDebugEnabled()) {
                log.debug("Found element in purgatory, cacheName: " + this.cacheName + ", key: " + key);
            }
            return pe.getCacheElement();
        }
        try {
            return this.doGet(key);
        }
        catch (Exception e) {
            log.error(e);
            this.cacheEventQueue.destroy();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<K, ICacheElement<K, V>> getMatching(String pattern) throws IOException {
        HashSet<K> keyArray = null;
        Map<K, PurgatoryElement<K, V>> map = this.purgatory;
        synchronized (map) {
            keyArray = new HashSet<K>(this.purgatory.keySet());
        }
        Set matchingKeys = this.getKeyMatcher().getMatchingKeysFromArray(pattern, keyArray);
        Map<K, ICacheElement<K, ICacheElement<K, V>>> result = this.processGetMultiple(matchingKeys);
        Map<K, ICacheElement<K, V>> diskMatches = this.doGetMatching(pattern);
        result.putAll(diskMatches);
        return result;
    }

    @Override
    public abstract Set<K> getKeySet() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean remove(K key) throws IOException {
        PurgatoryElement<K, V> pe = null;
        Object object = this.purgatory;
        synchronized (object) {
            pe = this.purgatory.get(key);
        }
        if (pe != null) {
            object = pe.getCacheElement();
            synchronized (object) {
                Map<K, PurgatoryElement<K, V>> map = this.purgatory;
                synchronized (map) {
                    this.purgatory.remove(key);
                }
                pe.setSpoolable(false);
                this.doRemove(key);
            }
        }
        this.doRemove(key);
        return false;
    }

    @Override
    public final void removeAll() throws IOException {
        if (this.diskCacheAttributes.isAllowRemoveAll()) {
            this.initPurgatory();
            this.doRemoveAll();
        } else if (log.isInfoEnabled()) {
            log.info("RemoveAll was requested but the request was not fulfilled: allowRemoveAll is set to false.");
        }
    }

    @Override
    public final void dispose() throws IOException {
        Thread t = new Thread(() -> {
            boolean keepGoing = true;
            long interval = 100L;
            while (keepGoing) {
                keepGoing = !this.cacheEventQueue.isEmpty();
                try {
                    Thread.sleep(interval);
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            log.info("No longer waiting for event queue to finish: " + this.cacheEventQueue.getStatistics());
        });
        t.start();
        try {
            t.join((long)this.diskCacheAttributes.getShutdownSpoolTimeLimit() * 1000L);
        }
        catch (InterruptedException ex) {
            log.error("The Shutdown Spool Process was interrupted.", ex);
        }
        log.info("In dispose, destroying event queue.");
        this.cacheEventQueue.destroy();
        this.doDispose();
        this.alive = false;
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    @Override
    public String getStats() {
        return this.getStatistics().toString();
    }

    @Override
    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Abstract Disk Cache");
        ArrayList elems = new ArrayList();
        elems.add(new StatElement<Integer>("Purgatory Hits", this.purgHits));
        elems.add(new StatElement<Integer>("Purgatory Size", this.purgatory.size()));
        IStats eqStats = this.cacheEventQueue.getStatistics();
        elems.addAll(eqStats.getStatElements());
        stats.setStatElements(elems);
        return stats;
    }

    @Override
    public CacheStatus getStatus() {
        return this.alive ? CacheStatus.ALIVE : CacheStatus.DISPOSED;
    }

    @Override
    public abstract int getSize();

    @Override
    public ICacheType.CacheType getCacheType() {
        return ICacheType.CacheType.DISK_CACHE;
    }

    protected final ICacheElement<K, V> doGet(K key) throws IOException {
        return super.getWithEventLogging(key);
    }

    protected final Map<K, ICacheElement<K, V>> doGetMatching(String pattern) throws IOException {
        return super.getMatchingWithEventLogging(pattern);
    }

    protected final void doUpdate(ICacheElement<K, V> cacheElement) throws IOException {
        super.updateWithEventLogging(cacheElement);
    }

    protected final boolean doRemove(K key) throws IOException {
        return super.removeWithEventLogging(key);
    }

    protected final void doRemoveAll() throws IOException {
        super.removeAllWithEventLogging();
    }

    protected final void doDispose() throws IOException {
        super.disposeWithEventLogging();
    }

    @Override
    public String getEventLoggingExtraInfo() {
        return this.getDiskLocation();
    }

    protected abstract String getDiskLocation();

    protected class MyCacheListener
    implements ICacheListener<K, V> {
        private long listenerId = 0L;

        protected MyCacheListener() {
        }

        @Override
        public long getListenerId() throws IOException {
            return this.listenerId;
        }

        @Override
        public void setListenerId(long id) throws IOException {
            this.listenerId = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handlePut(ICacheElement<K, V> element) throws IOException {
            if (AbstractDiskCache.this.alive) {
                if (element instanceof PurgatoryElement) {
                    PurgatoryElement pe = (PurgatoryElement)element;
                    ICacheElement iCacheElement = pe.getCacheElement();
                    synchronized (iCacheElement) {
                        Map map;
                        AbstractDiskCache.this.removeAllLock.readLock().lock();
                        try {
                            map = AbstractDiskCache.this.purgatory;
                            synchronized (map) {
                                block21: {
                                    if (AbstractDiskCache.this.purgatory.containsKey(pe.getKey())) break block21;
                                    return;
                                }
                                element = pe.getCacheElement();
                            }
                            if (pe.isSpoolable()) {
                                AbstractDiskCache.this.doUpdate(element);
                            }
                        }
                        finally {
                            AbstractDiskCache.this.removeAllLock.readLock().unlock();
                        }
                        map = AbstractDiskCache.this.purgatory;
                        synchronized (map) {
                            AbstractDiskCache.this.purgatory.remove(element.getKey());
                        }
                    }
                }
                AbstractDiskCache.this.doUpdate(element);
            } else {
                Map map = AbstractDiskCache.this.purgatory;
                synchronized (map) {
                    AbstractDiskCache.this.purgatory.remove(element.getKey());
                }
            }
        }

        @Override
        public void handleRemove(String cacheName, K key) throws IOException {
            if (AbstractDiskCache.this.alive && AbstractDiskCache.this.doRemove(key)) {
                log.debug("Element removed, key: " + key);
            }
        }

        @Override
        public void handleRemoveAll(String cacheName) throws IOException {
            if (AbstractDiskCache.this.alive) {
                AbstractDiskCache.this.doRemoveAll();
            }
        }

        @Override
        public void handleDispose(String cacheName) throws IOException {
            if (AbstractDiskCache.this.alive) {
                AbstractDiskCache.this.doDispose();
            }
        }
    }
}

