/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.startup;

import de.wideportal.maprender.config.ConfigurationException;
import de.wideportal.maprender.datasource.DatasourceException;
import de.wideportal.maprender.renderer.progress.RenderProgressTrackingVerifier;
import de.wideportal.maprender.request.RenderManager;
import de.wideportal.maprender.server.EmbeddedJettyServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRender {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private RenderManager renderManager;

    public static void main(String[] args) {
        MapRender mapRender = new MapRender();
        mapRender.init(args);
    }

    private void verifyRenderProgress(String[] args) {
        try {
            RenderProgressTrackingVerifier renderProgressTrackingVerifier = new RenderProgressTrackingVerifier();
            renderProgressTrackingVerifier.verify(this.getConfigurationFile(args));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    private void init(String[] args) {
        this.log.warn("init: starting maprender");
        this.renderManager = RenderManager.getSingleton();
        if (this.isArgsEmpty(args)) {
            System.out.println("MapRender: you need to provide at least the following configuration:");
            System.out.println("maprender.jar -c <configfile>");
            System.exit(0);
        }
        try {
            String watermarkCheckFile = this.getWatermarkCheckFile(args);
            if (watermarkCheckFile != null) {
                this.renderManager.checkWatermark(watermarkCheckFile);
                this.log.warn("init: checked watermark, now exiting.");
                return;
            }
            String configurationFile = this.getConfigurationFile(args);
            EmbeddedJettyServer jettyServer = new EmbeddedJettyServer();
            jettyServer.startServer(configurationFile, this.renderManager);
            this.renderManager.setEmbeddedJettyServer(jettyServer);
            String licenseFile = this.getLicenseFile(args);
            this.renderManager.startRendering(configurationFile, licenseFile);
        }
        catch (ConfigurationException ce) {
            System.out.println("MapRender: could not start MapRender due to a configuration problem:");
            System.out.println(ce.getMessage());
        }
        catch (DatasourceException de) {
            System.out.println("MapRender: could not start MapRender because of problems with datasource:");
            System.out.println(de.getMessage());
        }
    }

    private boolean isArgsEmpty(String[] args) {
        return args == null || args.length == 0;
    }

    private String getConfigurationFile(String[] args) throws ConfigurationException {
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null || !args[i].equals("-c")) continue;
            if (args.length >= i + 1 && args[i + 1] != null) {
                if (args[i + 1].trim().isEmpty()) {
                    throw new ConfigurationException("You need to provide a nonempty file name for the configuration file");
                }
                return args[i + 1];
            }
            throw new ConfigurationException("You need to provide a nonempty file name for the configuration file");
        }
        throw new ConfigurationException("You need to provide a configuration file");
    }

    private String getLicenseFile(String[] args) throws ConfigurationException {
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null || !args[i].equals("-l")) continue;
            if (args.length >= i + 1 && args[i + 1] != null) {
                if (args[i + 1].trim().isEmpty()) {
                    throw new ConfigurationException("You need to provide a nonempty file name for the license file");
                }
                return args[i + 1];
            }
            throw new ConfigurationException("You need to provide a nonempty file name for the license file");
        }
        return null;
    }

    private String getWatermarkCheckFile(String[] args) throws ConfigurationException {
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null || !args[i].equals("-w")) continue;
            if (args.length >= i + 1 && args[i + 1] != null) {
                if (args[i + 1].trim().isEmpty()) {
                    throw new ConfigurationException("You need to provide a nonempty file name for the watermark file");
                }
                return args[i + 1];
            }
            throw new ConfigurationException("You need to provide a nonempty file name for the watermark file");
        }
        return null;
    }
}

