/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.srtm.algos;

import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.renderer.buffer.BooleanArrayBuffer;
import de.wideportal.maprender.resources.srtm.SrtmLinePointsContainer;
import de.wideportal.maprender.resources.srtm.algos.PointGroupAlgo;
import de.wideportal.maprender.resources.srtm.algos.PointGroupHull;
import java.util.ArrayList;

public class PointGroupHullFinderAlgo
extends PointGroupAlgo {
    public static final int LEFT_HANDED = 0;
    public static final int RIGHT_HANDED = 1;

    public static void removeHullContents(BooleanArrayBuffer cellOnLineBuffer, SrtmLinePointsContainer linePointsContainer, int z, long tileSize) {
        for (ArrayList<Point> group : linePointsContainer.getGroups()) {
            int k;
            Point currentPoint;
            PointGroupHull hull;
            Point startCircleScanPoint;
            Point startingPoint;
            ArrayList<Point> tileBorderCrossings = PointGroupHullFinderAlgo.getGroupTileBorderCrossings(group, tileSize);
            if (tileBorderCrossings.size() == 0) {
                startingPoint = PointGroupHullFinderAlgo.getLeftMostPoint(group);
                startCircleScanPoint = new Point(startingPoint.getX() - 1.0, startingPoint.getY());
                hull = PointGroupHullFinderAlgo.getGroupOuterHull(cellOnLineBuffer, linePointsContainer, group, startingPoint, startCircleScanPoint, 1, z, tileSize);
                for (int k2 = group.size() - 1; k2 >= 0; --k2) {
                    currentPoint = group.get(k2);
                    if (hull.getHullPoints().contains(currentPoint)) continue;
                    group.remove(k2);
                    cellOnLineBuffer.setValue((int)currentPoint.getX(), (int)currentPoint.getY(), z, false);
                }
                continue;
            }
            if (tileBorderCrossings.size() == 1) {
                startingPoint = tileBorderCrossings.get(0);
                startCircleScanPoint = PointGroupHullFinderAlgo.getStartpointForBorderCrossing(startingPoint, tileSize);
                hull = PointGroupHullFinderAlgo.getGroupOuterHull(cellOnLineBuffer, linePointsContainer, group, startingPoint, startCircleScanPoint, 1, z, tileSize);
                for (int k3 = group.size() - 1; k3 >= 0; --k3) {
                    currentPoint = group.get(k3);
                    if (hull.getHullPoints().contains(currentPoint)) continue;
                    group.remove(k3);
                    cellOnLineBuffer.setValue((int)currentPoint.getX(), (int)currentPoint.getY(), z, false);
                }
                continue;
            }
            if (tileBorderCrossings.size() != 2) continue;
            startingPoint = tileBorderCrossings.get(0);
            startCircleScanPoint = PointGroupHullFinderAlgo.getStartpointForBorderCrossing(startingPoint, tileSize);
            PointGroupHull hullLeftHanded = PointGroupHullFinderAlgo.getGroupOuterHull(cellOnLineBuffer, linePointsContainer, group, startingPoint, startCircleScanPoint, 0, z, tileSize);
            PointGroupHull hullRightHanded = PointGroupHullFinderAlgo.getGroupOuterHull(cellOnLineBuffer, linePointsContainer, group, startingPoint, startCircleScanPoint, 1, z, tileSize);
            PointGroupHull longestHull = null;
            longestHull = hullLeftHanded.getHullPoints().size() > hullRightHanded.getHullPoints().size() ? hullLeftHanded : hullRightHanded;
            for (k = group.size() - 1; k >= 0; --k) {
                Point currentPoint2 = group.get(k);
                if (longestHull.getHullPoints().contains(currentPoint2)) continue;
                group.remove(k);
                cellOnLineBuffer.setValue((int)currentPoint2.getX(), (int)currentPoint2.getY(), z, false);
            }
            for (k = 0; k < longestHull.getMultipleUsedPoints().size(); ++k) {
                Point multipleUsedPoint = longestHull.getMultipleUsedPoints().get(k);
                int touchingPointsCount = PointGroupHullFinderAlgo.getTouchingPointsCount(longestHull.getHullPoints(), multipleUsedPoint);
                if (touchingPointsCount >= 3) continue;
                group.remove(multipleUsedPoint);
                cellOnLineBuffer.setValue((int)multipleUsedPoint.getX(), (int)multipleUsedPoint.getY(), z, false);
            }
        }
    }

    private static int getTouchingPointsCount(ArrayList<Point> points, Point referencePoint) {
        ArrayList<Point> touchingPoints = new ArrayList<Point>();
        for (Point point : points) {
            if (point.equals(referencePoint) || touchingPoints.contains(point) || !(point.getDistance(referencePoint) < 2.0)) continue;
            touchingPoints.add(point);
        }
        return touchingPoints.size();
    }

    private static PointGroupHull getGroupOuterHull(BooleanArrayBuffer cellOnLineBuffer, SrtmLinePointsContainer linePointsContainer, ArrayList<Point> group, Point startingPoint, Point startCircleScanPoint, int leftOrRightHanded, int z, long tileSize) {
        PointGroupHull hull = new PointGroupHull(leftOrRightHanded);
        ArrayList<Point> hullPoints = hull.getHullPoints();
        ArrayList<Point> multipleUsedPoints = hull.getMultipleUsedPoints();
        hullPoints.add(startingPoint);
        Point previousPoint = startCircleScanPoint;
        Point currentPoint = startingPoint;
        Point nextPoint = null;
        do {
            if ((nextPoint = PointGroupHullFinderAlgo.findNextPoint(cellOnLineBuffer, group, currentPoint, previousPoint, z, leftOrRightHanded, tileSize)) == null) continue;
            if (nextPoint == previousPoint) break;
            if (hullPoints.contains(nextPoint) && !multipleUsedPoints.contains(nextPoint) && !nextPoint.equals(startingPoint)) {
                multipleUsedPoints.add(nextPoint);
            }
            hullPoints.add(nextPoint);
            if (nextPoint == startingPoint) break;
            previousPoint = currentPoint;
            currentPoint = nextPoint;
        } while (nextPoint != null);
        return hull;
    }

    public static Point findNextPoint(BooleanArrayBuffer cellOnLineBuffer, ArrayList<Point> group, Point currentPoint, Point lastPoint, int z, int leftOrRightHanded, long tileSize) {
        if (leftOrRightHanded == 0) {
            boolean startPointFound = false;
            for (int i = 0; i < 18; ++i) {
                double searchY;
                double searchX;
                int direction = i % 9;
                if (direction == 7) {
                    searchX = currentPoint.getX() - 1.0;
                    if (PointGroupHullFinderAlgo.isInsideTile(searchX, searchY = currentPoint.getY(), tileSize) && startPointFound && cellOnLineBuffer.getValue((int)searchX, (int)searchY, z)) {
                        return PointGroupHullFinderAlgo.findPointInGroup(group, searchX, searchY);
                    }
                    if (!lastPoint.hasCoordinates(searchX, searchY)) continue;
                    startPointFound = true;
                    continue;
                }
                if (direction == 6) {
                    searchX = currentPoint.getX() - 1.0;
                    if (PointGroupHullFinderAlgo.isInsideTile(searchX, searchY = currentPoint.getY() + 1.0, tileSize) && startPointFound && cellOnLineBuffer.getValue((int)searchX, (int)searchY, z)) {
                        return PointGroupHullFinderAlgo.findPointInGroup(group, searchX, searchY);
                    }
                    if (!lastPoint.hasCoordinates(searchX, searchY)) continue;
                    startPointFound = true;
                    continue;
                }
                if (direction == 5) {
                    searchX = currentPoint.getX();
                    if (PointGroupHullFinderAlgo.isInsideTile(searchX, searchY = currentPoint.getY() + 1.0, tileSize) && startPointFound && cellOnLineBuffer.getValue((int)searchX, (int)searchY, z)) {
                        return PointGroupHullFinderAlgo.findPointInGroup(group, searchX, searchY);
                    }
                    if (!lastPoint.hasCoordinates(searchX, searchY)) continue;
                    startPointFound = true;
                    continue;
                }
                if (direction == 4) {
                    searchX = currentPoint.getX() + 1.0;
                    if (PointGroupHullFinderAlgo.isInsideTile(searchX, searchY = currentPoint.getY() + 1.0, tileSize) && startPointFound && cellOnLineBuffer.getValue((int)searchX, (int)searchY, z)) {
                        return PointGroupHullFinderAlgo.findPointInGroup(group, searchX, searchY);
                    }
                    if (!lastPoint.hasCoordinates(searchX, searchY)) continue;
                    startPointFound = true;
                    continue;
                }
                if (direction == 3) {
                    searchX = currentPoint.getX() + 1.0;
                    if (PointGroupHullFinderAlgo.isInsideTile(searchX, searchY = currentPoint.getY(), tileSize) && startPointFound && cellOnLineBuffer.getValue((int)searchX, (int)searchY, z)) {
                        return PointGroupHullFinderAlgo.findPointInGroup(group, searchX, searchY);
                    }
                    if (!lastPoint.hasCoordinates(searchX, searchY)) continue;
                    startPointFound = true;
                    continue;
                }
                if (direction == 2) {
                    searchX = currentPoint.getX() + 1.0;
                    if (PointGroupHullFinderAlgo.isInsideTile(searchX, searchY = currentPoint.getY() - 1.0, tileSize) && startPointFound && cellOnLineBuffer.getValue((int)searchX, (int)searchY, z)) {
                        return PointGroupHullFinderAlgo.findPointInGroup(group, searchX, searchY);
                    }
                    if (!lastPoint.hasCoordinates(searchX, searchY)) continue;
                    startPointFound = true;
                    continue;
                }
                if (direction == 1) {
                    searchX = currentPoint.getX();
                    if (PointGroupHullFinderAlgo.isInsideTile(searchX, searchY = currentPoint.getY() - 1.0, tileSize) && startPointFound && cellOnLineBuffer.getValue((int)searchX, (int)searchY, z)) {
                        return PointGroupHullFinderAlgo.findPointInGroup(group, searchX, searchY);
                    }
                    if (!lastPoint.hasCoordinates(searchX, searchY)) continue;
                    startPointFound = true;
                    continue;
                }
                if (direction != 0) continue;
                searchX = currentPoint.getX() - 1.0;
                if (PointGroupHullFinderAlgo.isInsideTile(searchX, searchY = currentPoint.getY() - 1.0, tileSize) && startPointFound && cellOnLineBuffer.getValue((int)searchX, (int)searchY, z)) {
                    return PointGroupHullFinderAlgo.findPointInGroup(group, searchX, searchY);
                }
                if (!lastPoint.hasCoordinates(searchX, searchY)) continue;
                startPointFound = true;
            }
        } else {
            boolean startPointFound = false;
            for (int i = 17; i >= 0; --i) {
                double searchY;
                double searchX;
                int direction = i % 9;
                if (direction == 7) {
                    searchX = currentPoint.getX() - 1.0;
                    if (PointGroupHullFinderAlgo.isInsideTile(searchX, searchY = currentPoint.getY(), tileSize) && startPointFound && cellOnLineBuffer.getValue((int)searchX, (int)searchY, z)) {
                        return PointGroupHullFinderAlgo.findPointInGroup(group, searchX, searchY);
                    }
                    if (!lastPoint.hasCoordinates(searchX, searchY)) continue;
                    startPointFound = true;
                    continue;
                }
                if (direction == 6) {
                    searchX = currentPoint.getX() - 1.0;
                    if (PointGroupHullFinderAlgo.isInsideTile(searchX, searchY = currentPoint.getY() + 1.0, tileSize) && startPointFound && cellOnLineBuffer.getValue((int)searchX, (int)searchY, z)) {
                        return PointGroupHullFinderAlgo.findPointInGroup(group, searchX, searchY);
                    }
                    if (!lastPoint.hasCoordinates(searchX, searchY)) continue;
                    startPointFound = true;
                    continue;
                }
                if (direction == 5) {
                    searchX = currentPoint.getX();
                    if (PointGroupHullFinderAlgo.isInsideTile(searchX, searchY = currentPoint.getY() + 1.0, tileSize) && startPointFound && cellOnLineBuffer.getValue((int)searchX, (int)searchY, z)) {
                        return PointGroupHullFinderAlgo.findPointInGroup(group, searchX, searchY);
                    }
                    if (!lastPoint.hasCoordinates(searchX, searchY)) continue;
                    startPointFound = true;
                    continue;
                }
                if (direction == 4) {
                    searchX = currentPoint.getX() + 1.0;
                    if (PointGroupHullFinderAlgo.isInsideTile(searchX, searchY = currentPoint.getY() + 1.0, tileSize) && startPointFound && cellOnLineBuffer.getValue((int)searchX, (int)searchY, z)) {
                        return PointGroupHullFinderAlgo.findPointInGroup(group, searchX, searchY);
                    }
                    if (!lastPoint.hasCoordinates(searchX, searchY)) continue;
                    startPointFound = true;
                    continue;
                }
                if (direction == 3) {
                    searchX = currentPoint.getX() + 1.0;
                    if (PointGroupHullFinderAlgo.isInsideTile(searchX, searchY = currentPoint.getY(), tileSize) && startPointFound && cellOnLineBuffer.getValue((int)searchX, (int)searchY, z)) {
                        return PointGroupHullFinderAlgo.findPointInGroup(group, searchX, searchY);
                    }
                    if (!lastPoint.hasCoordinates(searchX, searchY)) continue;
                    startPointFound = true;
                    continue;
                }
                if (direction == 2) {
                    searchX = currentPoint.getX() + 1.0;
                    if (PointGroupHullFinderAlgo.isInsideTile(searchX, searchY = currentPoint.getY() - 1.0, tileSize) && startPointFound && cellOnLineBuffer.getValue((int)searchX, (int)searchY, z)) {
                        return PointGroupHullFinderAlgo.findPointInGroup(group, searchX, searchY);
                    }
                    if (!lastPoint.hasCoordinates(searchX, searchY)) continue;
                    startPointFound = true;
                    continue;
                }
                if (direction == 1) {
                    searchX = currentPoint.getX();
                    if (PointGroupHullFinderAlgo.isInsideTile(searchX, searchY = currentPoint.getY() - 1.0, tileSize) && startPointFound && cellOnLineBuffer.getValue((int)searchX, (int)searchY, z)) {
                        return PointGroupHullFinderAlgo.findPointInGroup(group, searchX, searchY);
                    }
                    if (!lastPoint.hasCoordinates(searchX, searchY)) continue;
                    startPointFound = true;
                    continue;
                }
                if (direction != 0) continue;
                searchX = currentPoint.getX() - 1.0;
                if (PointGroupHullFinderAlgo.isInsideTile(searchX, searchY = currentPoint.getY() - 1.0, tileSize) && startPointFound && cellOnLineBuffer.getValue((int)searchX, (int)searchY, z)) {
                    return PointGroupHullFinderAlgo.findPointInGroup(group, searchX, searchY);
                }
                if (!lastPoint.hasCoordinates(searchX, searchY)) continue;
                startPointFound = true;
            }
        }
        return null;
    }

    private static Point getStartpointForBorderCrossing(Point borderPoint, long tileSize) {
        double x = borderPoint.getX();
        double y = borderPoint.getY();
        if (x == 0.0 && y == 0.0) {
            return new Point(-1.0, -1.0);
        }
        if (x == (double)(tileSize - 1L) && y == 0.0) {
            return new Point(tileSize, y - 1.0);
        }
        if (x == (double)(tileSize - 1L) && y == (double)(tileSize - 1L)) {
            return new Point(tileSize, tileSize);
        }
        if (x == 0.0 && y == (double)(tileSize - 1L)) {
            return new Point(-1.0, tileSize);
        }
        if (y == 0.0) {
            return new Point(x, -1.0);
        }
        if (x == (double)(tileSize - 1L)) {
            return new Point(tileSize, y);
        }
        if (y == (double)(tileSize - 1L)) {
            return new Point(x, tileSize);
        }
        if (x == 0.0) {
            return new Point(-1.0, y);
        }
        return null;
    }

    private static Point getLeftMostPoint(ArrayList<Point> group) {
        Point leftMostPoint = null;
        if (group.size() > 0) {
            leftMostPoint = group.get(0);
            for (Point currentPoint : group) {
                if (!(currentPoint.getX() <= leftMostPoint.getX())) continue;
                leftMostPoint = currentPoint;
            }
        }
        return leftMostPoint;
    }
}

