/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.sqlitedb;

import de.wideportal.maprender.config.xml.RenderConfigurationJob;
import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.request.RenderImage;
import de.wideportal.maprender.request.RenderRequest;
import de.wideportal.maprender.resources.output.IRenderOutputPersister;
import de.wideportal.maprender.resources.sqlitedb.SqLiteDbAccessor;
import de.wideportal.maprender.resources.sqlitedb.SqLiteDbConnector;
import de.wideportal.maprender.resources.sqlitedb.SqLiteDbTableInfo;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqLiteDbPersister
implements IRenderOutputPersister {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private SqLiteDbAccessor accessor = null;

    private BufferedImage removeAlphaChannel(BufferedImage alphaImage) {
        BufferedImage copy = new BufferedImage(alphaImage.getWidth(), alphaImage.getHeight(), 1);
        Graphics2D g2d = copy.createGraphics();
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, copy.getWidth(), copy.getHeight());
        g2d.drawImage((Image)alphaImage, 0, 0, null);
        g2d.dispose();
        return copy;
    }

    @Override
    public synchronized void persistTile(RenderRequest renderRequest) {
        block11: {
            this.initAccessorIfNull(renderRequest);
            if (this.accessor != null) {
                try {
                    double zoom = renderRequest.getZoomInfo().getZoom();
                    int zoomInverted = (int)(17.0 - zoom);
                    int xIndex = (int)renderRequest.getTileIndex().getX();
                    int yIndex = (int)renderRequest.getTileIndex().getY();
                    RenderImage renderImage = renderRequest.getRenderImage();
                    renderImage.mergeLayers();
                    RenderConfigurationJob currentJob = renderRequest.getOsmMap().getJob();
                    String configuredImageType = currentJob.getOutput().getImageType();
                    String configuredImageQuality = currentJob.getOutput().getQuality();
                    String fileType = "png";
                    if (configuredImageType != null) {
                        fileType = configuredImageType;
                    }
                    float quality = 100.0f;
                    if (configuredImageQuality != null) {
                        try {
                            quality = Integer.parseInt(configuredImageQuality);
                        }
                        catch (NumberFormatException e) {
                            this.log.error("persistTile: could not parse the image file quality setting from the output configuration: " + configuredImageQuality + ". Using default: " + quality);
                        }
                    }
                    if ("jpg".equalsIgnoreCase(fileType) || "jpeg".equalsIgnoreCase(fileType)) {
                        BufferedImage alphaLessImage = this.removeAlphaChannel(renderImage.getBaseLayer().getImage());
                        JPEGImageWriteParam jpegParams = new JPEGImageWriteParam(null);
                        jpegParams.setCompressionMode(2);
                        jpegParams.setCompressionQuality(quality / 100.0f);
                        ImageWriter writer = ImageIO.getImageWritersByFormatName("jpg").next();
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        ImageOutputStream ios = ImageIO.createImageOutputStream(baos);
                        writer.setOutput(ios);
                        writer.write(null, new IIOImage(alphaLessImage, null, null), jpegParams);
                        byte[] imageBytes = baos.toByteArray();
                        this.accessor.addTile(xIndex, yIndex, zoomInverted, 1, imageBytes);
                        imageBytes = null;
                        ios.close();
                        baos.close();
                        break block11;
                    }
                    if ("png".equalsIgnoreCase(fileType)) {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        ImageIO.write((RenderedImage)renderImage.getBaseLayer().getImage(), "png", bos);
                        byte[] imageBytes = bos.toByteArray();
                        this.accessor.addTile(xIndex, yIndex, zoomInverted, 1, imageBytes);
                        imageBytes = null;
                        bos.close();
                        break block11;
                    }
                    if ("bmp".equalsIgnoreCase(fileType)) {
                        BufferedImage alphaLessImage = this.removeAlphaChannel(renderImage.getBaseLayer().getImage());
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        ImageIO.write((RenderedImage)alphaLessImage, "bmp", bos);
                        byte[] imageBytes = bos.toByteArray();
                        this.accessor.addTile(xIndex, yIndex, zoomInverted, 1, imageBytes);
                        imageBytes = null;
                        bos.close();
                        break block11;
                    }
                    this.log.error("persistTile: no valid output format specified. Format was: " + fileType);
                }
                catch (Exception e) {
                    this.log.error("persistTile: an unexpected exception occured. Could not save tile.", (Throwable)e);
                }
            } else {
                this.log.error("persistTile: Cannot persist to sqlite db.");
                return;
            }
        }
    }

    private synchronized void initAccessorIfNull(RenderRequest renderRequest) {
        if (this.accessor == null) {
            int provider;
            String zooms;
            BoundingBox bbox;
            int maxZoom;
            int minZoom;
            this.log.info("initAccessorIfNull: initializing sqlite db");
            SqLiteDbConnector connector = (SqLiteDbConnector)renderRequest.getConnectableResourceManager().getConnectableResource(SqLiteDbConnector.class);
            if (connector != null) {
                this.accessor = new SqLiteDbAccessor(connector);
                this.accessor.initTablesIfNecessary();
                int existingMinZoom = Integer.MIN_VALUE;
                int existingMaxZoom = Integer.MAX_VALUE;
                SqLiteDbTableInfo tableInfo = this.accessor.getTableInfo();
                if (tableInfo != null) {
                    existingMinZoom = tableInfo.getMinZoom();
                    existingMaxZoom = tableInfo.getMaxZoom();
                }
                minZoom = 17 - (int)renderRequest.getZoomInfo().getMinZoom();
                maxZoom = 17 - (int)renderRequest.getZoomInfo().getMaxZoom();
                if (existingMinZoom > minZoom) {
                    minZoom = existingMinZoom;
                }
                if (existingMaxZoom < maxZoom) {
                    maxZoom = existingMaxZoom;
                }
                String bboxString = renderRequest.getRenderConfiguration().getMaprenderConfiguration().getBounds().getBoundingbox();
                bbox = new BoundingBox(bboxString);
                ArrayList<CallSite> zoomStrings = new ArrayList<CallSite>();
                for (int i = minZoom; i >= maxZoom; --i) {
                    zoomStrings.add((CallSite)((Object)("" + i)));
                }
                zooms = zoomStrings.stream().collect(Collectors.joining(";"));
                String providerString = renderRequest.getRenderConfiguration().getMaprenderConfiguration().getDatatargets().getSqLiteDb().getProvider();
                provider = 0;
                try {
                    provider = Integer.parseInt(providerString);
                }
                catch (Exception e) {
                    this.log.error("initAccessorIfNull: provider was not configured or is not a number. Falling back to provider id 0");
                }
            } else {
                this.log.error("initAccessorIfNull: could not initialize accessor, connector was null. Cannot persist to sqlite db.");
                return;
            }
            this.accessor.initMetadataIfNecessary("de_DE", minZoom, maxZoom, bbox.getCenter().getY(), bbox.getCenter().getX(), zooms, provider);
            this.log.info("initAccessorIfNull: initialized sqlite db");
        }
    }
}

