/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.output.format;

import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.resources.output.format.AbstractSlippyMapTileOutput;

public class MollweideTiles
extends AbstractSlippyMapTileOutput {
    public static final String NAME = "mollweide";
    private double offsetLat = 0.0;
    private double offsetLon = 0.0;

    public double getOffsetLat() {
        return this.offsetLat;
    }

    public void setOffsetLat(double offsetLat) {
        this.offsetLat = offsetLat;
    }

    public double getOffsetLon() {
        return this.offsetLon;
    }

    public void setOffsetLon(double offsetLon) {
        this.offsetLon = offsetLon;
    }

    @Override
    public String getMapTileOutputName() {
        return NAME;
    }

    @Override
    public double getMeterPerTile(double zoom, double latDegree) {
        return 4.007501668557849E7 * Math.cos(Math.toRadians(latDegree)) / Math.pow(2.0, zoom);
    }

    @Override
    public double getMeterPerPixel(double zoom, double latDegree) {
        return this.getMeterPerTile(zoom, latDegree) / 256.0;
    }

    @Override
    public Point getMinTileIndex(double leftLonDegree, double topLatDegree, double zoom) {
        Point minPixels = this.getLonLatToPixel(leftLonDegree, topLatDegree, zoom);
        double minXPixel = minPixels.getX();
        double minYPixel = minPixels.getY();
        double minXTileIndex = Math.floor(minXPixel / 256.0);
        double minYTileIndex = Math.floor(minYPixel / 256.0);
        if (leftLonDegree == -180.0) {
            minXTileIndex = 0.0;
        }
        return new Point(minXTileIndex, minYTileIndex);
    }

    @Override
    public Point getMaxTileIndex(double rightLonDegree, double bottomLatDegree, double zoom) {
        Point maxPixels = this.getLonLatToPixel(rightLonDegree, bottomLatDegree, zoom);
        double maxXPixel = maxPixels.getX();
        double maxYPixel = maxPixels.getY();
        double maxXTileIndex = Math.floor(maxXPixel / 256.0);
        double maxYTileIndex = Math.floor(maxYPixel / 256.0);
        if (rightLonDegree == 180.0) {
            maxXTileIndex = this.getTileCountPerAxis(zoom);
        }
        return new Point(maxXTileIndex, maxYTileIndex);
    }

    @Override
    public BoundingBox getMinMaxTileBoundingBox(BoundingBox latLonBoundingBox, double zoom) {
        Point minTileIndex = this.getMinTileIndex(latLonBoundingBox.getLeft(), latLonBoundingBox.getTop(), zoom);
        Point maxTileIndex = this.getMaxTileIndex(latLonBoundingBox.getRight(), latLonBoundingBox.getBottom(), zoom);
        return new BoundingBox(minTileIndex, maxTileIndex);
    }

    @Override
    public BoundingBox getBoundingBoxForTile(int zoom, int x, int y) {
        double xLeft = (double)x * 256.0;
        double yTop = (double)y * 256.0;
        double xRight = ((double)x + 1.0) * 256.0;
        double yBottom = ((double)y + 1.0) * 256.0;
        Point lonLatLeftTop = this.getPixelToLonLat(xLeft, yTop, zoom);
        Point lonLatRightBottom = this.getPixelToLonLat(xRight, yBottom, zoom);
        Point lonLatLeftBottom = this.getPixelToLonLat(xLeft, yBottom, zoom);
        Point lonLatRightTop = this.getPixelToLonLat(xRight, yTop, zoom);
        double leftLon = Math.min(lonLatLeftTop.getX(), lonLatLeftBottom.getX());
        double rightLon = Math.max(lonLatRightTop.getX(), lonLatRightBottom.getX());
        double topLat = lonLatLeftTop.getY();
        double bottomLat = lonLatRightBottom.getY();
        double width = Math.abs(rightLon - leftLon);
        double topLatAbs = Math.abs(lonLatLeftTop.getY());
        double bottomLatAbs = Math.abs(lonLatRightBottom.getY());
        double maxLat = Math.max(topLatAbs, bottomLatAbs);
        if (leftLon < 0.0) {
            leftLon -= width * (maxLat / 90.0);
        }
        if (rightLon > 0.0) {
            rightLon += width * (maxLat / 90.0);
        }
        if (leftLon < -180.0) {
            leftLon = -180.0;
        }
        if (rightLon > 180.0) {
            rightLon = 180.0;
        }
        BoundingBox bb = new BoundingBox(leftLon, bottomLat, rightLon, topLat);
        return bb;
    }

    @Override
    public Point getLonLatToPixel(double lon, double lat, double zoom) {
        double phi = Math.toRadians(lat -= this.offsetLat);
        double lambda = Math.toRadians(lon -= this.offsetLon);
        double theta = MollweideTiles.solveTheta(phi);
        double x = 2.0 * Math.sqrt(2.0) / Math.PI * lambda * Math.cos(theta);
        double y = Math.sqrt(2.0) * Math.sin(theta);
        double mapSize = 256.0 * Math.pow(2.0, zoom);
        double pixelX = (x + 2.0 * SQRT2) / (4.0 * SQRT2) * mapSize;
        double pixelY = (1.0 - (y + SQRT2) / (2.0 * SQRT2)) * mapSize;
        return new Point(pixelX, pixelY);
    }

    private static double solveTheta(double phi) {
        double tolerance = 1.0E-10;
        double target = Math.PI * Math.sin(phi);
        double theta = phi;
        int maxIterations = 20;
        for (int i = 0; i < maxIterations; ++i) {
            double f = 2.0 * theta + Math.sin(2.0 * theta) - target;
            double df = 2.0 + 2.0 * Math.cos(2.0 * theta);
            if (df == 0.0) break;
            double delta = f / df;
            theta -= delta;
            if (Math.abs(delta) < tolerance) break;
        }
        return theta;
    }

    @Override
    public Point getPixelToLonLat(double pixelX, double pixelY, double zoom) {
        double mapSize = 256.0 * Math.pow(2.0, zoom);
        double x = pixelX / mapSize * (4.0 * SQRT2) - 2.0 * SQRT2;
        double y = (1.0 - pixelY / mapSize) * (2.0 * SQRT2) - SQRT2;
        double theta = Math.asin(y / SQRT2);
        double sinPhi = (2.0 * theta + Math.sin(2.0 * theta)) / Math.PI;
        double phi = Math.asin(MollweideTiles.clamp(sinPhi, -1.0, 1.0));
        double lat = Math.toDegrees(phi) + this.offsetLat;
        double cosTheta = Math.cos(theta);
        double lambda = x * Math.PI / (2.0 * SQRT2 * cosTheta);
        double lon = Math.toDegrees(lambda) + this.offsetLon;
        if (lon > 360.0) {
            lon = 360.0;
        }
        if (lon < -360.0) {
            lon = -360.0;
        }
        return new Point(lon, lat);
    }

    private static double clamp(double value, double min, double max) {
        return Math.max(min, Math.min(max, value));
    }

    public String toString() {
        return "MollweideTiles[offsetLon=" + this.offsetLon + ", offsetLat=" + this.offsetLat + "]";
    }
}

