/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.output.format;

import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.resources.output.format.AbstractSlippyMapTileOutput;

public class AlbersTiles
extends AbstractSlippyMapTileOutput {
    public static final String NAME = "albers";
    private double phi0 = Math.toRadians(0.0);
    private double lambda0 = Math.toRadians(0.0);
    private double phi1 = Math.toRadians(0.0);
    private double phi2 = Math.toRadians(70.0);
    private double[][] maxTopYForX = new double[361][2];
    private double[][] maxBottomYForX = new double[361][2];

    public AlbersTiles(double lonOrigin, double topLatParallel, double bottomLatParallel) {
        this.lambda0 = lonOrigin;
        this.phi2 = topLatParallel;
        this.phi1 = bottomLatParallel;
        this.calcMinMaxYForX();
    }

    private void calcMinMaxYForX() {
        for (int i = -180; i <= 180; ++i) {
            Point top = this.project(i, 90.0);
            this.maxTopYForX[i + 180][0] = top.getX();
            this.maxTopYForX[i + 180][1] = top.getY();
            Point bottom = this.project(i, -90.0);
            this.maxBottomYForX[i + 180][0] = bottom.getX();
            this.maxBottomYForX[i + 180][1] = bottom.getY();
        }
    }

    private double getMaxTopY(double x) {
        double maxTopY = Double.NaN;
        double minX = this.maxTopYForX[0][0];
        double maxX = this.maxTopYForX[this.maxTopYForX.length - 1][0];
        if (x < minX || x > maxX) {
            return Double.NaN;
        }
        for (int i = 0; i < this.maxTopYForX.length; ++i) {
            if (this.maxTopYForX[i][0] == x) {
                maxTopY = this.maxTopYForX[i][1];
                break;
            }
            if (i >= this.maxTopYForX.length - 1 || !(this.maxTopYForX[i][0] < x) || !(this.maxTopYForX[i + 1][0] > x)) continue;
            maxTopY = Math.min(this.maxTopYForX[i][1], this.maxTopYForX[i + 1][1]);
            break;
        }
        return maxTopY;
    }

    private double getMaxBottomY(double x) {
        double maxBottomY = Double.NaN;
        double minX = this.maxBottomYForX[0][0];
        double maxX = this.maxBottomYForX[this.maxBottomYForX.length - 1][0];
        if (x < minX || x > maxX) {
            return Double.NaN;
        }
        for (int i = 0; i < this.maxBottomYForX.length; ++i) {
            if (this.maxBottomYForX[i][0] == x) {
                maxBottomY = this.maxBottomYForX[i][1];
                break;
            }
            if (i >= this.maxBottomYForX.length - 1 || !(this.maxBottomYForX[i][0] < x) || !(this.maxBottomYForX[i + 1][0] > x)) continue;
            maxBottomY = Math.max(this.maxBottomYForX[i][1], this.maxBottomYForX[i + 1][1]);
            break;
        }
        return maxBottomY;
    }

    @Override
    public String getMapTileOutputName() {
        return NAME;
    }

    @Override
    public double getMeterPerTile(double zoom, double latDegree) {
        return 4.007501668557849E7 * Math.cos(Math.toRadians(latDegree)) / Math.pow(2.0, zoom);
    }

    @Override
    public double getMeterPerPixel(double zoom, double latDegree) {
        return this.getMeterPerTile(zoom, latDegree) / 256.0;
    }

    @Override
    public Point getMinTileIndex(double leftLonDegree, double topLatDegree, double zoom) {
        Point minPixels = this.getLonLatToPixel(leftLonDegree, topLatDegree, zoom);
        double minXPixel = minPixels.getX();
        double minYPixel = minPixels.getY();
        double minXTileIndex = Math.floor(minXPixel / 256.0);
        double minYTileIndex = Math.floor(minYPixel / 256.0);
        if (leftLonDegree == -180.0) {
            minXTileIndex = 0.0;
        }
        return new Point(minXTileIndex, minYTileIndex);
    }

    @Override
    public Point getMaxTileIndex(double rightLonDegree, double bottomLatDegree, double zoom) {
        Point maxPixels = this.getLonLatToPixel(rightLonDegree, bottomLatDegree, zoom);
        double maxXPixel = maxPixels.getX();
        double maxYPixel = maxPixels.getY();
        double maxXTileIndex = Math.floor(maxXPixel / 256.0);
        double maxYTileIndex = Math.floor(maxYPixel / 256.0);
        if (rightLonDegree == 180.0) {
            maxXTileIndex = this.getTileCountPerAxis(zoom);
        }
        return new Point(maxXTileIndex, maxYTileIndex);
    }

    @Override
    public BoundingBox getMinMaxTileBoundingBox(BoundingBox latLonBoundingBox, double zoom) {
        Point minTileIndex = this.getMinTileIndex(latLonBoundingBox.getLeft(), latLonBoundingBox.getTop(), zoom);
        Point maxTileIndex = this.getMaxTileIndex(latLonBoundingBox.getRight(), latLonBoundingBox.getBottom(), zoom);
        int stepCount = 10;
        double width = latLonBoundingBox.getRight() - latLonBoundingBox.getLeft();
        double stepWidth = width / (double)stepCount;
        double minTop = Double.MAX_VALUE;
        double maxBottom = 0.0;
        for (int i = 0; i <= stepCount; ++i) {
            double stepRightLon = latLonBoundingBox.getLeft() + stepWidth * (double)i;
            Point stepMinTileIndex = this.getMinTileIndex(stepRightLon, latLonBoundingBox.getTop(), zoom);
            Point stepMaxTileIndex = this.getMaxTileIndex(stepRightLon, latLonBoundingBox.getBottom(), zoom);
            minTop = Math.min(minTop, stepMinTileIndex.getY());
            minTop = Math.min(minTop, stepMaxTileIndex.getY());
            maxBottom = Math.max(maxBottom, stepMinTileIndex.getY());
            maxBottom = Math.max(maxBottom, stepMaxTileIndex.getY());
        }
        if (minTop < 0.0) {
            minTop = 0.0;
        }
        if (maxBottom < 0.0) {
            maxBottom = 0.0;
        }
        minTileIndex.setY(minTop);
        maxTileIndex.setY(maxBottom);
        return new BoundingBox(minTileIndex, maxTileIndex);
    }

    @Override
    public BoundingBox getBoundingBoxForTile(int zoom, int x, int y) {
        double xLeft = (double)x * 256.0;
        double yTop = (double)y * 256.0;
        double xRight = ((double)x + 1.0) * 256.0;
        double yBottom = ((double)y + 1.0) * 256.0;
        Point lonLatLeftTop = this.getPixelToLonLat(xLeft, yTop, zoom);
        Point lonLatRightBottom = this.getPixelToLonLat(xRight, yBottom, zoom);
        Point lonLatLeftBottom = this.getPixelToLonLat(xLeft, yBottom, zoom);
        Point lonLatRightTop = this.getPixelToLonLat(xRight, yTop, zoom);
        if (Double.isNaN(lonLatLeftTop.getX()) && Double.isNaN(lonLatLeftTop.getY()) && Double.isNaN(lonLatRightBottom.getX()) && Double.isNaN(lonLatRightBottom.getY()) && Double.isNaN(lonLatLeftBottom.getX()) && Double.isNaN(lonLatLeftBottom.getY()) && Double.isNaN(lonLatRightTop.getX()) && Double.isNaN(lonLatRightTop.getY())) {
            return null;
        }
        double centerX = this.getMaxPixels(zoom) / 2.0;
        double centerY = this.getMaxPixels(zoom) / 2.0;
        BoundingBox bb = null;
        if (xLeft < centerX && yTop < centerY) {
            if (Double.isNaN(lonLatLeftTop.getX()) && Double.isNaN(lonLatLeftTop.getY()) && !Double.isNaN(lonLatRightBottom.getX()) && !Double.isNaN(lonLatRightBottom.getY()) && !Double.isNaN(lonLatLeftBottom.getX()) && !Double.isNaN(lonLatLeftBottom.getY()) && Double.isNaN(lonLatRightTop.getX()) && Double.isNaN(lonLatRightTop.getY()) && lonLatLeftBottom.getY() > 45.0 && lonLatRightBottom.getY() > 45.0) {
                if (Double.isNaN(lonLatLeftTop.getX())) {
                    lonLatLeftTop.setX(-180.0);
                }
                if (Double.isNaN(lonLatLeftTop.getY())) {
                    lonLatLeftTop.setY(90.0);
                }
                if (Double.isNaN(lonLatRightTop.getX())) {
                    lonLatRightTop.setX(0.0);
                }
                if (Double.isNaN(lonLatRightTop.getY())) {
                    lonLatRightTop.setY(90.0);
                }
            }
            if (Double.isNaN(lonLatLeftTop.getX()) && Double.isNaN(lonLatLeftTop.getY()) && Double.isNaN(lonLatRightBottom.getX()) && Double.isNaN(lonLatRightBottom.getY()) && Double.isNaN(lonLatLeftBottom.getX()) && Double.isNaN(lonLatLeftBottom.getY()) && !Double.isNaN(lonLatRightTop.getX()) && !Double.isNaN(lonLatRightTop.getY())) {
                if (Double.isNaN(lonLatLeftTop.getX())) {
                    lonLatLeftTop.setX(-180.0);
                }
                if (Double.isNaN(lonLatLeftTop.getY())) {
                    lonLatLeftTop.setY(lonLatRightTop.getY());
                }
                if (Double.isNaN(lonLatRightBottom.getX())) {
                    lonLatRightBottom.setX(0.0);
                }
                if (Double.isNaN(lonLatRightBottom.getY())) {
                    lonLatRightBottom.setY(-90.0);
                }
                if (Double.isNaN(lonLatLeftBottom.getX())) {
                    lonLatLeftBottom.setX(-180.0);
                }
                if (Double.isNaN(lonLatLeftBottom.getY())) {
                    lonLatLeftBottom.setY(-90.0);
                }
            }
            if (Double.isNaN(lonLatLeftTop.getX()) && Double.isNaN(lonLatLeftTop.getY()) && Double.isNaN(lonLatRightBottom.getX()) && Double.isNaN(lonLatRightBottom.getY()) && !Double.isNaN(lonLatLeftBottom.getX()) && !Double.isNaN(lonLatLeftBottom.getY()) && Double.isNaN(lonLatRightTop.getX()) && Double.isNaN(lonLatRightTop.getY())) {
                if (Double.isNaN(lonLatLeftTop.getX())) {
                    lonLatLeftTop.setX(-180.0);
                }
                if (Double.isNaN(lonLatLeftTop.getY())) {
                    lonLatLeftTop.setY(90.0);
                }
                if (Double.isNaN(lonLatRightBottom.getX())) {
                    lonLatRightBottom.setX(0.0);
                }
                if (Double.isNaN(lonLatRightBottom.getY())) {
                    lonLatRightBottom.setY(90.0);
                }
                if (Double.isNaN(lonLatRightTop.getX())) {
                    lonLatRightTop.setX(0.0);
                }
                if (Double.isNaN(lonLatRightTop.getY())) {
                    lonLatRightTop.setY(90.0);
                }
            }
            if (Double.isNaN(lonLatLeftTop.getX()) && Double.isNaN(lonLatLeftTop.getY()) && !Double.isNaN(lonLatRightBottom.getX()) && !Double.isNaN(lonLatRightBottom.getY()) && Double.isNaN(lonLatLeftBottom.getX()) && Double.isNaN(lonLatLeftBottom.getY()) && Double.isNaN(lonLatRightTop.getX()) && Double.isNaN(lonLatRightTop.getY())) {
                if (Double.isNaN(lonLatLeftTop.getX())) {
                    lonLatLeftTop.setX(-180.0);
                }
                if (Double.isNaN(lonLatLeftTop.getY())) {
                    lonLatLeftTop.setY(-90.0);
                }
                if (Double.isNaN(lonLatLeftBottom.getX())) {
                    lonLatLeftBottom.setX(-180.0);
                }
                if (Double.isNaN(lonLatLeftBottom.getY())) {
                    lonLatLeftBottom.setY(-90.0);
                }
                if (Double.isNaN(lonLatRightTop.getX())) {
                    lonLatRightTop.setX(-180.0);
                }
                if (Double.isNaN(lonLatRightTop.getY())) {
                    lonLatRightTop.setY(lonLatRightBottom.getY());
                }
            }
            if (Double.isNaN(lonLatLeftTop.getX())) {
                lonLatLeftTop.setX(-180.0);
            }
            if (Double.isNaN(lonLatLeftTop.getY())) {
                lonLatLeftTop.setY(-90.0);
            }
            if (Double.isNaN(lonLatRightBottom.getX())) {
                lonLatRightBottom.setX(180.0);
            }
            if (Double.isNaN(lonLatRightBottom.getY())) {
                lonLatRightBottom.setY(-90.0);
            }
            if (Double.isNaN(lonLatLeftBottom.getX())) {
                lonLatLeftBottom.setX(-180.0);
            }
            if (Double.isNaN(lonLatLeftBottom.getY())) {
                lonLatLeftBottom.setY(-90.0);
            }
            if (Double.isNaN(lonLatRightTop.getX())) {
                lonLatRightTop.setX(-180.0);
            }
            if (Double.isNaN(lonLatRightTop.getY())) {
                lonLatRightTop.setY(90.0);
            }
            if (lonLatRightBottom.getX() < lonLatLeftBottom.getX()) {
                double diff = lonLatRightBottom.getX() - lonLatLeftBottom.getX();
                lonLatLeftBottom.setX(lonLatLeftBottom.getX() - 3.0 * diff);
            }
            double leftLon = Math.min(lonLatLeftTop.getX(), lonLatRightTop.getX());
            double rightLon = Math.max(lonLatLeftBottom.getX(), lonLatRightBottom.getX());
            double topLat = Math.max(lonLatRightBottom.getY(), lonLatRightTop.getY());
            double bottomLat = Math.min(lonLatLeftTop.getY(), lonLatLeftBottom.getY());
            double latDiff = topLat - bottomLat;
            bb = new BoundingBox(leftLon, bottomLat, rightLon, topLat += latDiff / 10.0);
        } else if (xLeft < centerX && yTop >= centerY) {
            if (Double.isNaN(lonLatLeftTop.getX()) && Double.isNaN(lonLatLeftTop.getY()) && Double.isNaN(lonLatRightBottom.getX()) && Double.isNaN(lonLatRightBottom.getY()) && Double.isNaN(lonLatLeftBottom.getX()) && Double.isNaN(lonLatLeftBottom.getY()) && !Double.isNaN(lonLatRightTop.getX()) && !Double.isNaN(lonLatRightTop.getY())) {
                if (Double.isNaN(lonLatLeftTop.getX())) {
                    lonLatLeftTop.setX(-180.0);
                }
                if (Double.isNaN(lonLatLeftTop.getY())) {
                    lonLatLeftTop.setY(lonLatRightTop.getY());
                }
                if (Double.isNaN(lonLatRightBottom.getX())) {
                    lonLatRightBottom.setX(0.0);
                }
                if (Double.isNaN(lonLatRightBottom.getY())) {
                    lonLatRightBottom.setY(-90.0);
                }
                if (Double.isNaN(lonLatLeftBottom.getX())) {
                    lonLatLeftBottom.setX(-180.0);
                }
                if (Double.isNaN(lonLatLeftBottom.getY())) {
                    lonLatLeftBottom.setY(-90.0);
                }
            }
            if (Double.isNaN(lonLatLeftTop.getX())) {
                lonLatLeftTop.setX(-180.0);
            }
            if (Double.isNaN(lonLatLeftTop.getY())) {
                lonLatLeftTop.setY(90.0);
            }
            if (Double.isNaN(lonLatRightBottom.getX())) {
                lonLatRightBottom.setX(0.0);
            }
            if (Double.isNaN(lonLatRightBottom.getY())) {
                lonLatRightBottom.setY(-90.0);
            }
            if (Double.isNaN(lonLatLeftBottom.getX())) {
                lonLatLeftBottom.setX(-180.0);
            }
            if (Double.isNaN(lonLatLeftBottom.getY())) {
                lonLatLeftBottom.setY(-90.0);
            }
            if (Double.isNaN(lonLatRightTop.getX())) {
                lonLatRightTop.setX(180.0);
            }
            if (Double.isNaN(lonLatRightTop.getY())) {
                lonLatRightTop.setY(90.0);
            }
            double leftLon = Math.min(lonLatLeftTop.getX(), lonLatLeftBottom.getX());
            double rightLon = Math.max(lonLatRightTop.getX(), lonLatRightBottom.getX());
            double topLat = Math.max(lonLatLeftTop.getY(), lonLatRightTop.getY());
            double bottomLat = Math.min(lonLatRightBottom.getY(), lonLatLeftBottom.getY());
            bb = new BoundingBox(leftLon, bottomLat, rightLon, topLat);
        } else if (xLeft >= centerX && yTop >= centerY) {
            if (!Double.isNaN(lonLatLeftTop.getX()) && !Double.isNaN(lonLatLeftTop.getY()) && Double.isNaN(lonLatRightBottom.getX()) && Double.isNaN(lonLatRightBottom.getY()) && Double.isNaN(lonLatLeftBottom.getX()) && Double.isNaN(lonLatLeftBottom.getY()) && Double.isNaN(lonLatRightTop.getX()) && Double.isNaN(lonLatRightTop.getY())) {
                if (Double.isNaN(lonLatRightBottom.getX())) {
                    lonLatRightBottom.setX(180.0);
                }
                if (Double.isNaN(lonLatRightBottom.getY())) {
                    lonLatRightBottom.setY(-90.0);
                }
                if (Double.isNaN(lonLatLeftBottom.getX())) {
                    lonLatLeftBottom.setX(0.0);
                }
                if (Double.isNaN(lonLatLeftBottom.getY())) {
                    lonLatLeftBottom.setY(-90.0);
                }
                if (Double.isNaN(lonLatRightTop.getX())) {
                    lonLatRightTop.setX(180.0);
                }
                if (Double.isNaN(lonLatRightTop.getY())) {
                    lonLatRightTop.setY(lonLatLeftTop.getY());
                }
            }
            if (Double.isNaN(lonLatLeftTop.getX())) {
                lonLatLeftTop.setX(0.0);
            }
            if (Double.isNaN(lonLatLeftTop.getY())) {
                lonLatLeftTop.setY(90.0);
            }
            if (Double.isNaN(lonLatRightBottom.getX())) {
                lonLatRightBottom.setX(180.0);
            }
            if (Double.isNaN(lonLatRightBottom.getY())) {
                lonLatRightBottom.setY(-90.0);
            }
            if (Double.isNaN(lonLatLeftBottom.getX())) {
                lonLatLeftBottom.setX(0.0);
            }
            if (Double.isNaN(lonLatLeftBottom.getY())) {
                lonLatLeftBottom.setY(-90.0);
            }
            if (Double.isNaN(lonLatRightTop.getX())) {
                lonLatRightTop.setX(180.0);
            }
            if (Double.isNaN(lonLatRightTop.getY())) {
                lonLatRightTop.setY(90.0);
            }
            double leftLon = Math.min(lonLatLeftTop.getX(), lonLatLeftBottom.getX());
            double rightLon = Math.max(lonLatRightTop.getX(), lonLatRightBottom.getX());
            double topLat = Math.max(lonLatLeftTop.getY(), lonLatRightTop.getY());
            double bottomLat = Math.min(lonLatRightBottom.getY(), lonLatLeftBottom.getY());
            bb = new BoundingBox(leftLon, bottomLat, rightLon, topLat);
        } else if (xLeft >= centerY && yTop < centerY) {
            if (Double.isNaN(lonLatLeftTop.getX()) && Double.isNaN(lonLatLeftTop.getY()) && !Double.isNaN(lonLatRightBottom.getX()) && !Double.isNaN(lonLatRightBottom.getY()) && !Double.isNaN(lonLatLeftBottom.getX()) && !Double.isNaN(lonLatLeftBottom.getY()) && Double.isNaN(lonLatRightTop.getX()) && Double.isNaN(lonLatRightTop.getY()) && lonLatLeftBottom.getY() > 45.0 && lonLatRightBottom.getY() > 45.0) {
                if (Double.isNaN(lonLatLeftTop.getX())) {
                    lonLatLeftTop.setX(0.0);
                }
                if (Double.isNaN(lonLatLeftTop.getY())) {
                    lonLatLeftTop.setY(90.0);
                }
                if (Double.isNaN(lonLatRightTop.getX())) {
                    lonLatRightTop.setX(180.0);
                }
                if (Double.isNaN(lonLatRightTop.getY())) {
                    lonLatRightTop.setY(90.0);
                }
            }
            if (!Double.isNaN(lonLatLeftTop.getX()) && !Double.isNaN(lonLatLeftTop.getY()) && Double.isNaN(lonLatRightBottom.getX()) && Double.isNaN(lonLatRightBottom.getY()) && Double.isNaN(lonLatLeftBottom.getX()) && Double.isNaN(lonLatLeftBottom.getY()) && Double.isNaN(lonLatRightTop.getX()) && Double.isNaN(lonLatRightTop.getY())) {
                if (Double.isNaN(lonLatRightBottom.getX())) {
                    lonLatRightBottom.setX(180.0);
                }
                if (Double.isNaN(lonLatRightBottom.getY())) {
                    lonLatRightBottom.setY(-90.0);
                }
                if (Double.isNaN(lonLatLeftBottom.getX())) {
                    lonLatLeftBottom.setX(0.0);
                }
                if (Double.isNaN(lonLatLeftBottom.getY())) {
                    lonLatLeftBottom.setY(-90.0);
                }
                if (Double.isNaN(lonLatRightTop.getX())) {
                    lonLatRightTop.setX(180.0);
                }
                if (Double.isNaN(lonLatRightTop.getY())) {
                    lonLatRightTop.setY(lonLatLeftTop.getY());
                }
            }
            if (Double.isNaN(lonLatLeftTop.getX()) && Double.isNaN(lonLatLeftTop.getY()) && !Double.isNaN(lonLatRightBottom.getX()) && !Double.isNaN(lonLatRightBottom.getY()) && Double.isNaN(lonLatLeftBottom.getX()) && Double.isNaN(lonLatLeftBottom.getY()) && Double.isNaN(lonLatRightTop.getX()) && Double.isNaN(lonLatRightTop.getY())) {
                if (Double.isNaN(lonLatLeftTop.getX())) {
                    lonLatLeftTop.setX(0.0);
                }
                if (Double.isNaN(lonLatLeftTop.getY())) {
                    lonLatLeftTop.setY(90.0);
                }
                if (Double.isNaN(lonLatLeftBottom.getX())) {
                    lonLatLeftBottom.setX(0.0);
                }
                if (Double.isNaN(lonLatLeftBottom.getY())) {
                    lonLatLeftBottom.setY(90.0);
                }
                if (Double.isNaN(lonLatRightTop.getX())) {
                    lonLatRightTop.setX(180.0);
                }
                if (Double.isNaN(lonLatRightTop.getY())) {
                    lonLatRightTop.setY(90.0);
                }
            }
            if (Double.isNaN(lonLatLeftTop.getX()) && Double.isNaN(lonLatLeftTop.getY()) && Double.isNaN(lonLatRightBottom.getX()) && Double.isNaN(lonLatRightBottom.getY()) && !Double.isNaN(lonLatLeftBottom.getX()) && !Double.isNaN(lonLatLeftBottom.getY()) && Double.isNaN(lonLatRightTop.getX()) && Double.isNaN(lonLatRightTop.getY())) {
                if (Double.isNaN(lonLatLeftTop.getX())) {
                    lonLatLeftTop.setX(180.0);
                }
                if (Double.isNaN(lonLatLeftTop.getY())) {
                    lonLatLeftTop.setY(lonLatLeftBottom.getY());
                }
                if (Double.isNaN(lonLatRightBottom.getX())) {
                    lonLatRightBottom.setX(180.0);
                }
                if (Double.isNaN(lonLatRightBottom.getY())) {
                    lonLatRightBottom.setY(-90.0);
                }
                if (Double.isNaN(lonLatRightTop.getX())) {
                    lonLatRightTop.setX(180.0);
                }
                if (Double.isNaN(lonLatRightTop.getY())) {
                    lonLatRightTop.setY(-90.0);
                }
            }
            if (Double.isNaN(lonLatLeftTop.getX())) {
                lonLatLeftTop.setX(180.0);
            }
            if (Double.isNaN(lonLatLeftTop.getY())) {
                lonLatLeftTop.setY(90.0);
            }
            if (Double.isNaN(lonLatRightBottom.getX())) {
                lonLatRightBottom.setX(180.0);
            }
            if (Double.isNaN(lonLatRightBottom.getY())) {
                lonLatRightBottom.setY(-90.0);
            }
            if (Double.isNaN(lonLatLeftBottom.getX())) {
                lonLatLeftBottom.setX(0.0);
            }
            if (Double.isNaN(lonLatLeftBottom.getY())) {
                lonLatLeftBottom.setY(90.0);
            }
            if (Double.isNaN(lonLatRightTop.getX())) {
                lonLatRightTop.setX(180.0);
            }
            if (Double.isNaN(lonLatRightTop.getY())) {
                lonLatRightTop.setY(-90.0);
            }
            if (lonLatRightBottom.getX() < lonLatLeftBottom.getX()) {
                double diff = lonLatLeftBottom.getX() - lonLatRightBottom.getX();
                lonLatRightBottom.setX(lonLatRightBottom.getX() - 3.0 * diff);
            }
            double leftLon = Math.min(lonLatLeftBottom.getX(), lonLatRightBottom.getX());
            double rightLon = Math.max(lonLatLeftTop.getX(), lonLatRightTop.getX());
            double topLat = Math.max(lonLatLeftTop.getY(), lonLatLeftBottom.getY());
            double bottomLat = Math.min(lonLatRightBottom.getY(), lonLatRightTop.getY());
            double latDiff = topLat - bottomLat;
            bb = new BoundingBox(leftLon, bottomLat, rightLon, topLat += latDiff / 10.0);
        }
        return bb;
    }

    private double findMin(Double ... doubles) {
        double min = Double.NaN;
        for (int i = 0; i < doubles.length; ++i) {
            if (Double.isNaN(min)) {
                min = doubles[i];
                continue;
            }
            if (Double.isNaN(doubles[i])) continue;
            min = Math.min(min, doubles[i]);
        }
        return min;
    }

    private double findMax(Double ... doubles) {
        double max = Double.NaN;
        for (int i = 0; i < doubles.length; ++i) {
            if (Double.isNaN(max)) {
                max = doubles[i];
                continue;
            }
            if (Double.isNaN(doubles[i])) continue;
            max = Math.max(max, doubles[i]);
        }
        return max;
    }

    @Override
    public Point getLonLatToPixel(double lon, double lat, double zoom) {
        Point pixel = this.project(lon, lat);
        double x = pixel.getX();
        double y = pixel.getY();
        BoundingBox maxProjectionValues = this.getMaxValues(zoom);
        double minX = maxProjectionValues.getLeft();
        double maxX = maxProjectionValues.getRight();
        double minY = maxProjectionValues.getTop();
        double maxY = maxProjectionValues.getBottom();
        double maxWidth = maxX - minX;
        double maxHeight = maxY + maxY;
        double scaleWidth = this.getMaxPixels(zoom) / maxWidth;
        double scaleHeight = this.getMaxPixels(zoom) / maxHeight;
        double scale = Math.min(scaleHeight, scaleWidth);
        double centerX = this.getMaxPixels(zoom) / 2.0;
        double centerY = this.getMaxPixels(zoom) / 2.0;
        double xScaled = centerX + scale * x;
        double yScaled = centerY - scale * y;
        return new Point(xScaled, yScaled);
    }

    @Override
    public Point getPixelToLonLat(double pixelX, double pixelY, double zoom) {
        BoundingBox maxProjectionValues = this.getMaxValues(zoom);
        double minX = maxProjectionValues.getLeft();
        double maxX = maxProjectionValues.getRight();
        double minY = maxProjectionValues.getTop();
        double maxY = maxProjectionValues.getBottom();
        double maxWidth = maxX - minX;
        double maxHeight = maxY + maxY;
        double scaleWidth = this.getMaxPixels(zoom) / maxWidth;
        double scaleHeight = this.getMaxPixels(zoom) / maxHeight;
        double scale = Math.min(scaleHeight, scaleWidth);
        double centerX = this.getMaxPixels(zoom) / 2.0;
        double centerY = this.getMaxPixels(zoom) / 2.0;
        double x = (pixelX - centerX) / scale;
        double y = -(pixelY - centerY) / scale;
        double maxTopY = this.getMaxTopY(x);
        double maxBottomY = this.getMaxBottomY(x);
        if (Double.isNaN(maxTopY) && Double.isNaN(maxBottomY) || !Double.isNaN(maxTopY) && y > maxTopY || !Double.isNaN(maxBottomY) && y < maxBottomY) {
            return new Point(Double.NaN, Double.NaN);
        }
        Point lonLat = this.invertProject(x, y);
        double lon = lonLat.getX();
        double lat = lonLat.getY();
        return new Point(lon, lat);
    }

    private Point project(double lon, double lat) {
        double phi = Math.toRadians(lat);
        double lambda = Math.toRadians(lon);
        double r = 1.0;
        double n = 0.5 * (Math.sin(this.phi1) + Math.sin(this.phi2));
        double theta = n * (lambda - this.lambda0);
        double c = Math.cos(this.phi1) * Math.cos(this.phi1) + 2.0 * n * Math.sin(this.phi1);
        double p = r * Math.sqrt(c - 2.0 * n * Math.sin(phi)) / n;
        double p0 = r * Math.sqrt(c - 2.0 * n * Math.sin(this.phi0)) / n;
        double x = p * Math.sin(theta);
        double y = p0 - p * Math.cos(theta);
        return new Point(x, y);
    }

    private Point invertProject(double x, double y) {
        double n = 0.5 * (Math.sin(this.phi1) + Math.sin(this.phi2));
        double c = Math.cos(this.phi1) * Math.cos(this.phi1) + 2.0 * n * Math.sin(this.phi1);
        double rho0 = Math.sqrt(c - 2.0 * n * Math.sin(this.phi0)) / n;
        double dx = x;
        double dy = rho0 - y;
        double rho = Math.sqrt(dx * dx + dy * dy);
        double theta = Math.atan2(dx, dy);
        double phi = Math.asin((c - rho * rho * n * n) / (2.0 * n));
        double lambda = this.lambda0 + theta / n;
        double lon = Math.toDegrees(lambda);
        double lat = Math.toDegrees(phi);
        return new Point(lon, lat);
    }

    private BoundingBox getMaxValues(double zoom) {
        Point pixelLeftTop = this.project(-180.0, 90.0);
        Point pixelRightBottom = this.project(180.0, -90.0);
        Point pixelLeftBottom = this.project(-180.0, -90.0);
        Point pixelRightTop = this.project(180.0, 90.0);
        Point pixelCenterTop = this.project(0.0, 90.0);
        Point pixelCenterBottom = this.project(0.0, -90.0);
        double left = this.findMin(pixelLeftTop.getX(), pixelRightBottom.getX(), pixelLeftBottom.getX(), pixelRightTop.getX(), pixelCenterTop.getX(), pixelCenterBottom.getX());
        double right = this.findMax(pixelLeftTop.getX(), pixelRightBottom.getX(), pixelLeftBottom.getX(), pixelRightTop.getX(), pixelCenterTop.getX(), pixelCenterBottom.getX());
        double bottom = this.findMin(pixelLeftTop.getY(), pixelRightBottom.getY(), pixelLeftBottom.getY(), pixelRightTop.getY(), pixelCenterTop.getY(), pixelCenterBottom.getY());
        double top = this.findMax(pixelLeftTop.getY(), pixelRightBottom.getY(), pixelLeftBottom.getY(), pixelRightTop.getY(), pixelCenterTop.getY(), pixelCenterBottom.getY());
        return new BoundingBox(left, top, right, bottom);
    }

    public String toString() {
        return "AlbersTiles[]";
    }
}

