/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.lglbw;

import de.wideportal.maprender.config.xml.RenderConfigurationLglBw;
import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.resources.height.HeightCollectorTileCachePersister;
import de.wideportal.maprender.resources.height.ITile;
import de.wideportal.maprender.resources.height.ITileCache;
import de.wideportal.maprender.resources.lglbw.LglBwTile;
import de.wideportal.maprender.resources.lglbw.LglBwTileLoader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LglBwTileCache
implements ITileCache {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private int cacheSize;
    private ArrayList<ITile> tiles;
    private LglBwTileLoader tileLoader;
    private HeightCollectorTileCachePersister collectTileCachePersister;
    private int tilesRemovedFromCache = 0;

    public LglBwTileCache(RenderConfigurationLglBw lglBwConfig) {
        if (lglBwConfig != null) {
            this.cacheSize = lglBwConfig.getCache();
            this.tiles = new ArrayList();
            this.tileLoader = new LglBwTileLoader(lglBwConfig.getFolder(), lglBwConfig.getFormat(), lglBwConfig.getMockMissingTiles(), lglBwConfig.getMockSize());
            if (lglBwConfig.getFileCache() != null) {
                this.collectTileCachePersister = new HeightCollectorTileCachePersister(lglBwConfig.getFileCache(), lglBwConfig.getFileCacheMaxZoom());
            }
        } else {
            this.log.error("LglBwTileCache: Cannot load height tiles since no LglBw configuration is available. This is likely a misconfiguration that will result in broken rendering.");
        }
    }

    @Override
    public void addTile(ITile tile) {
        if (tile != null && !this.tiles.contains(tile)) {
            this.tiles.add(tile);
            if (this.tiles.size() > this.cacheSize) {
                int deleteIndex = 0;
                this.log.debug("addTile: removed tile from cache. Mocked=" + this.getTiles().get(deleteIndex).isMocked() + " / " + this.tiles.get(deleteIndex).getFileName() + " (Cache-size is " + this.tiles.size() + ")");
                this.tiles.remove(deleteIndex);
            }
        }
    }

    @Override
    public synchronized List<ITile> getUnloadedTiles(BoundingBox latLonBBox, int heightDiffThreshold, int heightPointDiffThreshold) {
        return this.getUnloadedTiles(latLonBBox.getLeft(), latLonBBox.getTop(), latLonBBox.getRight(), latLonBBox.getBottom(), heightDiffThreshold, heightPointDiffThreshold);
    }

    @Override
    public synchronized ITile getCachedTile(int easting, int northing, int heightDiffThreshold, int heightPointDiffThreshold) {
        for (int i = 0; i < this.tiles.size(); ++i) {
            ITile tile = this.tiles.get(i);
            if (tile.getLon() != easting || tile.getLat() != northing || tile.getHeightDiffThreshold() != heightDiffThreshold || tile.getHeightPointDiffThreshold() != heightPointDiffThreshold) continue;
            this.tiles.add(tile);
            this.tiles.remove(i);
            ++this.tilesRemovedFromCache;
            if (this.tilesRemovedFromCache % 10 == 0) {
                System.gc();
            }
            return tile;
        }
        LglBwTile tile = new LglBwTile(easting, northing, heightDiffThreshold, heightPointDiffThreshold);
        if (tile != null) {
            this.addTile(tile);
            return tile;
        }
        return null;
    }

    @Override
    public synchronized List<ITile> getUnloadedTiles(double leftEasting, double topNorthing, double rightEasting, double bottomNorthing, int heightDiffThreshold, int heightPointDiffThreshold) {
        ArrayList<ITile> result = new ArrayList<ITile>();
        for (double easting = leftEasting; easting <= rightEasting; easting += 1.0) {
            for (double northing = bottomNorthing; northing <= topNorthing; northing += 1.0) {
                ITile tile = this.getCachedTile((int)easting, (int)northing, heightDiffThreshold, heightPointDiffThreshold);
                if (tile == null) {
                    tile = new LglBwTile((int)easting, (int)northing, heightDiffThreshold, heightPointDiffThreshold);
                    this.addTile(tile);
                }
                result.add(tile);
            }
        }
        return result;
    }

    @Override
    public synchronized ITile loadTile(ITile unloadedTile, int heightDiffThreshold) {
        if (!unloadedTile.isLoaded()) {
            unloadedTile = this.tileLoader.loadTile((LglBwTile)unloadedTile);
        }
        return unloadedTile;
    }

    @Override
    public synchronized ITile loadTileFromFlattenedFile(ITile unloadedTile, int heightDiffThreshold) {
        return unloadedTile;
    }

    @Override
    public ArrayList<ITile> getTiles() {
        return this.tiles;
    }

    @Override
    public Optional<HeightCollectorTileCachePersister> getHeightCollectorTileCachePersister() {
        return Optional.ofNullable(this.collectTileCachePersister);
    }

    public boolean isTileFileExisting(ITile unloadedTile) {
        return this.tileLoader.isTileFileExisting(unloadedTile);
    }

    @Override
    public void purgeZoomSpecificCaches() {
        this.log.info("purgeZoomSpecificCaches()");
        this.tiles.clear();
    }

    @Override
    public void logCache() {
        this.log.info("logCache: starting to log all tiles currently in the LglBw tile cache: #" + this.tiles.size());
        List sortedTiles = this.tiles.stream().sorted(Comparator.comparing(ITile::getFileName)).collect(Collectors.toList());
        for (int i = 0; i < sortedTiles.size(); ++i) {
            this.log.info("logCache: " + i + ": " + ((ITile)sortedTiles.get(i)).getFileName());
        }
    }
}

