/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.kml;

import de.wideportal.maprender.resources.kml.KmlFile;
import java.io.File;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import net.opengis.kml._2.KmlType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KmlFileLoader {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public KmlFile loadKml(String fileName) {
        if (fileName != null) {
            File kmlFile = new File(fileName);
            if (!kmlFile.exists()) {
                this.log.error("loadKml: file does not exist: " + kmlFile.getAbsolutePath());
                return null;
            }
            if (!kmlFile.canRead()) {
                this.log.error("loadKml: file is not readable: " + kmlFile.getAbsolutePath());
                return null;
            }
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{KmlType.class});
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                JAXBElement kmlWrapper = (JAXBElement)jaxbUnmarshaller.unmarshal(kmlFile);
                this.log.info("loadKml: successfully unmashalled kml file: " + fileName);
                KmlFile newKmlFile = new KmlFile(fileName, (KmlType)kmlWrapper.getValue());
                newKmlFile.initialize();
                return newKmlFile;
            }
            catch (Exception e) {
                this.log.error("loadKml: could not unmarshal kml file " + kmlFile.getAbsolutePath(), (Throwable)e);
            }
        } else {
            this.log.error("loadKml: no filename was given");
        }
        return null;
    }
}

