/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.kml;

import de.wideportal.maprender.resources.kml.KmlFile;
import de.wideportal.maprender.resources.kml.KmlFileLoader;
import java.util.ArrayList;
import java.util.Optional;

public class KmlFileCache {
    private int cacheSize = 100;
    private ArrayList<KmlFile> cache = new ArrayList();
    private KmlFileLoader fileLoader = new KmlFileLoader();

    public void addKmlFile(KmlFile kmlFile) {
        if (kmlFile != null && !this.cache.contains(kmlFile)) {
            this.cache.add(kmlFile);
            if (this.cache.size() > this.cacheSize) {
                this.cache.remove(0);
            }
        }
    }

    public Optional<KmlFile> getKmlFile(String fileName) {
        for (KmlFile kmlFile : this.cache) {
            if (!kmlFile.getFileName().equalsIgnoreCase(fileName)) continue;
            return Optional.of(kmlFile);
        }
        KmlFile loadedFile = this.fileLoader.loadKml(fileName);
        if (loadedFile != null) {
            this.addKmlFile(loadedFile);
        }
        return Optional.ofNullable(loadedFile);
    }
}

