/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.height;

import de.wideportal.maprender.deprecated.SrtmCollectTile;
import de.wideportal.maprender.resources.height.HeightCollectorTile;
import de.wideportal.maprender.resources.height.buffer.MultiValueCollectorBuffer;
import de.wideportal.maprender.resources.srtm.buffer.MultipleValueCollectorBuffer;
import de.wideportal.maprender.resources.srtm.buffer.TempOldBuffer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeightMigration {
    protected static Logger log = LoggerFactory.getLogger(HeightMigration.class);
    public String baseFolderSrtm = "C:\\Entwicklung\\Projects\\Maprender\\output\\srtmcache\\collect\\12";
    public String targetFolderSrtm = "C:\\Entwicklung\\Projects\\Maprender\\output\\heightcache\\collect\\12";

    public void migrate() {
        try {
            Path dir = Paths.get(this.baseFolderSrtm, new String[0]);
            ((Stream)Files.walk(dir, new FileVisitOption[0]).parallel()).forEach(path -> this.migrateFile(path.toFile()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info("Done");
    }

    public void migrateFile(File file) {
        String fileName = file.getAbsolutePath();
        if (!fileName.endsWith(".srtmcache")) {
            return;
        }
        fileName = fileName.substring(this.baseFolderSrtm.length());
        Optional<SrtmCollectTile> optionalTile = this.load(file);
        if (optionalTile.isPresent()) {
            SrtmCollectTile tile = optionalTile.get();
            MultipleValueCollectorBuffer srtmBuffer = tile.getMultipleValueBuffer();
            TempOldBuffer tempBuffer = new TempOldBuffer(srtmBuffer.getXSize(), srtmBuffer.getYSize(), srtmBuffer);
            MultiValueCollectorBuffer newBuffer = new MultiValueCollectorBuffer(srtmBuffer.getXSize(), srtmBuffer.getYSize());
            try {
                newBuffer.setBuffer(tempBuffer.getBuffer());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            HeightCollectorTile newTile = new HeightCollectorTile(tile.getLatLonBBox(), tile.getLatLonCollectFromBox(), (int)tile.getPixelTileSize(), tile.getBufferedTileSize(), newBuffer, false, tile.getMinValue(), tile.getMaxValue());
            this.persist(newTile, fileName);
        }
    }

    public void persist(HeightCollectorTile heightCollectorTile, String filename) {
        File yFile;
        String folderName = this.targetFolderSrtm + filename.substring(0, Math.max(filename.lastIndexOf("\\"), filename.lastIndexOf("/")));
        File folder = new File(folderName);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if ((yFile = new File(this.targetFolderSrtm + (filename = filename.substring(0, filename.indexOf("."))) + ".heightcache")).exists()) {
            log.debug("persist: cache was already created");
            return;
        }
        try {
            yFile.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            log.debug("persist: saved height cache file: " + yFile.getAbsolutePath());
        }
        catch (Exception e) {
            log.error("persist: could not write height cache file: " + yFile.getAbsolutePath(), (Throwable)e);
        }
        try (FileOutputStream fout = new FileOutputStream(yFile);
             ZipOutputStream zos = new ZipOutputStream(fout);
             FSTObjectOutput oos = new FSTObjectOutput((OutputStream)zos);){
            ZipEntry innerFile = new ZipEntry("cache");
            zos.putNextEntry(innerFile);
            oos.writeObject((Object)heightCollectorTile, new Class[]{HeightCollectorTile.class});
            log.info("Persisted: " + yFile.getAbsolutePath());
        }
        catch (IOException e) {
            log.error("persist: could not write to file: " + yFile.getAbsolutePath(), (Throwable)e);
        }
    }

    public synchronized Optional<SrtmCollectTile> load(File file) {
        Optional<File> optionalYFile = Optional.of(file);
        SrtmCollectTile result = null;
        File yFile = null;
        if (optionalYFile.isPresent()) {
            yFile = optionalYFile.get();
            if (yFile.exists()) {
                try (FileInputStream fis = new FileInputStream(yFile);
                     ZipInputStream zis = new ZipInputStream(fis);){
                    ZipEntry innerFile = zis.getNextEntry();
                    if (innerFile != null) {
                        FSTObjectInput ois = new FSTObjectInput((InputStream)zis);
                        result = (SrtmCollectTile)ois.readObject(new Class[]{SrtmCollectTile.class});
                        ois.close();
                    }
                }
                catch (Exception e) {
                    log.error("load: could not load from file: " + yFile.getAbsolutePath(), (Throwable)e);
                }
            }
        } else {
            log.debug("load: file is not accessible. Cannot load srtm cache. Base folder is: " + file.getAbsolutePath());
        }
        return Optional.ofNullable(result);
    }
}

