/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.gebco;

import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.request.RenderRequest;
import de.wideportal.maprender.resources.gebco.GebcoTileCache;
import de.wideportal.maprender.resources.height.HeightCollectorTile;
import de.wideportal.maprender.resources.height.HeightCollectorTileCachePersister;
import de.wideportal.maprender.resources.height.ITile;
import de.wideportal.maprender.resources.height.ITileAccessor;
import de.wideportal.maprender.resources.output.format.AbstractMapTileOutput;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GebcoTileAccessor
implements ITileAccessor {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private GebcoTileCache tileCache;

    public GebcoTileAccessor(GebcoTileCache tileCache) {
        this.tileCache = tileCache;
    }

    @Override
    public List<ITile> getCachedTiles() {
        return this.tileCache.getTiles();
    }

    @Override
    public GebcoTileCache getTileCache() {
        return this.tileCache;
    }

    @Override
    public boolean isAvailable() {
        return this.tileCache != null;
    }

    @Override
    public List<ITile> getUnloadedTiles(BoundingBox latLonBBox, int heightDiffThreshold, int heightPointDiffThreshold) {
        return this.tileCache.getUnloadedTiles(latLonBBox, heightDiffThreshold, heightPointDiffThreshold);
    }

    @Override
    public ITile loadTile(ITile unloadedTile, int heightDiffThreshold) {
        return this.tileCache.loadTile(unloadedTile, heightDiffThreshold);
    }

    public boolean isTileFileExisting(ITile unloadedTile) {
        return this.tileCache.isTileFileExisting(unloadedTile);
    }

    @Override
    public void saveCollectedValuesToCache(int zoom, int xTileIndex, int yTileIndex, HeightCollectorTile srtmCollectTile, int heightDiffThreshold, int heightPointDiffThreshold) {
        Optional<HeightCollectorTileCachePersister> optionalCollectTileCachePersister = this.tileCache.getHeightCollectorTileCachePersister();
        if (optionalCollectTileCachePersister.isPresent()) {
            optionalCollectTileCachePersister.get().persist(zoom, xTileIndex, yTileIndex, srtmCollectTile, heightDiffThreshold, heightPointDiffThreshold);
            this.log.debug("saveCollectedValuesToCache(): Gebco tile was saved to cache");
        } else {
            this.log.debug("saveCollectedValuesToCache(): no Gebco tile cache configured");
        }
    }

    @Override
    public HeightCollectorTile[] collectSurroundingValues(int zoom, int xTileIndex, int yTileIndex, BoundingBox latLonBoundingBox, RenderRequest renderRequest, long tileSize, boolean renderMockTiles, int heightDiffThreshold, int heightPointDiffThreshold, AbstractMapTileOutput tileOutputter) {
        HeightCollectorTile[] tiles = new HeightCollectorTile[9];
        int counter = 0;
        for (int yShift = -1; yShift <= 1; ++yShift) {
            for (int xShift = -1; xShift <= 1; ++xShift) {
                HeightCollectorTile currentTile;
                double pixelsPerTile = tileOutputter.getPixelsPerTile(zoom);
                int indexTileY = yTileIndex + yShift;
                double indexPixelYTop = (double)indexTileY * pixelsPerTile;
                double indexPixelYBottom = (double)(indexTileY + 1) * pixelsPerTile;
                int indexTileX = xTileIndex + xShift;
                double indexPixelXLeft = (double)indexTileX * pixelsPerTile;
                double indexPixelXRight = (double)(indexTileX + 1) * pixelsPerTile;
                Point lonLatLeftTop = tileOutputter.getPixelToLonLat(indexPixelXLeft, indexPixelYTop, zoom);
                Point lonLatrightBottom = tileOutputter.getPixelToLonLat(indexPixelXRight, indexPixelYBottom, zoom);
                double latTop = lonLatLeftTop.getY();
                double latBottom = lonLatrightBottom.getY();
                double lonLeft = lonLatLeftTop.getX();
                double lonRight = lonLatrightBottom.getX();
                BoundingBox subTileBBox = new BoundingBox(lonLeft, latBottom, lonRight, latTop);
                tiles[counter] = currentTile = this.collectValues(zoom, xTileIndex + xShift, yTileIndex + yShift, subTileBBox, renderRequest, tileSize, renderMockTiles, heightDiffThreshold, heightPointDiffThreshold, tileOutputter);
                ++counter;
            }
        }
        return tiles;
    }

    @Override
    public HeightCollectorTile collectValues(int zoom, int xTileIndex, int yTileIndex, BoundingBox latLonBBox, RenderRequest renderRequest, long tileSize, boolean renderMockTiles, int heightDiffThreshold, int heightPointDiffThreshold, AbstractMapTileOutput tileOutputter) {
        ITile neededTile;
        int lat;
        int lon;
        Optional<HeightCollectorTileCachePersister> optionalCollectTileCachePersister = this.tileCache.getHeightCollectorTileCachePersister();
        if (optionalCollectTileCachePersister.isPresent()) {
            Optional<HeightCollectorTile> optionalResult = optionalCollectTileCachePersister.get().load(zoom, xTileIndex, yTileIndex, heightDiffThreshold, heightPointDiffThreshold);
            if (optionalResult.isPresent()) {
                this.log.debug("collectValues(): Gebco tile was found in cache");
                return optionalResult.get();
            }
        } else {
            this.log.debug("collectValues(): no Gebco tile cache configured");
        }
        BoundingBox latLonBoundingBox = renderRequest.getBoundingBoxLatLon();
        double collectorTileWidthLon = latLonBoundingBox.getWidth();
        double collectorTileHeightLat = latLonBoundingBox.getHeight();
        double requiredBorderBufferPixel = 50.0;
        double increaseCollectorBoundsForCloseupZoomlevels = 1.0 / collectorTileWidthLon / 60.0;
        if (increaseCollectorBoundsForCloseupZoomlevels < 1.0) {
            increaseCollectorBoundsForCloseupZoomlevels = 1.0;
        }
        double increaseLon = requiredBorderBufferPixel * collectorTileWidthLon / (double)tileSize * increaseCollectorBoundsForCloseupZoomlevels;
        double increaseLat = requiredBorderBufferPixel * collectorTileHeightLat / (double)tileSize * increaseCollectorBoundsForCloseupZoomlevels;
        BoundingBox increasedLatLonBBox = new BoundingBox(latLonBoundingBox.getLeft() - increaseLon, latLonBoundingBox.getBottom() - increaseLat, latLonBoundingBox.getRight() + increaseLon, latLonBoundingBox.getTop() + increaseLat);
        HeightCollectorTile heightCollectorTile = new HeightCollectorTile(latLonBoundingBox, increasedLatLonBBox, (int)tileSize);
        double margin = 0.01;
        double leftLon = latLonBoundingBox.getLeft() - margin;
        double topLat = latLonBoundingBox.getTop() + margin;
        double rightLon = latLonBoundingBox.getRight() + margin;
        double bottomLat = latLonBoundingBox.getBottom() - margin;
        int leftLonBound = (int)Math.floor(leftLon);
        int rightLonBound = (int)Math.ceil(rightLon);
        int topLatBound = (int)Math.ceil(topLat);
        int bottomLatBound = (int)Math.floor(bottomLat);
        topLatBound = topLatBound >= 0 ? 90 : 0;
        bottomLatBound = bottomLatBound >= 0 ? 0 : -90;
        if (leftLonBound < -180) {
            leftLonBound = -270;
        } else if (leftLonBound > 180) {
            leftLonBound = -180;
        } else if (leftLonBound >= -180 && leftLonBound < -90) {
            leftLonBound = -180;
        } else if (leftLonBound >= -90 && leftLonBound < 0) {
            leftLonBound = -90;
        } else if (leftLonBound >= 0 && leftLonBound < 90) {
            leftLonBound = 0;
        } else if (leftLonBound >= 90 && leftLonBound < 180) {
            leftLonBound = 90;
        }
        if (rightLonBound < -180) {
            rightLonBound = -180;
        } else if (rightLonBound > 180) {
            rightLonBound = 270;
        } else if (rightLonBound >= -180 && rightLonBound < -90) {
            rightLonBound = -90;
        } else if (rightLonBound >= -90 && rightLonBound < 0) {
            rightLonBound = 0;
        } else if (rightLonBound >= 0 && rightLonBound < 90) {
            rightLonBound = 90;
        } else if (rightLonBound >= 90 && rightLonBound < 180) {
            rightLonBound = 180;
        }
        int gebcoTilesToLoadCount = 0;
        for (int lon2 = leftLonBound; lon2 < rightLonBound; lon2 += 90) {
            for (int lat2 = bottomLatBound; lat2 < topLatBound; lat2 += 90) {
                ++gebcoTilesToLoadCount;
            }
        }
        if (gebcoTilesToLoadCount > 10) {
            this.log.info("collectValues(): Approximately " + gebcoTilesToLoadCount + "+ Gebco tiles will be required");
        }
        if (gebcoTilesToLoadCount > 30) {
            this.log.info("collectValues(): Starting to check if all tiles are mocked");
        }
        boolean isAtLeastOneTileNotMocked = false;
        for (lon = leftLonBound; lon < rightLonBound && !isAtLeastOneTileNotMocked; lon += 90) {
            for (lat = bottomLatBound; lat < topLatBound && !isAtLeastOneTileNotMocked; lat += 90) {
                neededTile = this.tileCache.getCachedTile(lon, lat, heightDiffThreshold, heightPointDiffThreshold);
                boolean isTileFileExisting = this.tileCache.isTileFileExisting(neededTile);
                if (!isTileFileExisting) continue;
                isAtLeastOneTileNotMocked = true;
            }
        }
        if (gebcoTilesToLoadCount > 30) {
            if (isAtLeastOneTileNotMocked) {
                this.log.info("collectValues(): There are unmocked tiles, therefor continuing with normal collection of tiles");
            } else {
                this.log.info("collectValues(): All tiles would be mocked, therefor setting all tile values to 0");
            }
        }
        if (!isAtLeastOneTileNotMocked) {
            if (heightCollectorTile != null) {
                this.saveCollectedValuesToCache(zoom, xTileIndex, yTileIndex, heightCollectorTile, heightDiffThreshold, heightPointDiffThreshold);
            }
            return heightCollectorTile;
        }
        for (lon = leftLonBound; lon < rightLonBound; lon += 90) {
            for (lat = bottomLatBound; lat < topLatBound; lat += 90) {
                neededTile = this.tileCache.getCachedTile(lon, lat, heightDiffThreshold, heightPointDiffThreshold);
                if (!neededTile.isLoaded() && (neededTile = this.loadTile(neededTile, heightDiffThreshold)) == null) {
                    return null;
                }
                if (neededTile.isMocked() && !renderMockTiles) continue;
                heightCollectorTile = neededTile.renderIntoCollector(zoom, xTileIndex, yTileIndex, renderRequest, heightCollectorTile, tileOutputter, this.tileCache);
            }
        }
        if (heightCollectorTile != null) {
            this.saveCollectedValuesToCache(zoom, xTileIndex, yTileIndex, heightCollectorTile, heightDiffThreshold, heightPointDiffThreshold);
        }
        return heightCollectorTile;
    }
}

